/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.event;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.creativity0.livetranslator.event.TranslatorEvent;
import net.creativity0.livetranslator.event.TranslatorEventListener;

public class TranslatorEventBus {
    private static final List<TranslatorEventListener> LISTENERS = new CopyOnWriteArrayList<TranslatorEventListener>();

    public static void register(TranslatorEventListener listener) {
        LISTENERS.add(listener);
    }

    public static void unregister(TranslatorEventListener listener) {
        LISTENERS.remove(listener);
    }

    public static void post(TranslatorEvent event) {
        for (TranslatorEventListener listener : LISTENERS) {
            try {
                listener.onTranslatorEvent(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

