/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.event;

import net.creativity0.livetranslator.event.TranslatorEvent;
import net.creativity0.livetranslator.event.TranslatorEventListener;
import net.creativity0.livetranslator.utility.LiveTranslatorLogger;

public class TranslatorLoggerListener
implements TranslatorEventListener {
    @Override
    public void onTranslatorEvent(TranslatorEvent event) {
        switch (event.getType()) {
            case TRANSLATOR_START: {
                LiveTranslatorLogger.LOGGER.info("Starting translator...");
                break;
            }
            case DEPENDENCY_CHECK_START: {
                LiveTranslatorLogger.LOGGER.info("Checking Python installation...");
                break;
            }
            case ENV_SETUP_START: {
                LiveTranslatorLogger.LOGGER.info("Setting up Python virtual environment...");
                break;
            }
            case DEPENDENCIES_INSTALL_START: {
                LiveTranslatorLogger.LOGGER.info("Installing Python dependencies...");
                break;
            }
            case MODEL_DOWNLOAD_PROGRESS: {
                LiveTranslatorLogger.LOGGER.info("Model download: {}%", (Object)event.getProgress());
                break;
            }
            case MODEL_DOWNLOAD_COMPLETE: {
                LiveTranslatorLogger.LOGGER.info("Model download complete!");
                break;
            }
            case SERVER_STARTING: {
                LiveTranslatorLogger.LOGGER.info("Starting CTranslate2 Python server...");
                break;
            }
            case TRANSLATOR_READY: {
                LiveTranslatorLogger.LOGGER.info("Translator ready.");
                break;
            }
            case STOPPED: {
                LiveTranslatorLogger.LOGGER.info("Translator stopped.");
                break;
            }
            case ERROR: {
                LiveTranslatorLogger.LOGGER.error("Translator error: {}", (Object)event.getMessage());
                break;
            }
            default: {
                LiveTranslatorLogger.LOGGER.debug("[{}] {}", (Object)event.getType(), (Object)event.getMessage());
            }
        }
    }
}

