/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.settings;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.creativity0.livetranslator.config.PlayerTranslationSettings;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class ServerPlayerTranslationSettings
extends SavedData {
    private static final String STATE_KEY = "livetranslator_player_settings";
    private static final SavedData.Factory<ServerPlayerTranslationSettings> FACTORY = new SavedData.Factory(ServerPlayerTranslationSettings::new, ServerPlayerTranslationSettings::fromNbt, DataFixTypes.LEVEL);
    private final Map<UUID, PlayerTranslationSettings> perPlayer = new HashMap<UUID, PlayerTranslationSettings>();

    public PlayerTranslationSettings get(UUID uuid) {
        return this.perPlayer.getOrDefault(uuid, PlayerTranslationSettings.defaults());
    }

    public void setLanguage(UUID uuid, String lang) {
        PlayerTranslationSettings current = this.get(uuid);
        this.perPlayer.put(uuid, current.withLanguage(lang));
        this.setDirty();
    }

    public void setTranslationsEnabled(UUID uuid, boolean enabled) {
        PlayerTranslationSettings current = this.get(uuid);
        this.perPlayer.put(uuid, current.withTranslationsEnabled(enabled));
        this.setDirty();
    }

    public static ServerPlayerTranslationSettings fromNbt(CompoundTag nbt, HolderLookup.Provider provider) {
        ServerPlayerTranslationSettings state = new ServerPlayerTranslationSettings();
        CompoundTag players = nbt.getCompound("players");
        for (String key : players.getAllKeys()) {
            UUID uuid = UUID.fromString(key);
            CompoundTag entry = players.getCompound(key);
            String lang = entry.getString("language");
            boolean enabled = entry.getBoolean("translationsEnabled");
            state.perPlayer.put(uuid, new PlayerTranslationSettings(lang, enabled));
        }
        return state;
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        CompoundTag players = new CompoundTag();
        for (Map.Entry<UUID, PlayerTranslationSettings> entry : this.perPlayer.entrySet()) {
            CompoundTag playerNbt = new CompoundTag();
            PlayerTranslationSettings settings = entry.getValue();
            playerNbt.putString("language", settings.language());
            playerNbt.putBoolean("translationsEnabled", settings.translationsEnabled());
            players.put(entry.getKey().toString(), (Tag)playerNbt);
        }
        nbt.put("players", (Tag)players);
        return nbt;
    }

    public static ServerPlayerTranslationSettings get(MinecraftServer server) {
        ServerLevel overworld = server.getLevel(Level.OVERWORLD);
        if (overworld == null) {
            throw new IllegalStateException("Overworld is not available yet");
        }
        return (ServerPlayerTranslationSettings)overworld.getDataStorage().computeIfAbsent(FACTORY, STATE_KEY);
    }
}

