/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.translation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.creativity0.livetranslator.config.TranslationSettings;
import net.creativity0.livetranslator.event.TranslatorEvent;
import net.creativity0.livetranslator.event.TranslatorEventBus;
import net.creativity0.livetranslator.translation.Translator;
import net.creativity0.livetranslator.translation.ctranslate2.CTranslate2;
import net.creativity0.livetranslator.utility.LiveTranslatorLogger;

public class TranslatorManager {
    private static final Map<String, Translator> REGISTERED_TRANSLATORS = new HashMap<String, Translator>();
    private static final String DEFAULT_TRANSLATOR_ID = "m2m100_418M_ct2_int8";
    private static Translator currentTranslator;

    private static void registerTranslator(String name, Translator translator) {
        REGISTERED_TRANSLATORS.put(name, translator);
    }

    public static Translator getCurrentTranslator() {
        return currentTranslator;
    }

    public static String setCurrentTranslator(String name) {
        Translator translator = REGISTERED_TRANSLATORS.get(name);
        if (translator == null) {
            LiveTranslatorLogger.LOGGER.error("Translator not found: {}", (Object)name);
            return null;
        }
        if (translator.equals(currentTranslator)) {
            LiveTranslatorLogger.LOGGER.info("Translator '{}' is already active.", (Object)name);
            return null;
        }
        currentTranslator.stop();
        currentTranslator = translator;
        if (TranslationSettings.getTranslationEnabled()) {
            TranslatorManager.startTranslator();
        }
        return name;
    }

    public static String getCurrentTranslatorName() {
        for (Map.Entry<String, Translator> entry : REGISTERED_TRANSLATORS.entrySet()) {
            if (!entry.getValue().equals(currentTranslator)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Set<String> getAvailableTranslatorNames() {
        return REGISTERED_TRANSLATORS.keySet();
    }

    public static void startTranslator() {
        TranslatorEventBus.post(new TranslatorEvent(TranslatorEvent.Type.TRANSLATOR_START));
        try {
            currentTranslator.start();
        }
        catch (Exception e) {
            TranslatorEventBus.post(new TranslatorEvent(TranslatorEvent.Type.ERROR, e));
        }
    }

    public static void stopTranslator() {
        currentTranslator.stop();
    }

    public static Translator.TranslationResult translate(String text, String targetLang) {
        return TranslatorManager.translate(text, targetLang, "auto");
    }

    public static Translator.TranslationResult translate(String text, String target, String source) {
        return currentTranslator.translate(text, target, source);
    }

    public static Map<String, Translator.TranslationResult> translateBatch(String originalMessage, List<String> targetLangs) {
        return currentTranslator.translateBatch(originalMessage, targetLangs, "auto");
    }

    static {
        CTranslate2 ct2 = new CTranslate2();
        TranslatorManager.registerTranslator(DEFAULT_TRANSLATOR_ID, ct2);
        currentTranslator = ct2;
    }
}

