/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.translation.ctranslate2;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.creativity0.livetranslator.translation.Translator;
import net.creativity0.livetranslator.utility.LiveTranslatorLogger;

public class CTranslate2Client {
    private static final String SERVER_URL = "http://127.0.0.1:5005/translate";
    private static final String BATCH_URL = "http://127.0.0.1:5005/translate/batch";
    private static final Gson gson = new Gson();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Translator.TranslationResult translate(String text, String targetLang, String sourceLang) {
        try {
            URL url = new URL(SERVER_URL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(5000);
            TranslationRequest request = new TranslationRequest(text, sourceLang, targetLang);
            String jsonInput = gson.toJson((Object)request);
            try (OutputStream os = conn.getOutputStream();){
                os.write(jsonInput.getBytes(StandardCharsets.UTF_8));
            }
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                LiveTranslatorLogger.LOGGER.error("Translation request failed with code: " + responseCode);
                return null;
            }
            try (InputStreamReader reader = new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8);){
                TranslationResponse response = (TranslationResponse)gson.fromJson((Reader)reader, TranslationResponse.class);
                if (response == null || response.translatedText == null) {
                    LiveTranslatorLogger.LOGGER.error("Translation response was null/invalid");
                    Translator.TranslationResult translationResult = null;
                    return translationResult;
                }
                Translator.TranslationResult translationResult = new Translator.TranslationResult(response.translatedText, response.detectedLanguage);
                return translationResult;
            }
        }
        catch (Exception e) {
            LiveTranslatorLogger.LOGGER.error("Error translating text", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Translator.TranslationResult> translateBatch(String text, List<String> targetLangs, String sourceLang) {
        if (text == null) return Collections.emptyMap();
        if (text.isBlank()) return Collections.emptyMap();
        if (targetLangs == null) return Collections.emptyMap();
        if (targetLangs.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<String> uniqueLangs = new ArrayList<String>(new LinkedHashSet<String>(targetLangs));
        uniqueLangs.removeIf(l -> l == null || l.isBlank());
        if (uniqueLangs.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            URL url = new URL(BATCH_URL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(15000);
            BatchTranslationRequest request = new BatchTranslationRequest(text, sourceLang, uniqueLangs);
            String jsonInput = gson.toJson((Object)request);
            try (OutputStream os = conn.getOutputStream();){
                os.write(jsonInput.getBytes(StandardCharsets.UTF_8));
            }
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                LiveTranslatorLogger.LOGGER.error("Batch translation request failed with code: {}", (Object)responseCode);
                return Collections.emptyMap();
            }
            try (InputStreamReader reader = new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8);){
                BatchTranslationResponse response = (BatchTranslationResponse)gson.fromJson((Reader)reader, BatchTranslationResponse.class);
                if (response == null || response.translations == null) {
                    LiveTranslatorLogger.LOGGER.error("Batch translation response was null/invalid");
                    Map<String, Translator.TranslationResult> map = Collections.emptyMap();
                    return map;
                }
                HashMap<String, Translator.TranslationResult> results = new HashMap<String, Translator.TranslationResult>();
                for (String lang : uniqueLangs) {
                    String translated = response.translations.get(lang);
                    if (translated == null) {
                        LiveTranslatorLogger.LOGGER.warn("Batch translation missing result for targetLang={}", (Object)lang);
                        continue;
                    }
                    results.put(lang, new Translator.TranslationResult(translated, response.detectedLanguage));
                }
                HashMap<String, Translator.TranslationResult> hashMap = results;
                return hashMap;
            }
        }
        catch (Exception e) {
            LiveTranslatorLogger.LOGGER.error("Error batch translating text", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private static class TranslationRequest {
        @SerializedName(value="text")
        String text;
        @SerializedName(value="sourceLanguage")
        String sourceLang;
        @SerializedName(value="targetLanguage")
        String targetLang;

        TranslationRequest(String text, String sourceLang, String targetLang) {
            this.text = text;
            this.sourceLang = Objects.equals(sourceLang, "auto") ? null : sourceLang;
            this.targetLang = targetLang;
        }
    }

    private static class TranslationResponse {
        @SerializedName(value="translatedText")
        String translatedText;
        @SerializedName(value="detectedLanguage")
        String detectedLanguage;

        private TranslationResponse() {
        }
    }

    private static class BatchTranslationRequest {
        @SerializedName(value="text")
        String text;
        @SerializedName(value="sourceLanguage")
        String sourceLang;
        @SerializedName(value="targetLanguages")
        List<String> targetLanguages;

        BatchTranslationRequest(String text, String sourceLang, List<String> targetLanguages) {
            this.text = text;
            this.sourceLang = Objects.equals(sourceLang, "auto") ? null : sourceLang;
            this.targetLanguages = targetLanguages;
        }
    }

    private static class BatchTranslationResponse {
        @SerializedName(value="detectedLanguage")
        String detectedLanguage;
        @SerializedName(value="translations")
        Map<String, String> translations;

        private BatchTranslationResponse() {
        }
    }
}

