/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.translation.ctranslate2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.creativity0.livetranslator.event.TranslatorEvent;
import net.creativity0.livetranslator.event.TranslatorEventBus;
import net.creativity0.livetranslator.utility.SharedPackageDir;

public class CTranslate2ModelManager {
    private static final String DEFAULT_MODEL_BASE_URL = "https://huggingface.co/creativity0/m2m100_418M_ct2_int8/resolve/main";
    private static final Path MODELS_DIR = SharedPackageDir.getSharedDir().resolve("ctranslate2/models");
    private static final String MODEL_NAME = "m2m100_418M_ct2_int8";
    private static final Path DEFAULT_MODEL_DIR = MODELS_DIR.resolve("m2m100_418M_ct2_int8");
    private static final String[] MODEL_FILES = new String[]{"config.json", "model.bin", "shared_vocabulary.json"};

    public static void ensureModelAvailable() throws IOException {
        try {
            if (Files.exists(DEFAULT_MODEL_DIR, new LinkOption[0]) && Files.isDirectory(DEFAULT_MODEL_DIR, new LinkOption[0])) {
                return;
            }
            Files.createDirectories(DEFAULT_MODEL_DIR, new FileAttribute[0]);
            TranslatorEventBus.post(new TranslatorEvent(TranslatorEvent.Type.MODEL_DOWNLOAD_PROGRESS, 0));
            long totalSize = 0L;
            for (String file : MODEL_FILES) {
                HttpURLConnection conn = (HttpURLConnection)new URL("https://huggingface.co/creativity0/m2m100_418M_ct2_int8/resolve/main/" + file).openConnection();
                totalSize += Math.max(conn.getContentLengthLong(), 0L);
                conn.disconnect();
            }
            long totalDownloaded = 0L;
            for (String file : MODEL_FILES) {
                String fileUrl = "https://huggingface.co/creativity0/m2m100_418M_ct2_int8/resolve/main/" + file;
                Path filePath = DEFAULT_MODEL_DIR.resolve(file);
                totalDownloaded = CTranslate2ModelManager.downloadFile(fileUrl, filePath, totalSize, totalDownloaded);
            }
            TranslatorEventBus.post(new TranslatorEvent(TranslatorEvent.Type.MODEL_DOWNLOAD_COMPLETE));
        }
        catch (Exception e) {
            TranslatorEventBus.post(new TranslatorEvent(TranslatorEvent.Type.ERROR, e));
            throw new IOException(e);
        }
    }

    private static long downloadFile(String urlStr, Path outputPath, long totalSize, long totalDownloadedSoFar) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(urlStr).openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(30000);
        conn.setRequestProperty("User-Agent", "MinecraftLiveTranslator/1.0");
        long fileSize = Math.max(conn.getContentLengthLong(), 0L);
        long fileDownloaded = 0L;
        int lastPercent = -1;
        try (InputStream in = conn.getInputStream();
             OutputStream out = Files.newOutputStream(outputPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = in.read(buffer)) != -1) {
                long totalNow;
                int percent;
                out.write(buffer, 0, len);
                if (totalSize <= 0L || (percent = (int)((totalNow = totalDownloadedSoFar + (fileDownloaded += (long)len)) * 100L / totalSize)) == lastPercent || percent % 5 != 0 || percent <= 0) continue;
                lastPercent = percent;
                TranslatorEventBus.post(new TranslatorEvent(TranslatorEvent.Type.MODEL_DOWNLOAD_PROGRESS, percent));
            }
        }
        return totalDownloadedSoFar + fileDownloaded;
    }
}

