/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.translation.ctranslate2;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import net.creativity0.livetranslator.event.TranslatorEvent;
import net.creativity0.livetranslator.event.TranslatorEventBus;
import net.creativity0.livetranslator.translation.ctranslate2.CTranslate2ModelManager;
import net.creativity0.livetranslator.utility.LiveTranslatorLogger;
import net.creativity0.livetranslator.utility.ModDataFolder;
import net.creativity0.livetranslator.utility.SharedPackageDir;

public class CTranslate2ServerManager {
    private static final Path VENV_PATH = ModDataFolder.get().resolve("venv");
    private static final Path SERVER_SCRIPT = ModDataFolder.get().resolve("ctranslate2").resolve("server.py");
    private static volatile boolean isInitialized = false;
    private static Process serverProcess;
    private static final int PORT = 5005;
    private static final Path MODEL_DIR;

    public static synchronized void startServer() {
        new Thread(() -> {
            try {
                if (!isInitialized) {
                    CTranslate2ServerManager.initialize();
                }
                Path pythonPath = CTranslate2ServerManager.getPythonVenvPath();
                if (serverProcess == null || !serverProcess.isAlive()) {
                    ProcessBuilder pb = new ProcessBuilder(pythonPath.toString(), SERVER_SCRIPT.toAbsolutePath().toString(), MODEL_DIR.toString());
                    pb.redirectErrorStream(true);
                    TranslatorEventBus.post(new TranslatorEvent(TranslatorEvent.Type.SERVER_STARTING));
                    serverProcess = pb.start();
                    CTranslate2ServerManager.startProcessLogger(serverProcess, "[ct2-server]", "CTranslate2-Server-Log", true);
                }
                if (CTranslate2ServerManager.waitForServerHealthy(60)) {
                    TranslatorEventBus.post(new TranslatorEvent(TranslatorEvent.Type.TRANSLATOR_READY));
                } else {
                    TranslatorEventBus.post(new TranslatorEvent(TranslatorEvent.Type.ERROR, new IllegalStateException("CTranslate2 server failed to start in time.")));
                    CTranslate2ServerManager.stopServer();
                }
            }
            catch (Exception e) {
                TranslatorEventBus.post(new TranslatorEvent(TranslatorEvent.Type.ERROR, e));
            }
        }, "CTranslate2-Server-Thread").start();
    }

    public static synchronized void stopServer() {
        if (serverProcess != null && serverProcess.isAlive()) {
            TranslatorEventBus.post(new TranslatorEvent(TranslatorEvent.Type.STOPPED));
            serverProcess.destroy();
            try {
                if (!serverProcess.waitFor(5L, TimeUnit.SECONDS)) {
                    serverProcess.destroyForcibly();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            serverProcess = null;
        }
    }

    private static void initialize() throws IOException, InterruptedException {
        TranslatorEventBus.post(new TranslatorEvent(TranslatorEvent.Type.DEPENDENCY_CHECK_START));
        CTranslate2ServerManager.assertPythonIsInstalled();
        CTranslate2ModelManager.ensureModelAvailable();
        TranslatorEventBus.post(new TranslatorEvent(TranslatorEvent.Type.ENV_SETUP_START));
        CTranslate2ServerManager.setupVenv();
        TranslatorEventBus.post(new TranslatorEvent(TranslatorEvent.Type.DEPENDENCIES_INSTALL_START));
        CTranslate2ServerManager.installDependencies();
        CTranslate2ServerManager.ensureServerScriptExists();
        CTranslate2ServerManager.ensureSharedModelFolderExists();
        isInitialized = true;
    }

    private static void assertPythonIsInstalled() throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder("python", "--version");
        pb.redirectErrorStream(true);
        Process process = pb.start();
        process.waitFor();
        if (process.exitValue() != 0) {
            throw new IOException("Python not found in PATH");
        }
    }

    private static Path getPythonVenvPath() {
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            return VENV_PATH.resolve("Scripts").resolve("python.exe");
        }
        return VENV_PATH.resolve("bin").resolve("python");
    }

    private static void setupVenv() throws IOException, InterruptedException {
        if (!VENV_PATH.toFile().exists()) {
            ProcessBuilder pb = new ProcessBuilder("python", "-m", "venv", VENV_PATH.toString());
            pb.inheritIO();
            Process process = pb.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new IOException("Failed to create venv (exit code " + exitCode + ")");
            }
        }
    }

    private static void ensureServerScriptExists() throws IOException {
        if (!Files.exists(SERVER_SCRIPT, new LinkOption[0])) {
            Files.createDirectories(SERVER_SCRIPT.getParent(), new FileAttribute[0]);
            try (InputStream in = CTranslate2ServerManager.class.getClassLoader().getResourceAsStream("ctranslate2/server.py");){
                if (in == null) {
                    throw new FileNotFoundException("ctranslate2/server.py not found in resources");
                }
                Files.copy(in, SERVER_SCRIPT, new CopyOption[0]);
            }
        }
    }

    private static void ensureSharedModelFolderExists() throws IOException {
        Files.createDirectories(MODEL_DIR, new FileAttribute[0]);
    }

    private static void installDependencies() throws IOException, InterruptedException {
        Path pythonPath = CTranslate2ServerManager.getPythonVenvPath();
        ProcessBuilder pb = new ProcessBuilder(pythonPath.toString(), "-m", "pip", "install", "ctranslate2", "sentencepiece", "transformers", "fastapi", "uvicorn", "langid");
        pb.redirectErrorStream(true);
        Process process = pb.start();
        Thread logThread = CTranslate2ServerManager.startProcessLogger(process, "[pip]", "CTranslate2-Pip-Logger", true);
        int exitCode = process.waitFor();
        logThread.join();
        if (exitCode != 0) {
            throw new IOException("Failed to install dependencies (exit code " + exitCode + ")");
        }
    }

    private static Thread startProcessLogger(Process process, String prefix, String threadName, boolean daemon) {
        Thread t = new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    LiveTranslatorLogger.LOGGER.info("{} {}", (Object)prefix, (Object)line);
                }
            }
            catch (IOException e) {
                LiveTranslatorLogger.LOGGER.warn("Error reading process output ({}):", (Object)prefix, (Object)e);
            }
        }, threadName);
        t.setDaemon(daemon);
        t.start();
        return t;
    }

    private static boolean waitForServerHealthy(int timeoutSeconds) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < (long)timeoutSeconds * 1000L) {
            try {
                URL url = new URL("http://127.0.0.1:5005/health");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(1000);
                conn.setReadTimeout(1000);
                if (conn.getResponseCode() == 200) {
                    return true;
                }
            }
            catch (Exception url) {
                // empty catch block
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    static {
        MODEL_DIR = SharedPackageDir.getSharedDir().resolve("ctranslate2/models/m2m100_418M_ct2_int8");
    }
}

