/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.utility;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.creativity0.livetranslator.utility.LiveTranslatorLogger;

public final class ModDataFolder {
    private static Path MOD_FOLDER;

    private ModDataFolder() {
    }

    public static Path get() {
        if (MOD_FOLDER == null) {
            throw new IllegalStateException("ModDataFolder not initialized yet");
        }
        return MOD_FOLDER;
    }

    public static void setup(Path baseDir, String modId) {
        Path folder = baseDir.resolve(modId);
        try {
            Files.createDirectories(folder, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create mod folder: " + String.valueOf(folder), e);
        }
        MOD_FOLDER = folder;
        LiveTranslatorLogger.LOGGER.info("LiveTranslator folder: {}", (Object)MOD_FOLDER);
    }
}

