/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.utility;

import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.creativity0.livetranslator.utility.LiveTranslatorLogger;

public class OutgoingMessageCache {
    private static final Map<UUID, Queue<CachedMessage>> cache = new ConcurrentHashMap<UUID, Queue<CachedMessage>>();

    public static void put(UUID sender, String message, String targetLang) {
        LiveTranslatorLogger.LOGGER.info("cached sender, original message: {} {}", (Object)sender, (Object)message);
        cache.computeIfAbsent(sender, id -> new ConcurrentLinkedQueue()).add(new CachedMessage(message, targetLang));
    }

    public static CachedMessage pop(UUID sender) {
        Queue<CachedMessage> q = cache.get(sender);
        if (q == null) {
            return null;
        }
        CachedMessage msg = q.poll();
        if (q.isEmpty()) {
            cache.remove(sender);
        }
        LiveTranslatorLogger.LOGGER.info("popped sender, original message: {} {}", (Object)sender, (Object)msg);
        return msg;
    }

    public record CachedMessage(String translatedText, String targetLang) {
    }
}

