/*
 * Decompiled with CFR 0.152.
 */
package net.creativity0.livetranslator.utility;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public final class SharedPackageDir {
    private static final String SHARED_DIR_NAME = "minecraft_livetranslator_mod";

    public static Path getSharedDir() {
        return SharedPackageDir.forApp(SHARED_DIR_NAME);
    }

    private static Path forApp(String appName) {
        Objects.requireNonNull(appName, "appName cannot be null");
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            throw new IllegalStateException("Could not determine user.home");
        }
        Path suffix = Paths.get(".local", "share", appName);
        Path fullPath = Paths.get(userHome, new String[0]).resolve(suffix);
        try {
            Files.createDirectories(fullPath, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create directory " + String.valueOf(fullPath), e);
        }
        return fullPath;
    }
}

