# Python server script

This file documents how the script works, and how to run it manually, separately from java code.

## How to run

1. Switch to the directory containing server.py
2. Create venv:
```python -m venv ./venv```
3. Install dependencies
```python -m pip install ctranslate2 sentencepiece transformers fastapi uvicorn langid```
4. Start server (powershell)
```python .\server.py "$env:USERPROFILE\.local\share\minecraft_livetranslator_mod\ctranslate2\models\m2m100_418M_ct2_int8"```

## How to find and kill stuck server processes

- how to find these processes (powershell):
```Get-Process -Id (netstat -ano | findstr :5005 | Select-Object -Last 1).Split()[-1]```

- how to clean-up all processes (powershell):
```netstat -ano | findstr :5005 | ForEach-Object { taskkill /PID (($_ -split '\s+')[-1]) /F }```

## Testing endpoints

- translate
```Invoke-RestMethod -Uri "http://127.0.0.1:5005/translate" -Method POST -ContentType "application/json" -Body '{"text":"Guten Morgen","sourceLanguage":null,"targetLanguage":"en"}```
- translate/batch
```Invoke-RestMethod -Uri "http://127.0.0.1:5005/translate/batch" -Method POST -ContentType "application/json" -Body '{"text":"Hello world","targetLanguages":["hu","de","fr"]}'```

