/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.antarsremake.network;

import java.util.function.Supplier;
import net.mcreator.antarsremake.AntarsRemakeMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AntarsRemakeModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        AntarsRemakeMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.strength = message.data.strength;
                    variables.Level = message.data.Level;
                    variables.Xp = message.data.Xp;
                    variables.maxXp = message.data.maxXp;
                    variables.sp = message.data.sp;
                    variables.health = message.data.health;
                    variables.be = message.data.be;
                    variables.be1 = message.data.be1;
                    variables.be2 = message.data.be2;
                    variables.be3 = message.data.be3;
                    variables.be4 = message.data.be4;
                    variables.wukongtime = message.data.wukongtime;
                    variables.RE = message.data.RE;
                    variables.REGEN = message.data.REGEN;
                    variables.FIRERE = message.data.FIRERE;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double strength = 0.0;
        public double Level = 1.0;
        public double Xp = 0.0;
        public double maxXp = 100.0;
        public double sp = 0.0;
        public double health = 0.0;
        public double be = 0.0;
        public double be1 = 1.0;
        public double be2 = 1.0;
        public double be3 = 1.0;
        public double be4 = 1.0;
        public double wukongtime = 0.0;
        public double RE = 0.0;
        public double REGEN = 0.0;
        public double FIRERE = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                AntarsRemakeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("strength", this.strength);
            nbt.m_128347_("Level", this.Level);
            nbt.m_128347_("Xp", this.Xp);
            nbt.m_128347_("maxXp", this.maxXp);
            nbt.m_128347_("sp", this.sp);
            nbt.m_128347_("health", this.health);
            nbt.m_128347_("be", this.be);
            nbt.m_128347_("be1", this.be1);
            nbt.m_128347_("be2", this.be2);
            nbt.m_128347_("be3", this.be3);
            nbt.m_128347_("be4", this.be4);
            nbt.m_128347_("wukongtime", this.wukongtime);
            nbt.m_128347_("RE", this.RE);
            nbt.m_128347_("REGEN", this.REGEN);
            nbt.m_128347_("FIRERE", this.FIRERE);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.strength = nbt.m_128459_("strength");
            this.Level = nbt.m_128459_("Level");
            this.Xp = nbt.m_128459_("Xp");
            this.maxXp = nbt.m_128459_("maxXp");
            this.sp = nbt.m_128459_("sp");
            this.health = nbt.m_128459_("health");
            this.be = nbt.m_128459_("be");
            this.be1 = nbt.m_128459_("be1");
            this.be2 = nbt.m_128459_("be2");
            this.be3 = nbt.m_128459_("be3");
            this.be4 = nbt.m_128459_("be4");
            this.wukongtime = nbt.m_128459_("wukongtime");
            this.RE = nbt.m_128459_("RE");
            this.REGEN = nbt.m_128459_("REGEN");
            this.FIRERE = nbt.m_128459_("FIRERE");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("antars_remake", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.strength = original.strength;
            clone.Level = original.Level;
            clone.Xp = original.Xp;
            clone.maxXp = original.maxXp;
            clone.sp = original.sp;
            clone.health = original.health;
            clone.be = original.be;
            clone.be1 = original.be1;
            clone.be2 = original.be2;
            clone.be3 = original.be3;
            clone.be4 = original.be4;
            clone.wukongtime = original.wukongtime;
            clone.RE = original.RE;
            clone.REGEN = original.REGEN;
            clone.FIRERE = original.FIRERE;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

