/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.antarsremake.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.mcreator.antarsremake.AntarsRemakeMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AntarsRemakeModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        AntarsRemakeMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        AntarsRemakeMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        AntarsRemakeMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final int target;
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
            this.target = buffer.readInt();
        }

        public PlayerVariablesSyncMessage(PlayerVariables data, int entityid) {
            this.data = data;
            this.target = entityid;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
            buffer.writeInt(message.target);
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.target).getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.strength = message.data.strength;
                    variables.Level = message.data.Level;
                    variables.Xp = message.data.Xp;
                    variables.maxXp = message.data.maxXp;
                    variables.sp = message.data.sp;
                    variables.health = message.data.health;
                    variables.be = message.data.be;
                    variables.be1 = message.data.be1;
                    variables.be2 = message.data.be2;
                    variables.be3 = message.data.be3;
                    variables.be4 = message.data.be4;
                    variables.RE = message.data.RE;
                    variables.REGEN = message.data.REGEN;
                    variables.FIRERE = message.data.FIRERE;
                    variables.mana = message.data.mana;
                    variables.maxmana = message.data.maxmana;
                    variables.skillactive = message.data.skillactive;
                    variables.manawaste = message.data.manawaste;
                    variables.chosedskill = message.data.chosedskill;
                    variables.white = message.data.white;
                    variables.hollow = message.data.hollow;
                    variables.manapower = message.data.manapower;
                    variables.visiblemana = message.data.visiblemana;
                    variables.countwukonganim2 = message.data.countwukonganim2;
                    variables.countwukonganim = message.data.countwukonganim;
                    variables.fireball = message.data.fireball;
                    variables.FireSlash = message.data.FireSlash;
                    variables.firegod = message.data.firegod;
                    variables.firemasterquestactive = message.data.firemasterquestactive;
                    variables.firemasterquestdone = message.data.firemasterquestdone;
                    variables.FireGodAwakeOwned = message.data.FireGodAwakeOwned;
                    variables.Aura = message.data.Aura;
                    variables.strength_mult = message.data.strength_mult;
                    variables.health_mult = message.data.health_mult;
                    variables.doubled = message.data.doubled;
                    variables.used = message.data.used;
                    variables.true_strength = message.data.true_strength;
                    variables.true_health = message.data.true_health;
                    variables.maxlevel = message.data.maxlevel;
                    variables.is_first_time = message.data.is_first_time;
                    variables.Rank = message.data.Rank;
                    variables.player_class = message.data.player_class;
                    variables.tick = message.data.tick;
                    variables.is_on = message.data.is_on;
                    variables.dexterity = message.data.dexterity;
                    variables.resistance = message.data.resistance;
                    variables.tool_in_hands_ats = message.data.tool_in_hands_ats;
                    variables.HealthCorrectN = message.data.HealthCorrectN;
                    variables.is_on_2 = message.data.is_on_2;
                    variables.tick2 = message.data.tick2;
                    variables.flexion_ = message.data.flexion_;
                    variables.true_speed = message.data.true_speed;
                    variables.quest = message.data.quest;
                    variables.flex_num_made = message.data.flex_num_made;
                    variables.level_limit = message.data.level_limit;
                    variables.xp_mult_race = message.data.xp_mult_race;
                    variables.true_race = message.data.true_race;
                    variables.advantage = message.data.advantage;
                    variables.sound_permit = message.data.sound_permit;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double strength = 0.0;
        public double Level = 1.0;
        public double Xp = 0.0;
        public double maxXp = 100.0;
        public double sp = 0.0;
        public double health = 0.0;
        public double be = 0.0;
        public double be1 = 1.0;
        public double be2 = 1.0;
        public double be3 = 1.0;
        public double be4 = 1.0;
        public double RE = 0.0;
        public double REGEN = 0.0;
        public double FIRERE = 0.0;
        public double mana = 100.0;
        public double maxmana = 100.0;
        public double skillactive = 0.0;
        public double manawaste = 0.0;
        public double chosedskill = -1.0;
        public double white = 0.0;
        public double hollow = 0.0;
        public double manapower = 0.0;
        public double visiblemana = 0.0;
        public double countwukonganim2 = 0.0;
        public double countwukonganim = 0.0;
        public double fireball = 0.0;
        public double FireSlash = 0.0;
        public double firegod = 0.0;
        public double firemasterquestactive = 0.0;
        public double firemasterquestdone = 0.0;
        public double FireGodAwakeOwned = 0.0;
        public boolean Aura = false;
        public double strength_mult = 1.0;
        public double health_mult = 1.0;
        public boolean doubled = false;
        public boolean used = false;
        public double true_strength = 0.0;
        public double true_health = 0.0;
        public double maxlevel = 0.0;
        public boolean is_first_time = true;
        public String Rank = "";
        public String player_class = "\"None\"";
        public double tick = 0.0;
        public boolean is_on = false;
        public double dexterity = 0.0;
        public double resistance = 0.0;
        public double tool_in_hands_ats = 0.0;
        public double HealthCorrectN = 0.0;
        public boolean is_on_2 = true;
        public double tick2 = 0.0;
        public boolean flexion_ = false;
        public double true_speed = 0.0;
        public double quest = 0.0;
        public double flex_num_made = 0.0;
        public double level_limit = 100.0;
        public double xp_mult_race = 1.0;
        public boolean true_race = false;
        public double advantage = 0.0;
        public boolean sound_permit = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                AntarsRemakeMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)entity.m_9236_()).m_46472_()), (Object)new PlayerVariablesSyncMessage(this, entity.m_19879_()));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("strength", this.strength);
            nbt.m_128347_("Level", this.Level);
            nbt.m_128347_("Xp", this.Xp);
            nbt.m_128347_("maxXp", this.maxXp);
            nbt.m_128347_("sp", this.sp);
            nbt.m_128347_("health", this.health);
            nbt.m_128347_("be", this.be);
            nbt.m_128347_("be1", this.be1);
            nbt.m_128347_("be2", this.be2);
            nbt.m_128347_("be3", this.be3);
            nbt.m_128347_("be4", this.be4);
            nbt.m_128347_("RE", this.RE);
            nbt.m_128347_("REGEN", this.REGEN);
            nbt.m_128347_("FIRERE", this.FIRERE);
            nbt.m_128347_("mana", this.mana);
            nbt.m_128347_("maxmana", this.maxmana);
            nbt.m_128347_("skillactive", this.skillactive);
            nbt.m_128347_("manawaste", this.manawaste);
            nbt.m_128347_("chosedskill", this.chosedskill);
            nbt.m_128347_("white", this.white);
            nbt.m_128347_("hollow", this.hollow);
            nbt.m_128347_("manapower", this.manapower);
            nbt.m_128347_("visiblemana", this.visiblemana);
            nbt.m_128347_("countwukonganim2", this.countwukonganim2);
            nbt.m_128347_("countwukonganim", this.countwukonganim);
            nbt.m_128347_("fireball", this.fireball);
            nbt.m_128347_("FireSlash", this.FireSlash);
            nbt.m_128347_("firegod", this.firegod);
            nbt.m_128347_("firemasterquestactive", this.firemasterquestactive);
            nbt.m_128347_("firemasterquestdone", this.firemasterquestdone);
            nbt.m_128347_("FireGodAwakeOwned", this.FireGodAwakeOwned);
            nbt.m_128379_("Aura", this.Aura);
            nbt.m_128347_("strength_mult", this.strength_mult);
            nbt.m_128347_("health_mult", this.health_mult);
            nbt.m_128379_("doubled", this.doubled);
            nbt.m_128379_("used", this.used);
            nbt.m_128347_("true_strength", this.true_strength);
            nbt.m_128347_("true_health", this.true_health);
            nbt.m_128347_("maxlevel", this.maxlevel);
            nbt.m_128379_("is_first_time", this.is_first_time);
            nbt.m_128359_("Rank", this.Rank);
            nbt.m_128359_("player_class", this.player_class);
            nbt.m_128347_("tick", this.tick);
            nbt.m_128379_("is_on", this.is_on);
            nbt.m_128347_("dexterity", this.dexterity);
            nbt.m_128347_("resistance", this.resistance);
            nbt.m_128347_("tool_in_hands_ats", this.tool_in_hands_ats);
            nbt.m_128347_("HealthCorrectN", this.HealthCorrectN);
            nbt.m_128379_("is_on_2", this.is_on_2);
            nbt.m_128347_("tick2", this.tick2);
            nbt.m_128379_("flexion_", this.flexion_);
            nbt.m_128347_("true_speed", this.true_speed);
            nbt.m_128347_("quest", this.quest);
            nbt.m_128347_("flex_num_made", this.flex_num_made);
            nbt.m_128347_("level_limit", this.level_limit);
            nbt.m_128347_("xp_mult_race", this.xp_mult_race);
            nbt.m_128379_("true_race", this.true_race);
            nbt.m_128347_("advantage", this.advantage);
            nbt.m_128379_("sound_permit", this.sound_permit);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt;
            if (tag == null) {
                tag = this.writeNBT();
            }
            if ((nbt = (CompoundTag)tag) == null) {
                nbt = (CompoundTag)this.writeNBT();
            }
            this.strength = nbt.m_128459_("strength");
            this.Level = nbt.m_128459_("Level");
            this.Xp = nbt.m_128459_("Xp");
            this.maxXp = nbt.m_128459_("maxXp");
            this.sp = nbt.m_128459_("sp");
            this.health = nbt.m_128459_("health");
            this.be = nbt.m_128459_("be");
            this.be1 = nbt.m_128459_("be1");
            this.be2 = nbt.m_128459_("be2");
            this.be3 = nbt.m_128459_("be3");
            this.be4 = nbt.m_128459_("be4");
            this.RE = nbt.m_128459_("RE");
            this.REGEN = nbt.m_128459_("REGEN");
            this.FIRERE = nbt.m_128459_("FIRERE");
            this.mana = nbt.m_128459_("mana");
            this.maxmana = nbt.m_128459_("maxmana");
            this.skillactive = nbt.m_128459_("skillactive");
            this.manawaste = nbt.m_128459_("manawaste");
            this.chosedskill = nbt.m_128459_("chosedskill");
            this.white = nbt.m_128459_("white");
            this.hollow = nbt.m_128459_("hollow");
            this.manapower = nbt.m_128459_("manapower");
            this.visiblemana = nbt.m_128459_("visiblemana");
            this.countwukonganim2 = nbt.m_128459_("countwukonganim2");
            this.countwukonganim = nbt.m_128459_("countwukonganim");
            this.fireball = nbt.m_128459_("fireball");
            this.FireSlash = nbt.m_128459_("FireSlash");
            this.firegod = nbt.m_128459_("firegod");
            this.firemasterquestactive = nbt.m_128459_("firemasterquestactive");
            this.firemasterquestdone = nbt.m_128459_("firemasterquestdone");
            this.FireGodAwakeOwned = nbt.m_128459_("FireGodAwakeOwned");
            this.Aura = nbt.m_128471_("Aura");
            this.strength_mult = nbt.m_128459_("strength_mult");
            this.health_mult = nbt.m_128459_("health_mult");
            this.doubled = nbt.m_128471_("doubled");
            this.used = nbt.m_128471_("used");
            this.true_strength = nbt.m_128459_("true_strength");
            this.true_health = nbt.m_128459_("true_health");
            this.maxlevel = nbt.m_128459_("maxlevel");
            this.is_first_time = nbt.m_128471_("is_first_time");
            this.Rank = nbt.m_128461_("Rank");
            this.player_class = nbt.m_128461_("player_class");
            this.tick = nbt.m_128459_("tick");
            this.is_on = nbt.m_128471_("is_on");
            this.dexterity = nbt.m_128459_("dexterity");
            this.resistance = nbt.m_128459_("resistance");
            this.tool_in_hands_ats = nbt.m_128459_("tool_in_hands_ats");
            this.HealthCorrectN = nbt.m_128459_("HealthCorrectN");
            this.is_on_2 = nbt.m_128471_("is_on_2");
            this.tick2 = nbt.m_128459_("tick2");
            this.flexion_ = nbt.m_128471_("flexion_");
            this.true_speed = nbt.m_128459_("true_speed");
            this.quest = nbt.m_128459_("quest");
            this.flex_num_made = nbt.m_128459_("flex_num_made");
            this.level_limit = nbt.m_128459_("level_limit");
            this.xp_mult_race = nbt.m_128459_("xp_mult_race");
            this.true_race = nbt.m_128471_("true_race");
            this.advantage = nbt.m_128459_("advantage");
            this.sound_permit = nbt.m_128471_("sound_permit");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("antars_remake", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "antars_remake_mapvars";
        public double wukongtime = 0.0;
        public boolean chosen_one = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            if (nbt == null) {
                nbt = this.m_7176_(new CompoundTag());
            }
            this.wukongtime = nbt.m_128459_("wukongtime");
            this.chosen_one = nbt.m_128471_("chosen_one");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("wukongtime", this.wukongtime);
            nbt.m_128379_("chosen_one", this.chosen_one);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                AntarsRemakeMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "antars_remake_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                AntarsRemakeMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.strength = original.strength;
            clone.Level = original.Level;
            clone.Xp = original.Xp;
            clone.maxXp = original.maxXp;
            clone.sp = original.sp;
            clone.health = original.health;
            clone.be = original.be;
            clone.be1 = original.be1;
            clone.be2 = original.be2;
            clone.be3 = original.be3;
            clone.be4 = original.be4;
            clone.RE = original.RE;
            clone.REGEN = original.REGEN;
            clone.FIRERE = original.FIRERE;
            clone.mana = original.mana;
            clone.maxmana = original.maxmana;
            clone.skillactive = original.skillactive;
            clone.manawaste = original.manawaste;
            clone.chosedskill = original.chosedskill;
            clone.white = original.white;
            clone.hollow = original.hollow;
            clone.manapower = original.manapower;
            clone.visiblemana = original.visiblemana;
            clone.countwukonganim2 = original.countwukonganim2;
            clone.countwukonganim = original.countwukonganim;
            clone.fireball = original.fireball;
            clone.FireSlash = original.FireSlash;
            clone.firegod = original.firegod;
            clone.firemasterquestactive = original.firemasterquestactive;
            clone.firemasterquestdone = original.firemasterquestdone;
            clone.FireGodAwakeOwned = original.FireGodAwakeOwned;
            clone.Aura = original.Aura;
            clone.strength_mult = original.strength_mult;
            clone.health_mult = original.health_mult;
            clone.doubled = original.doubled;
            clone.used = original.used;
            clone.true_strength = original.true_strength;
            clone.true_health = original.true_health;
            clone.maxlevel = original.maxlevel;
            clone.is_first_time = original.is_first_time;
            clone.Rank = original.Rank;
            clone.player_class = original.player_class;
            clone.tick = original.tick;
            clone.is_on = original.is_on;
            clone.dexterity = original.dexterity;
            clone.resistance = original.resistance;
            clone.tool_in_hands_ats = original.tool_in_hands_ats;
            clone.HealthCorrectN = original.HealthCorrectN;
            clone.is_on_2 = original.is_on_2;
            clone.tick2 = original.tick2;
            clone.flexion_ = original.flexion_;
            clone.true_speed = original.true_speed;
            clone.quest = original.quest;
            clone.flex_num_made = original.flex_num_made;
            clone.level_limit = original.level_limit;
            clone.xp_mult_race = original.xp_mult_race;
            clone.true_race = original.true_race;
            clone.advantage = original.advantage;
            clone.sound_permit = original.sound_permit;
            if (!event.isWasDeath()) {
                // empty if block
            }
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    AntarsRemakeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    AntarsRemakeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                AntarsRemakeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

