/*
 * Decompiled with CFR 0.152.
 */
package net.elemental_wizards_rpg.client;

import java.util.List;
import java.util.function.Supplier;
import mod.azure.azurelibarmor.common.render.armor.AzArmorRenderer;
import mod.azure.azurelibarmor.common.render.armor.AzArmorRendererRegistry;
import net.elemental_wizards_rpg.client.armor.ElementalRobeRenderer;
import net.elemental_wizards_rpg.client.effect.BubbleFoamParticleSpawner;
import net.elemental_wizards_rpg.client.effect.BubbleFoamRenderer;
import net.elemental_wizards_rpg.client.effect.CleansingWaterParticleSpawner;
import net.elemental_wizards_rpg.client.effect.StoneFleshParticleSpawner;
import net.elemental_wizards_rpg.client.entity.DripstoneBigRenderer;
import net.elemental_wizards_rpg.client.entity.DripstoneSmallRenderer;
import net.elemental_wizards_rpg.client.entity.DripstoneStraightRenderer;
import net.elemental_wizards_rpg.client.entity.TornadoRenderer;
import net.elemental_wizards_rpg.compat.CompatLoadingCheck;
import net.elemental_wizards_rpg.effect.Effects;
import net.elemental_wizards_rpg.entity.DripstoneBigEntity;
import net.elemental_wizards_rpg.entity.DripstoneSmallEntity;
import net.elemental_wizards_rpg.item.armor.Armors;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.spell_engine.api.effect.CustomModelStatusEffect;
import net.spell_engine.api.effect.CustomParticleStatusEffect;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.render.CustomModels;

public class ElementalClient {
    public static void init() {
        CustomModels.registerModelIds(List.of(DripstoneBigRenderer.modelId, DripstoneSmallRenderer.modelId, DripstoneStraightRenderer.modelId, BubbleFoamRenderer.modelId_base, TornadoRenderer.modelId, ResourceLocation.fromNamespaceAndPath((String)"elemental_wizards_rpg", (String)"projectile/stone_spear"), ResourceLocation.fromNamespaceAndPath((String)"elemental_wizards_rpg", (String)"projectile/spell_stone"), ResourceLocation.fromNamespaceAndPath((String)"elemental_wizards_rpg", (String)"projectile/stone_shard"), ResourceLocation.fromNamespaceAndPath((String)"elemental_wizards_rpg", (String)"projectile/big_bubble")));
        ElementalClient.registerArmorRenderer(Armors.elementalArmor, ElementalRobeRenderer::elemental);
        ElementalClient.registerArmorRenderer(Armors.kelpArmor, ElementalRobeRenderer::kelp);
        ElementalClient.registerArmorRenderer(Armors.dripstoneArmor, ElementalRobeRenderer::dripstone);
        ElementalClient.registerArmorRenderer(Armors.windArmor, ElementalRobeRenderer::wind);
        ElementalClient.registerArmorRenderer(Armors.netheriteKelpNetheriteArmor, ElementalRobeRenderer::netherite_kelp);
        ElementalClient.registerArmorRenderer(Armors.netheriteDripstoneArmor, ElementalRobeRenderer::netherite_dripstone);
        ElementalClient.registerArmorRenderer(Armors.netheriteWindArmor, ElementalRobeRenderer::netherite_wind);
        if (CompatLoadingCheck.armoryLoadCheck()) {
            ElementalClient.registerArmorRenderer(Armors.hurricaneArmorSet.armorSet(), ElementalRobeRenderer::hurricane);
            ElementalClient.registerArmorRenderer(Armors.mountainArmorSet.armorSet(), ElementalRobeRenderer::mountain);
            ElementalClient.registerArmorRenderer(Armors.oceanArmorSet.armorSet(), ElementalRobeRenderer::ocean);
        }
        CustomModelStatusEffect.register((MobEffect)Effects.BUBBLE_FOAM.effect, (CustomModelStatusEffect.Renderer)new BubbleFoamRenderer());
        CustomParticleStatusEffect.register((MobEffect)Effects.CLEANSING_WATER.effect, (CustomParticleStatusEffect.Spawner)new CleansingWaterParticleSpawner());
        CustomParticleStatusEffect.register((MobEffect)Effects.BUBBLE_FOAM.effect, (CustomParticleStatusEffect.Spawner)new BubbleFoamParticleSpawner());
        CustomParticleStatusEffect.register((MobEffect)Effects.STONE_FLESH.effect, (CustomParticleStatusEffect.Spawner)new StoneFleshParticleSpawner());
        EntityRendererRegistry.register(DripstoneBigEntity.ENTITY_TYPE, DripstoneBigRenderer::new);
        EntityRendererRegistry.register(DripstoneSmallEntity.ENTITY_TYPE, DripstoneSmallRenderer::new);
    }

    private static void registerArmorRenderer(Armor.Set set, Supplier<AzArmorRenderer> armorRendererSupplier) {
        AzArmorRendererRegistry.register(armorRendererSupplier, (Item)set.head, (Item[])new Item[]{set.chest, set.legs, set.feet});
    }
}

