/*
 * Decompiled with CFR 0.152.
 */
package net.elemental_wizards_rpg;

import net.elemental_wizards_rpg.compat.WizardsCompat;
import net.elemental_wizards_rpg.config.EffectsConfig;
import net.elemental_wizards_rpg.config.TweaksConfig;
import net.elemental_wizards_rpg.effect.Effects;
import net.elemental_wizards_rpg.entity.DripstoneBigEntity;
import net.elemental_wizards_rpg.entity.DripstoneSmallEntity;
import net.elemental_wizards_rpg.entity.TornadoEntity;
import net.elemental_wizards_rpg.item.ElementalGroup;
import net.elemental_wizards_rpg.item.ElementalItems;
import net.elemental_wizards_rpg.item.armor.Armors;
import net.elemental_wizards_rpg.item.config.Default;
import net.elemental_wizards_rpg.item.weapons.WeaponsRegister;
import net.elemental_wizards_rpg.spell.CustomSpellImpacts;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.config.ConfigFile;
import net.tiny_config.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementalMod {
    public static final String MOD_ID = "elemental_wizards_rpg";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"elemental_wizards_rpg");
    public static ConfigManager<ConfigFile.Equipment> itemConfig = new ConfigManager("equipment", (Object)Default.itemConfig).builder().setDirectory("elemental_wizards_rpg").sanitize(true).build();
    public static ConfigManager<EffectsConfig> effectsConfig = new ConfigManager("effects_v1", (Object)new EffectsConfig()).builder().setDirectory("elemental_wizards_rpg").sanitize(true).build();
    public static ConfigManager<TweaksConfig> tweaksConfig = new ConfigManager("tweaks", (Object)new TweaksConfig()).builder().setDirectory("elemental_wizards_rpg").sanitize(true).build();

    public static void init() {
        itemConfig.refresh();
        effectsConfig.refresh();
        tweaksConfig.refresh();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            ((TweaksConfig)ElementalMod.tweaksConfig.value).ignore_items_required_mods = true;
        }
        CustomSpellImpacts.registerCustomImpacts();
        WizardsCompat.registerCompat();
    }

    public static void registerItems() {
        ElementalGroup.ELEMENTAL_WIZARD = FabricItemGroup.builder().icon(() -> new ItemStack((ItemLike)Armors.kelpArmor.head)).title((Component)Component.translatable((String)"itemGroup.elemental_wizards_rpg.general")).build();
        Registry.register((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, ElementalGroup.ELEMENTAL_WIZARD_KEY, (Object)ElementalGroup.ELEMENTAL_WIZARD);
        ElementalItems.registerModItems();
        ElementalGroup.registerItemGroups();
        WeaponsRegister.register(((ConfigFile.Equipment)ElementalMod.itemConfig.value).weapons);
        Armors.register(((ConfigFile.Equipment)ElementalMod.itemConfig.value).armor_sets);
        itemConfig.save();
    }

    public static void registerEffects() {
        Effects.register();
    }

    public static void registerEntities() {
        DripstoneBigEntity.ENTITY_TYPE = (EntityType)Registry.register((Registry)BuiltInRegistries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"dripstone_big"), (Object)FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, DripstoneBigEntity::new).dimensions(EntityDimensions.scalable((float)6.0f, (float)0.5f)).fireImmune().trackRangeBlocks(128).trackedUpdateRate(20).build());
        DripstoneSmallEntity.ENTITY_TYPE = (EntityType)Registry.register((Registry)BuiltInRegistries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"dripstone_small"), (Object)FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, DripstoneSmallEntity::new).dimensions(EntityDimensions.scalable((float)6.0f, (float)0.5f)).fireImmune().trackRangeBlocks(128).trackedUpdateRate(20).build());
        TornadoEntity.ENTITY_TYPE = (EntityType)Registry.register((Registry)BuiltInRegistries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"tornado"), (Object)FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, TornadoEntity::new).dimensions(EntityDimensions.scalable((float)6.0f, (float)0.5f)).fireImmune().trackRangeBlocks(128).trackedUpdateRate(20).build());
    }
}

