/*
 * Decompiled with CFR 0.152.
 */
package net.elemental_wizards_rpg.effect;

import net.elemental_wizards_rpg.effect.Effects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.more_rpg_classes.client.particle.MoreParticles;

public class CleansingWaterEffect
extends MobEffect {
    public CleansingWaterEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public boolean applyEffectTick(LivingEntity pLivingEntity, int pAmplifier) {
        ServerLevel serverWorld;
        Level world = pLivingEntity.getCommandSenderWorld();
        if (pLivingEntity.getHealth() < pLivingEntity.getMaxHealth()) {
            pLivingEntity.heal(1.0f);
        }
        if (pLivingEntity.isOnFire()) {
            pLivingEntity.playSound(SoundEvents.FIRE_EXTINGUISH, 2.0f, 1.0f);
            if (world.isClientSide) {
                world.addParticle((ParticleOptions)MoreParticles.WATER_MIST, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0);
                world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0);
            } else if (world instanceof ServerLevel) {
                serverWorld = (ServerLevel)world;
                serverWorld.sendParticles((ParticleOptions)MoreParticles.WATER_MIST, 1.0, 1.0, 1.0, 4, 2.0, 2.0, 2.0, 2.0);
                serverWorld.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, 1.0, 1.0, 1.0, 4, 2.0, 2.0, 2.0, 2.0);
            }
            pLivingEntity.clearFire();
        }
        if (pLivingEntity.isInLava()) {
            if (world.isClientSide) {
                world.addParticle((ParticleOptions)MoreParticles.WATER_MIST, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0);
                world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0);
            } else if (world instanceof ServerLevel) {
                serverWorld = (ServerLevel)world;
                serverWorld.sendParticles((ParticleOptions)MoreParticles.WATER_MIST, 1.0, 1.0, 1.0, 4, 2.0, 2.0, 2.0, 2.0);
                serverWorld.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, 1.0, 1.0, 1.0, 4, 2.0, 2.0, 2.0, 2.0);
            }
            pLivingEntity.playSound(SoundEvents.FIRE_EXTINGUISH, 2.0f, 1.0f);
            pLivingEntity.removeEffect(Effects.CLEANSING_WATER.registryEntry);
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int i = 40 >> amplifier;
        if (i > 0) {
            return duration % i == 0;
        }
        return true;
    }
}

