/*
 * Decompiled with CFR 0.152.
 */
package net.elemental_wizards_rpg.effect;

import net.elemental_wizards_rpg.effect.Effects;
import net.elemental_wizards_rpg.entity.TornadoEntity;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.spell_power.api.statuseffects.SpellVulnerabilityStatusEffect;

public class TornadoEffect
extends SpellVulnerabilityStatusEffect {
    protected TornadoEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        entity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 1, 0, false, false, false));
        float range = 4.5f;
        AABB radius = new AABB(entity.getX() + (double)range, entity.getY() + (double)(range / 3.0f), entity.getZ() + (double)range, entity.getX() - (double)range, entity.getY() - (double)(range / 3.0f), entity.getZ() - (double)range);
        TornadoEntity nearestTornado = null;
        double minDistance = Double.MAX_VALUE;
        for (Entity otherEntity : entity.getCommandSenderWorld().getEntities((Entity)entity, radius, e -> e instanceof TornadoEntity)) {
            double dist = otherEntity.distanceToSqr((Entity)entity);
            if (!(dist < minDistance)) continue;
            minDistance = dist;
            nearestTornado = (TornadoEntity)otherEntity;
        }
        if (nearestTornado != null) {
            Vec3 tornadoPos = nearestTornado.position();
            Vec3 entityPos = entity.position();
            double dx = entityPos.x - tornadoPos.x;
            double dz = entityPos.z - tornadoPos.z;
            double radiusDistance = Math.sqrt(dx * dx + dz * dz);
            if (radiusDistance == 0.0) {
                radiusDistance = 0.01;
            }
            radiusDistance = Math.max(1.0, radiusDistance - 0.1);
            double angle = Math.atan2(dz, dx);
            double newX = tornadoPos.x + Math.cos(angle += 0.25) * radiusDistance;
            double newZ = tornadoPos.z + Math.sin(angle) * radiusDistance;
            double velocityX = newX - entityPos.x;
            double velocityZ = newZ - entityPos.z;
            double velocityY = 0.1 + ((double)range - radiusDistance) * 0.03;
            entity.setDeltaMovement(velocityX * 1.2, velocityY, velocityZ * 1.2);
        } else {
            entity.removeEffect(Effects.TORNADO.registryEntry);
        }
        return true;
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        super.onEffectStarted(entity, amplifier);
        Vec3 currentMovement = entity.getDeltaMovement();
        entity.setDeltaMovement(currentMovement.x, currentMovement.y + (double)0.65f, currentMovement.z);
        entity.hurtMarked = true;
        entity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 1, 0, false, false, false));
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

