/*
 * Decompiled with CFR 0.152.
 */
package net.elemental_wizards_rpg.effect;

import net.elemental_wizards_rpg.effect.Effects;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.spell_power.api.statuseffects.SpellVulnerabilityStatusEffect;

public class UpdraftEffect
extends SpellVulnerabilityStatusEffect {
    public boolean ground_on_apply = false;

    protected UpdraftEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (!entity.onGround()) {
            Vec3 currentMovement = entity.getDeltaMovement();
            entity.setDeltaMovement(currentMovement.x, currentMovement.y + (double)0.075f, currentMovement.z);
            entity.hurtMarked = true;
        }
        return true;
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        super.onEffectStarted(entity, amplifier);
        if (!entity.onGround()) {
            this.ground_on_apply = true;
            entity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 15, 0, false, false, false));
        } else if (entity.hasEffect(Effects.UPDRAFT.registryEntry)) {
            entity.removeEffect(Effects.UPDRAFT.registryEntry);
        }
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return this.ground_on_apply;
    }
}

