/*
 * Decompiled with CFR 0.152.
 */
package net.elemental_wizards_rpg.item.armor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.elemental_wizards_rpg.item.ElementalGroup;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.more_rpg_classes.custom.MoreSpellSchools;
import net.spell_engine.api.config.ArmorSetConfig;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_power.api.SpellPowerMechanics;

public class ArmoryCompat {
    public static final ArrayList<Armor.Entry> entries = new ArrayList();
    public static ResourceLocation hurricane_passive = ResourceLocation.fromNamespaceAndPath((String)"elemental_wizards_rpg", (String)"hurricane");
    public static ResourceLocation mountain_passive = ResourceLocation.fromNamespaceAndPath((String)"elemental_wizards_rpg", (String)"mountain");
    public static ResourceLocation ocean_passive = ResourceLocation.fromNamespaceAndPath((String)"elemental_wizards_rpg", (String)"ocean");
    public static Holder<ArmorMaterial> wizard_robe = ArmoryCompat.material("wizard_robe", 1, 3, 2, 1, 18, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    private static final float caster_spell_power = 0.35f;
    private static final float crit_damage_t3 = 0.1f;
    private static final float crit_chance_t3 = 0.02f;
    private static final float haste_t3 = 0.03f;
    public static final int durability = 40;
    public static final Armor.Entry hurricane = ArmoryCompat.create(wizard_robe, ResourceLocation.fromNamespaceAndPath((String)"elemental_wizards_rpg", (String)"hurricane_robe"), 40, 5, Armor.CustomItem::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(AttributeModifier.multiply((ResourceLocation)MoreSpellSchools.AIR.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_DAMAGE.id, (float)0.1f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(AttributeModifier.multiply((ResourceLocation)MoreSpellSchools.AIR.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_DAMAGE.id, (float)0.1f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(AttributeModifier.multiply((ResourceLocation)MoreSpellSchools.AIR.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_DAMAGE.id, (float)0.1f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(AttributeModifier.multiply((ResourceLocation)MoreSpellSchools.AIR.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_DAMAGE.id, (float)0.1f))), ArmoryCompat.commonSettings(hurricane_passive)).translatedName("", "", "", "");
    public static final Armor.Entry mountain = ArmoryCompat.create(wizard_robe, ResourceLocation.fromNamespaceAndPath((String)"elemental_wizards_rpg", (String)"mountain_robe"), 40, 5, Armor.CustomItem::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(AttributeModifier.multiply((ResourceLocation)MoreSpellSchools.EARTH.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_CHANCE.id, (float)0.02f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(AttributeModifier.multiply((ResourceLocation)MoreSpellSchools.EARTH.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_CHANCE.id, (float)0.02f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(AttributeModifier.multiply((ResourceLocation)MoreSpellSchools.EARTH.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_CHANCE.id, (float)0.02f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(AttributeModifier.multiply((ResourceLocation)MoreSpellSchools.EARTH.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.CRITICAL_CHANCE.id, (float)0.02f))), ArmoryCompat.commonSettings(mountain_passive)).translatedName("", "", "", "");
    public static final Armor.Entry ocean = ArmoryCompat.create(wizard_robe, ResourceLocation.fromNamespaceAndPath((String)"elemental_wizards_rpg", (String)"ocean_robe"), 40, 5, Armor.CustomItem::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(AttributeModifier.multiply((ResourceLocation)MoreSpellSchools.WATER.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.03f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(AttributeModifier.multiply((ResourceLocation)MoreSpellSchools.WATER.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.03f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(AttributeModifier.multiply((ResourceLocation)MoreSpellSchools.WATER.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.03f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(AttributeModifier.multiply((ResourceLocation)MoreSpellSchools.WATER.id, (float)0.35f)).add(AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.03f))), ArmoryCompat.commonSettings(ocean_passive)).translatedName("", "", "", "");

    private static Armor.Entry create(Holder<ArmorMaterial> material, ResourceLocation id, int durability, int tier, Armor.Set.ItemFactory factory, ArmorSetConfig defaults, Armor.ItemSettingsTweaker settings) {
        Armor.Entry entry = Armor.Entry.create(material, (ResourceLocation)id, (int)durability, (Armor.Set.ItemFactory)factory, (ArmorSetConfig)defaults, (Equipment.LootProperties)Equipment.LootProperties.of((int)tier), (Armor.ItemSettingsTweaker)settings);
        entries.add(entry);
        return entry;
    }

    public static Holder<ArmorMaterial> material(String name, int protectionHead, int protectionChest, int protectionLegs, int protectionFeet, int enchantability, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredient) {
        ArmorMaterial material = new ArmorMaterial(Map.of(ArmorItem.Type.HELMET, protectionHead, ArmorItem.Type.CHESTPLATE, protectionChest, ArmorItem.Type.LEGGINGS, protectionLegs, ArmorItem.Type.BOOTS, protectionFeet), enchantability, equipSound, repairIngredient, List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"elemental_wizards_rpg", (String)name))), 0.0f, 0.0f);
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"elemental_wizards_rpg", (String)name), (Object)material);
    }

    private static Armor.ItemSettingsTweaker commonSettings(ResourceLocation equipmentSetId) {
        return Armor.ItemSettingsTweaker.standard(itemSettings -> itemSettings.component(SpellDataComponents.EQUIPMENT_SET, (Object)equipmentSetId).component(DataComponents.RARITY, (Object)Rarity.RARE));
    }

    public static void register(Map<String, ArmorSetConfig> configs) {
        Armor.register(configs, entries, ElementalGroup.ELEMENTAL_WIZARD_KEY);
    }
}

