/*
 * Decompiled with CFR 0.152.
 */
package net.elemental_wizards_rpg;

import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.elemental_wizards_rpg.item.armor.Armors;
import net.elemental_wizards_rpg.item.weapons.WeaponsRegister;
import net.elemental_wizards_rpg.spell.ElementalWizardSpells;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;
import net.spell_engine.rpg_series.tags.RPGSeriesItemTags;

public class ElementalWizardsRPGClassDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(UnsmeltGenerator::new);
        pack.addProvider(SpellGen::new);
    }

    public static class UnsmeltGenerator
    extends FabricRecipeProvider {
        public static int UNSMELT_TIME = 300;

        public UnsmeltGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        public void buildRecipes(RecipeOutput exporter) {
            UnsmeltGenerator.disassembleArmor(exporter, Armors.elementalArmor, Items.LAPIS_LAZULI);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.kelpArmor, Items.PRISMARINE_CRYSTALS);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.netheriteKelpNetheriteArmor, Items.NETHERITE_SCRAP);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.dripstoneArmor, Items.POINTED_DRIPSTONE);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.netheriteDripstoneArmor, Items.NETHERITE_SCRAP);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.windArmor, Items.WIND_CHARGE);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.netheriteWindArmor, Items.NETHERITE_SCRAP);
            UnsmeltGenerator.disassemble(exporter, List.of(WeaponsRegister.aquaWand.item(), WeaponsRegister.windWand.item()), Items.GOLD_NUGGET);
            UnsmeltGenerator.disassemble(exporter, List.of(WeaponsRegister.terraWand.item()), Items.IRON_NUGGET);
            UnsmeltGenerator.disassemble(exporter, List.of(WeaponsRegister.aquaStaff.item()), Items.PRISMARINE_CRYSTALS);
            UnsmeltGenerator.disassemble(exporter, List.of(WeaponsRegister.windStaff.item()), Items.WIND_CHARGE);
            UnsmeltGenerator.disassemble(exporter, List.of(WeaponsRegister.terraStaff.item()), Items.DIAMOND);
            UnsmeltGenerator.disassemble(exporter, WeaponsRegister.entries.stream().filter(entry -> entry.id().getPath().contains("netherite")).map(entry -> entry.item()).toList(), Items.NETHERITE_SCRAP);
        }

        private static void disassembleArmor(RecipeOutput exporter, Armor.Set armorSet, Item output) {
            FabricRecipeProvider.oreSmelting((RecipeOutput)exporter, (List)armorSet.pieces(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.oreBlasting((RecipeOutput)exporter, (List)armorSet.pieces(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }

        private static void disassemble(RecipeOutput exporter, List<ItemLike> items, Item output) {
            FabricRecipeProvider.oreSmelting((RecipeOutput)exporter, items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.oreBlasting((RecipeOutput)exporter, items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        public ItemTagGenerator(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void armorTags(List<Armor.Entry> armors) {
            this.armorTags(armors, EnumSet.noneOf(RPGSeriesItemTags.ArmorMetaType.class));
        }

        public void armorTags(List<Armor.Entry> armors, RPGSeriesItemTags.ArmorMetaType metaType) {
            this.armorTags(armors, EnumSet.of(metaType));
        }

        public void armorTags(List<Armor.Entry> armors, EnumSet<RPGSeriesItemTags.ArmorMetaType> metaTypes) {
            for (Armor.Entry armor : armors) {
                String lootTheme;
                Armor.Set set = armor.armorSet();
                FabricTagProvider.FabricTagBuilder headTag = this.getOrCreateTagBuilder(ItemTags.HEAD_ARMOR);
                headTag.addOptional(set.idOf(set.head));
                FabricTagProvider.FabricTagBuilder chestTag = this.getOrCreateTagBuilder(ItemTags.CHEST_ARMOR);
                chestTag.addOptional(set.idOf(set.chest));
                FabricTagProvider.FabricTagBuilder legsTag = this.getOrCreateTagBuilder(ItemTags.LEG_ARMOR);
                legsTag.addOptional(set.idOf(set.legs));
                FabricTagProvider.FabricTagBuilder feetTag = this.getOrCreateTagBuilder(ItemTags.FOOT_ARMOR);
                feetTag.addOptional(set.idOf(set.feet));
                int tier = armor.lootProperties().tier();
                if (tier >= 0) {
                    FabricTagProvider.FabricTagBuilder tierTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootTiers.get((int)tier, (RPGSeriesItemTags.LootCategory)RPGSeriesItemTags.LootCategory.ARMORS));
                    for (Object id : armor.armorSet().pieceIds()) {
                        tierTag.addOptional((ResourceLocation)id);
                    }
                }
                if ((lootTheme = armor.lootProperties().theme()) != null && !lootTheme.isEmpty()) {
                    FabricTagProvider.FabricTagBuilder themeTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootThemes.get((String)lootTheme));
                    for (Object id : armor.armorSet().pieceIds()) {
                        themeTag.addOptional((ResourceLocation)id);
                    }
                }
                for (RPGSeriesItemTags.ArmorMetaType metaType : metaTypes) {
                    FabricTagProvider.FabricTagBuilder metaTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.ArmorType.get((RPGSeriesItemTags.ArmorMetaType)metaType));
                    for (Object id : armor.armorSet().pieceIds()) {
                        metaTag.addOptional((ResourceLocation)id);
                    }
                }
            }
        }

        protected void addTags(HolderLookup.Provider wrapperLookup) {
            this.generateWeaponTags(WeaponsRegister.entries);
            this.armorTags(Armors.entries, RPGSeriesItemTags.ArmorMetaType.MAGIC);
        }
    }

    public static class SpellGen
    extends SpellGenerator {
        public SpellGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (ElementalWizardSpells.Entry entry : ElementalWizardSpells.entries) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }
}

