/*
 * Decompiled with CFR 0.152.
 */
package net.elemental_wizards_rpg.effect;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;

public class BubbleFoamEffect
extends MobEffect {
    protected BubbleFoamEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        float range = 1.5f;
        AABB radius = new AABB(entity.getX() + (double)range, entity.getY() + (double)(range / 3.0f), entity.getZ() + (double)range, entity.getX() - (double)range, entity.getY() - (double)(range / 3.0f), entity.getZ() - (double)range);
        for (Entity entities : entity.getCommandSenderWorld().getEntities((Entity)entity, radius, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
            if (entities == null || !(entities instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)entities;
            target.setDeltaMovement((target.getX() - entity.getX()) / 4.0, (target.getY() - entity.getY()) / 4.0, (target.getZ() - entity.getZ()) / 4.0);
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

