/*
 * Decompiled with CFR 0.152.
 */
package net.elemental_wizards_rpg.effect;

import java.util.ArrayList;
import net.elemental_wizards_rpg.ElementalMod;
import net.elemental_wizards_rpg.config.EffectsConfig;
import net.elemental_wizards_rpg.effect.BubbleFoamEffect;
import net.elemental_wizards_rpg.effect.CleansingWaterEffect;
import net.elemental_wizards_rpg.effect.StoneFleshEffect;
import net.elemental_wizards_rpg.effect.TornadoEffect;
import net.elemental_wizards_rpg.effect.UpdraftEffect;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.more_rpg_classes.custom.MoreSpellSchools;
import net.spell_engine.api.effect.Synchronized;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchools;

public class Effects {
    private static final ArrayList<Entry> entries = new ArrayList();
    public static final Entry CLEANSING_WATER = new Entry("cleansing_water", new CleansingWaterEffect(MobEffectCategory.BENEFICIAL, 121295));
    public static final Entry BUBBLE_FOAM = new Entry("bubble_foam", new BubbleFoamEffect(MobEffectCategory.BENEFICIAL, 121295));
    public static final Entry STONE_FLESH = new Entry("stone_flesh", new StoneFleshEffect(MobEffectCategory.BENEFICIAL, 12421888));
    public static final Entry UPDRAFT = new Entry("updraft", (MobEffect)new UpdraftEffect(MobEffectCategory.HARMFUL, 14019583).setVulnerability(MoreSpellSchools.AIR, new SpellPower.Vulnerability(((EffectsConfig)ElementalMod.effectsConfig.value).updraft_air_damage_vulnerability, ((EffectsConfig)ElementalMod.effectsConfig.value).updraft_air_spell_crit_chance_vulnerability, ((EffectsConfig)ElementalMod.effectsConfig.value).updraft_air_spell_crit_damage_vulnerability)));
    public static final Entry TORNADO = new Entry("tornado", (MobEffect)new TornadoEffect(MobEffectCategory.HARMFUL, 14019583).setVulnerability(SpellSchools.FIRE, new SpellPower.Vulnerability(((EffectsConfig)ElementalMod.effectsConfig.value).tornado_fire_spell_vulnerability, 0.0f, 0.0f)));

    public static void register() {
        Effects.STONE_FLESH.effect.addAttributeModifier(Attributes.ARMOR, STONE_FLESH.modifierId(), (double)((EffectsConfig)ElementalMod.effectsConfig.value).stone_flesh_armor_increase, AttributeModifier.Operation.ADD_VALUE).addAttributeModifier(Attributes.ARMOR_TOUGHNESS, STONE_FLESH.modifierId(), (double)((EffectsConfig)ElementalMod.effectsConfig.value).stone_flesh_armor_toughness_increase, AttributeModifier.Operation.ADD_VALUE);
        Effects.TORNADO.effect.addAttributeModifier(Attributes.MOVEMENT_SPEED, TORNADO.modifierId(), (double)-0.99f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        Effects.UPDRAFT.effect.addAttributeModifier(Attributes.ATTACK_SPEED, UPDRAFT.modifierId(), (double)((EffectsConfig)ElementalMod.effectsConfig.value).updraft_attack_speed_reduction, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        Synchronized.configure((MobEffect)Effects.CLEANSING_WATER.effect, (boolean)true);
        Synchronized.configure((MobEffect)Effects.BUBBLE_FOAM.effect, (boolean)true);
        Synchronized.configure((MobEffect)Effects.STONE_FLESH.effect, (boolean)true);
        Synchronized.configure((MobEffect)Effects.UPDRAFT.effect, (boolean)true);
        Synchronized.configure((MobEffect)Effects.TORNADO.effect, (boolean)true);
        for (Entry entry : entries) {
            entry.register();
        }
    }

    public static class Entry {
        public final ResourceLocation id;
        public final MobEffect effect;
        public Holder<MobEffect> registryEntry;

        public Entry(String name, MobEffect effect) {
            this.id = ResourceLocation.fromNamespaceAndPath((String)"elemental_wizards_rpg", (String)name);
            this.effect = effect;
            entries.add(this);
        }

        public void register() {
            this.registryEntry = Registry.registerForHolder((Registry)BuiltInRegistries.MOB_EFFECT, (ResourceLocation)this.id, (Object)this.effect);
        }

        public ResourceLocation modifierId() {
            return ResourceLocation.fromNamespaceAndPath((String)"elemental_wizards_rpg", (String)("effect." + this.id.getPath()));
        }
    }
}

