/*
 * Decompiled with CFR 0.152.
 */
package net.elemental_wizards_rpg.item.weapons;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import net.elemental_wizards_rpg.ElementalMod;
import net.elemental_wizards_rpg.config.TweaksConfig;
import net.elemental_wizards_rpg.item.ElementalGroup;
import net.elemental_wizards_rpg.spell.ElementalWizardSpells;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.more_rpg_classes.custom.MoreSpellSchools;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.WeaponConfig;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.weapon.StaffItem;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_power.api.SpellSchools;

public class WeaponsRegister {
    public static final ArrayList<Weapon.Entry> entries = new ArrayList();
    private static final float wandAttackDamage = 2.0f;
    private static final float wandAttackSpeed = -2.4f;
    public static final Weapon.Entry kelpWand = WeaponsRegister.wand("wand_kelp", Weapon.CustomMaterial.matching((Tiers)Tiers.WOOD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.WATER.id, (float)3.0f)).loot(Equipment.LootProperties.of((int)0));
    public static final Weapon.Entry aquaWand = WeaponsRegister.wand("wand_aqua", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.WATER.id, (float)4.0f)).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry netheriteAquaWand = WeaponsRegister.wand("wand_netherite_aqua", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.WATER.id, (float)4.5f)).loot(Equipment.LootProperties.of((int)3));
    public static final Weapon.Entry clayWand = WeaponsRegister.wand("wand_clay", Weapon.CustomMaterial.matching((Tiers)Tiers.WOOD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.EARTH.id, (float)3.0f)).loot(Equipment.LootProperties.of((int)0));
    public static final Weapon.Entry terraWand = WeaponsRegister.wand("wand_terra", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.EARTH.id, (float)4.0f)).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry netheriteTerraWand = WeaponsRegister.wand("wand_netherite_terra", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.EARTH.id, (float)4.5f)).loot(Equipment.LootProperties.of((int)3));
    public static final Weapon.Entry featherWand = WeaponsRegister.wand("wand_feather", Weapon.CustomMaterial.matching((Tiers)Tiers.WOOD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.AIR.id, (float)3.0f)).loot(Equipment.LootProperties.of((int)0));
    public static final Weapon.Entry windWand = WeaponsRegister.wand("wand_wind", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.AIR.id, (float)4.0f)).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry netheriteWindWand = WeaponsRegister.wand("wand_netherite_wind", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.AIR.id, (float)4.5f)).loot(Equipment.LootProperties.of((int)3));
    private static final float staffAttackDamage = 4.0f;
    private static final float staffAttackSpeed = -3.0f;
    public static final Weapon.Entry elementalStaff = WeaponsRegister.staff("staff_elemental", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.AIR.id, (float)4.0f)).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.EARTH.id, (float)4.0f)).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.WATER.id, (float)4.0f)).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.FIRE.id, (float)4.0f)).loot(Equipment.LootProperties.of((int)1));
    public static final Weapon.Entry aquaStaff = WeaponsRegister.staff("staff_aqua", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.WATER.id, (float)5.0f)).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry netheriteAquaStaff = WeaponsRegister.staff("staff_netherite_aqua", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.WATER.id, (float)6.0f)).loot(Equipment.LootProperties.of((int)3));
    public static final Weapon.Entry terraStaff = WeaponsRegister.staff("staff_terra", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.EARTH.id, (float)5.0f)).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry netheriteTerraStaff = WeaponsRegister.staff("staff_netherite_terra", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.EARTH.id, (float)6.0f)).loot(Equipment.LootProperties.of((int)3));
    public static final Weapon.Entry windStaff = WeaponsRegister.staff("staff_wind", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.AIR.id, (float)5.0f)).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry netheriteWindStaff = WeaponsRegister.staff("staff_netherite_wind", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.AIR.id, (float)6.0f)).loot(Equipment.LootProperties.of((int)3));
    private static final String BETTER_END = "betterend";
    private static final String BETTER_NETHER = "betternether";
    private static final String AETHER = "aether";
    private static final String ARSENAL = "arsenal";

    private static Weapon.Entry entry(String name, Weapon.CustomMaterial material, Weapon.Factory factory, WeaponConfig defaults, Equipment.WeaponType category) {
        Weapon.Entry entry = new Weapon.Entry("elemental_wizards_rpg", name, material, factory, defaults, category);
        if (entry.isRequiredModInstalled()) {
            entries.add(entry);
            entry.loot(Equipment.LootProperties.of((String)""));
        }
        return entry;
    }

    private static Supplier<Ingredient> ingredient(String idString, boolean requirement, Item fallback) {
        ResourceLocation id = ResourceLocation.parse((String)idString);
        if (requirement) {
            return () -> Ingredient.of((ItemLike[])new ItemLike[]{fallback});
        }
        return () -> {
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            Item ingredient = item != null ? item : fallback;
            return Ingredient.of((ItemLike[])new ItemLike[]{ingredient});
        };
    }

    private static Weapon.Entry wand(String name, Weapon.CustomMaterial material) {
        return WeaponsRegister.entry(name, material, StaffItem::new, new WeaponConfig(2.0f, -2.4f), Equipment.WeaponType.DAMAGE_WAND);
    }

    private static Weapon.Entry staff(String name, Weapon.CustomMaterial material) {
        return WeaponsRegister.entry(name, material, StaffItem::new, new WeaponConfig(4.0f, -3.0f), Equipment.WeaponType.DAMAGE_STAFF);
    }

    public static void register(Map<String, WeaponConfig> configs) {
        Supplier<Ingredient> repair;
        if (FabricLoader.getInstance().isModLoaded(BETTER_NETHER) || ((TweaksConfig)ElementalMod.tweaksConfig.value).ignore_items_required_mods) {
            repair = WeaponsRegister.ingredient("betternether:nether_ruby", FabricLoader.getInstance().isModLoaded(BETTER_NETHER), Items.NETHERITE_INGOT);
            WeaponsRegister.staff("staff_ruby_terra", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair)).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.EARTH.id, (float)7.0f)).loot(Equipment.LootProperties.of((int)4));
        }
        if (FabricLoader.getInstance().isModLoaded(BETTER_END) || ((TweaksConfig)ElementalMod.tweaksConfig.value).ignore_items_required_mods) {
            repair = WeaponsRegister.ingredient("betterend:aeternium_ingot", FabricLoader.getInstance().isModLoaded(BETTER_END), Items.NETHERITE_INGOT);
            WeaponsRegister.staff("staff_crystal_aqua", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair)).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.WATER.id, (float)7.0f)).loot(Equipment.LootProperties.of((int)4));
            WeaponsRegister.staff("staff_aeternium_wind", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair)).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.AIR.id, (float)7.0f)).loot(Equipment.LootProperties.of((int)4));
        }
        if (FabricLoader.getInstance().isModLoaded(AETHER) || ((TweaksConfig)ElementalMod.tweaksConfig.value).ignore_items_required_mods) {
            repair = WeaponsRegister.ingredient("aether:ambrosium_shard", FabricLoader.getInstance().isModLoaded(AETHER), Items.NETHERITE_INGOT);
            WeaponsRegister.staff("staff_aether", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair)).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.EARTH.id, (float)7.0f)).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.WATER.id, (float)7.0f)).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.AIR.id, (float)7.0f)).loot(Equipment.LootProperties.of((String)AETHER));
        }
        if (FabricLoader.getInstance().isModLoaded(ARSENAL) || ((TweaksConfig)ElementalMod.tweaksConfig.value).ignore_items_required_mods) {
            WeaponsRegister.staff((String)"unique_staff_1", (Weapon.CustomMaterial)Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, (Supplier<Ingredient>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$register$18(), ()Lnet/minecraft/world/item/crafting/Ingredient;)())).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.EARTH.id, (float)7.0f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.WATER.id, (float)7.0f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.AIR.id, (float)7.0f)).spell((ResourceLocation)ElementalWizardSpells.elemental_avatar.id()).loot((Equipment.LootProperties)Equipment.LootProperties.of((int)5, (String)"crystal")).rarity = Rarity.RARE;
        }
        Weapon.register(configs, entries, ElementalGroup.ELEMENTAL_WIZARD_KEY);
    }

    private static /* synthetic */ Ingredient lambda$register$18() {
        return Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_BLOCK});
    }
}

