/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.yesman.epicskills.client.gui.screen.CategorySlotTexture;
import com.yesman.epicskills.client.gui.screen.SkillTreeScreen;
import com.yesman.epicskills.network.NetworkManager;
import com.yesman.epicskills.registry.entry.EpicSkiillsGlobalLootModifer;
import com.yesman.epicskills.registry.entry.EpicSkillsItems;
import com.yesman.epicskills.registry.entry.EpicSkillsSounds;
import com.yesman.epicskills.server.commands.PlayerAbilityPointsCommand;
import com.yesman.epicskills.server.commands.PlayerSkillTreeCommand;
import com.yesman.epicskills.skilltree.SkillTree;
import com.yesman.epicskills.skilltree.SkillTreeEntry;
import com.yesman.epicskills.world.capability.AbilityPoints;
import com.yesman.epicskills.world.capability.SkillTreeProgression;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DataPackRegistryEvent;
import org.slf4j.Logger;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.world.item.EpicFightCreativeTabs;

@Mod(value="epicskills")
public class EpicSkills {
    public static final String MODID = "epicskills";
    public static final Logger LOGGER = LogUtils.getLogger();

    public EpicSkills(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::epicskills$newDataPackRegistryEvent);
        modEventBus.addListener(this::epicskills$doCommonStuff);
        modEventBus.addListener(this::epicskills$buildCreativeTabContents);
        EpicSkillsSounds.SOUNDS.register(modEventBus);
        EpicSkillsItems.ITEMS.register(modEventBus);
        EpicSkiillsGlobalLootModifer.GLOBAL_LOOT_LOOT_MODIFIERS.register(modEventBus);
        MinecraftForge.EVENT_BUS.addListener(this::epicskills$registerCommands);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, AbilityPoints::epicskills$attachCapabilities);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, SkillTreeProgression::epicskills$attachCapabilities);
        if (EpicFightSharedConstants.isPhysicalClient()) {
            CategorySlotTexture.ENUM_MANAGER.registerEnumCls(MODID, SkillTreeScreen.TreePage.NodeButton.CategorySlotTextures.class);
        }
    }

    public void epicskills$newDataPackRegistryEvent(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(SkillTree.SKILL_TREE_REGISTRY_KEY, SkillTree.CODEC, SkillTree.CODEC);
        event.dataPackRegistry(SkillTreeEntry.SKILL_TREE_ENTRY_REGISTRY_KEY, SkillTreeEntry.CODEC, SkillTreeEntry.CODEC);
    }

    private void epicskills$doCommonStuff(FMLCommonSetupEvent event) {
        event.enqueueWork(NetworkManager::registerPackets);
    }

    private void epicskills$registerCommands(RegisterCommandsEvent event) {
        PlayerAbilityPointsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        PlayerSkillTreeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    private void epicskills$buildCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == EpicFightCreativeTabs.ITEMS.get()) {
            event.m_246342_(((Item)EpicSkillsItems.ABILIITY_STONE.get()).m_7968_());
        }
    }

    @Mod.EventBusSubscriber(modid="epicskills", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void epicskills$fmlClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> CategorySlotTexture.ENUM_MANAGER.loadEnum());
        }
    }
}

