/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.yesman.epicskills.client.gui.screen.BackgroundRenderableScreen;
import com.yesman.epicskills.network.NetworkManager;
import com.yesman.epicskills.network.client.ClientBoundUnlockNode;
import com.yesman.epicskills.network.server.ServerBoundUnlockSkillRequest;
import com.yesman.epicskills.skilltree.SkillTree;
import com.yesman.epicskills.world.capability.AbilityPoints;
import com.yesman.epicskills.world.capability.SkillTreeProgression;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.datapack.screen.MessageScreen;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.gui.screen.SlotSelectScreen;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangeSkill;
import yesman.epicfight.skill.SkillContainer;

@OnlyIn(value=Dist.CLIENT)
public class SkillInfoScreen
extends SkillBookScreen {
    private static final ResourceLocation SKILLBOOK_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/gui/screen/skillbook.png");
    private final Holder.Reference<SkillTree> skillTree;
    private final SkillTreeProgression.TopDownTreeNode node;
    private final AbilityPoints abilityPoints;
    private boolean backgroundMode;

    public SkillInfoScreen(Player opener, Holder.Reference<SkillTree> skillTree, SkillTreeProgression.TopDownTreeNode node, Screen parentScreen) {
        super(opener, node.nodeInfo().skill(), null, parentScreen);
        this.skillTree = skillTree;
        this.node = node;
        this.abilityPoints = (AbilityPoints)opener.getCapability(AbilityPoints.ABILITY_POINTS).orElseThrow(() -> new IllegalStateException("No ability points"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.parentScreen.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        boolean active = true;
        MutableComponent tooltip = null;
        Component message = this.node.nodeState().displayedOnButton();
        if (this.node.nodeState() == SkillTreeProgression.NodeState.UNLOCKED) {
            if (this.playerpatch.getSkillCapability().isEquipping(this.skill)) {
                message = Component.m_237115_((String)"gui.epicskills.skillinfo.unequip");
            }
        } else if (this.node.nodeState() == SkillTreeProgression.NodeState.UNLOCKABLE) {
            if (this.node.nodeInfo().requiredAbilityPoints() > this.abilityPoints.getAbilityPoints()) {
                tooltip = Component.m_237110_((String)"gui.epicskills.skillinfo.no_ability_points.tooltip", (Object[])new Object[]{this.node.nodeInfo().requiredAbilityPoints(), this.abilityPoints.getAbilityPoints()});
                active = false;
            }
        } else if (this.node.nodeState() == SkillTreeProgression.NodeState.LOCKED) {
            tooltip = Component.m_237115_((String)"gui.epicskills.skillinfo.locked.tooltip");
            active = false;
        }
        Button actionButton = Button.m_253074_((Component)message, button -> {
            if (this.node.nodeState() == SkillTreeProgression.NodeState.UNLOCKABLE) {
                button.f_93623_ = false;
                NetworkManager.sendToServer(new ServerBoundUnlockSkillRequest((ResourceKey<SkillTree>)this.skillTree.m_205785_(), this.skill));
            } else if (this.node.nodeState() == SkillTreeProgression.NodeState.UNLOCKED) {
                if (this.playerpatch.getSkillCapability().isEquipping(this.skill)) {
                    this.playerpatch.getSkillContainerFor(this.skill).ifPresent(skillContainer -> {
                        skillContainer.setSkill(null);
                        EpicFightNetworkManager.sendToServer((Object)new CPChangeSkill(skillContainer.getSlot(), -1, false, null));
                    });
                    this.f_96541_.m_91152_(this.parentScreen);
                } else {
                    Set skillContainers = this.playerpatch.getSkillCapability().getSkillContainersFor(this.skill.getCategory());
                    if (skillContainers.size() == 1) {
                        this.acquireSkillTo((SkillContainer)skillContainers.iterator().next());
                    } else {
                        SlotSelectScreen slotSelectScreen = new SlotSelectScreen(skillContainers, (SkillBookScreen)this);
                        this.f_96541_.m_91152_((Screen)slotSelectScreen);
                    }
                }
            }
        }).m_252987_(this.f_96543_ / 2 + 54, this.f_96544_ / 2 + 90, 67, 21).m_257505_(tooltip == null ? null : Tooltip.m_257550_((Component)tooltip)).build(x$0 -> new LearnButton((Button.Builder)x$0));
        actionButton.f_93623_ = active;
        this.m_142416_((GuiEventListener)actionButton);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, boolean asBackground) {
        BackgroundRenderableScreen bgModeScreen;
        this.backgroundMode = asBackground;
        Screen screen = this.parentScreen;
        if (screen instanceof BackgroundRenderableScreen) {
            bgModeScreen = (BackgroundRenderableScreen)screen;
            bgModeScreen.setBackgroundMode(true);
        }
        this.parentScreen.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        screen = this.parentScreen;
        if (screen instanceof BackgroundRenderableScreen) {
            bgModeScreen = (BackgroundRenderableScreen)screen;
            bgModeScreen.setBackgroundMode(false);
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_(0.0, 0.0, 1000.0);
        super.render(guiGraphics, mouseX, mouseY, partialTick, asBackground);
        guiGraphics.m_280168_().m_85849_();
        this.backgroundMode = false;
    }

    protected void acquireSkillTo(SkillContainer skillContainer) {
        skillContainer.setSkill(this.skill);
        EpicFightNetworkManager.sendToServer((Object)new CPChangeSkill(skillContainer.getSlot(), -1, false, this.skill));
        this.f_96541_.m_91152_(this.parentScreen);
    }

    public void onSyncPacketArrived(ClientBoundUnlockNode feedbackPacket) {
        if (feedbackPacket.closeScreen()) {
            if (feedbackPacket.askChange()) {
                Set containers = this.playerpatch.getSkillCapability().getSkillContainersFor(feedbackPacket.skill().getCategory());
                this.f_96541_.m_91152_((Screen)new MessageScreen("", (Component)(containers.size() > 1 ? Component.m_237110_((String)"gui.epicskills.messages.change_skill_multiple", (Object[])new Object[]{Component.m_237115_((String)feedbackPacket.skill().getTranslationKey()).getString()}) : Component.m_237110_((String)"gui.epicskills.messages.change_skill_one", (Object[])new Object[]{Component.m_237115_((String)((SkillContainer)containers.iterator().next()).getSkill().getTranslationKey()).getString(), Component.m_237115_((String)feedbackPacket.skill().getTranslationKey()).getString()})), (Screen)this, button -> {
                    if (containers.size() > 1) {
                        SlotSelectScreen slotSelectScreen = new SlotSelectScreen(containers, (SkillBookScreen)this);
                        this.f_96541_.m_91152_((Screen)slotSelectScreen);
                    } else {
                        this.acquireSkillTo((SkillContainer)containers.iterator().next());
                    }
                }, button -> this.f_96541_.m_91152_(this.parentScreen), 180, 0).setLayerFarPlane(2000).autoCalculateHeight());
            } else {
                this.f_96541_.m_91152_(this.parentScreen);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private class LearnButton
    extends Button {
        private final Tooltip customTooltip;

        protected LearnButton(Button.Builder builder) {
            super(builder);
            this.customTooltip = this.m_278622_() != null ? this.m_278622_() : null;
            this.m_257544_(null);
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            int texX = 106;
            if (this.m_198029_() && this.customTooltip != null && !SkillInfoScreen.this.backgroundMode) {
                guiGraphics.m_280245_(SkillInfoScreen.this.f_96547_, this.customTooltip.m_257408_(SkillInfoScreen.this.f_96541_), mouseX, mouseY);
            }
            if (this.m_198029_() || !this.m_142518_() || SkillInfoScreen.this.backgroundMode) {
                texX = 156;
            }
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280027_(SKILLBOOK_BACKGROUND, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 20, 4, 45, 15, texX, 193);
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            guiGraphics.m_280168_().m_85849_();
            int i = this.getFGColor();
            this.m_280139_(guiGraphics, ((SkillInfoScreen)SkillInfoScreen.this).f_96541_.f_91062_, i | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
        }
    }
}

