/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.common.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.Vec3i;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.skill.Skill;

public abstract class SkillTreeProvider
implements DataProvider {
    protected final PackOutput.PathProvider skillTreePagePathProvider;
    protected final PackOutput.PathProvider skillTreeEntryPathProvider;

    public SkillTreeProvider(PackOutput pOutput) {
        this.skillTreePagePathProvider = pOutput.m_245269_(PackOutput.Target.DATA_PACK, "epicskills/tree");
        this.skillTreeEntryPathProvider = pOutput.m_245269_(PackOutput.Target.DATA_PACK, "epicskills/entry");
    }

    public CompletableFuture<?> m_213708_(CachedOutput pOutput) {
        HashSet registeredNames = new HashSet();
        ArrayList tasks = new ArrayList();
        this.buildSkillTreePages(skillTreePageBuilder -> {
            if (!registeredNames.add(skillTreePageBuilder.name)) {
                throw new IllegalStateException("Duplicate skill tree page: " + skillTreePageBuilder.name);
            }
            tasks.add(DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)skillTreePageBuilder.serializePage(), (Path)this.skillTreePagePathProvider.m_245731_(skillTreePageBuilder.name)));
            tasks.add(DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)skillTreePageBuilder.serializeNodes(), (Path)this.skillTreeEntryPathProvider.m_245731_(skillTreePageBuilder.name)));
        });
        return CompletableFuture.allOf((CompletableFuture[])tasks.toArray(CompletableFuture[]::new));
    }

    protected abstract void buildSkillTreePages(Consumer<SkillTreePageBuilder> var1);

    public String m_6055_() {
        return "Skill Trees";
    }

    protected static SkillTreePageBuilder newPage(String modid, String name) {
        return new SkillTreePageBuilder(ResourceLocation.fromNamespaceAndPath((String)modid, (String)name));
    }

    protected static class SkillTreePageBuilder {
        final ResourceLocation name;
        final Map<Skill, SkillTreeNodeBuilder> nodes = new LinkedHashMap<Skill, SkillTreeNodeBuilder>();
        Vec3i menuBarColor = new Vec3i(255, 255, 255);
        @Nullable
        EntityPredicate conditions = null;
        @Nullable
        String unlockTipTranslationKey;
        boolean locked = false;
        boolean hiddenWhenLocked = false;
        int priority = 100;

        public SkillTreePageBuilder(ResourceLocation name) {
            this.name = name;
        }

        public JsonObject serializePage() {
            JsonObject jsonObject = new JsonObject();
            JsonArray menuColor = new JsonArray();
            menuColor.add((Number)this.menuBarColor.m_123341_());
            menuColor.add((Number)this.menuBarColor.m_123342_());
            menuColor.add((Number)this.menuBarColor.m_123343_());
            jsonObject.add("menu_color", (JsonElement)menuColor);
            jsonObject.addProperty("locked", Boolean.valueOf(this.locked));
            jsonObject.addProperty("hidden", Boolean.valueOf(this.hiddenWhenLocked));
            if (this.conditions != null) {
                jsonObject.add("conditions", this.conditions.m_36606_());
            }
            if (this.unlockTipTranslationKey != null) {
                jsonObject.addProperty("unlock_tip", this.unlockTipTranslationKey);
            }
            if (this.priority != 100) {
                jsonObject.addProperty("priority", (Number)this.priority);
            }
            return jsonObject;
        }

        public JsonObject serializeNodes() {
            JsonObject jsonObject = new JsonObject();
            JsonArray nodes = new JsonArray();
            for (Map.Entry<Skill, SkillTreeNodeBuilder> entry : this.nodes.entrySet()) {
                JsonObject node = new JsonObject();
                node.addProperty("skill", entry.getKey().getRegistryName().toString());
                if (!entry.getValue().parentSkill.isEmpty()) {
                    JsonArray parents = new JsonArray();
                    for (Pair<Skill, List<Vec2i>> parent : entry.getValue().parentSkill) {
                        JsonObject parentObj = new JsonObject();
                        parentObj.addProperty("skill", ((Skill)parent.getFirst()).getRegistryName().toString());
                        if (!((List)parent.getSecond()).isEmpty()) {
                            JsonArray controlPoints = new JsonArray();
                            for (Vec2i pos : (List)parent.getSecond()) {
                                JsonArray position = new JsonArray();
                                position.add((Number)pos.x);
                                position.add((Number)pos.y);
                                controlPoints.add((JsonElement)position);
                            }
                            parentObj.add("control_points", (JsonElement)controlPoints);
                        }
                        parents.add((JsonElement)parentObj);
                    }
                    node.add("parents", (JsonElement)parents);
                }
                if (entry.getValue().unlockCondition != null) {
                    node.add("conditions", entry.getValue().unlockCondition.m_36606_());
                    node.addProperty("custom_condition", Boolean.valueOf(entry.getValue().hasCustomUnlockCondition));
                    if (entry.getValue().unlockTipTranslationKey != null) {
                        node.addProperty("unlock_tip", entry.getValue().unlockTipTranslationKey);
                    }
                }
                node.addProperty("ability_points", (Number)entry.getValue().abilityPointsRequirement);
                JsonArray positionInScreen = new JsonArray();
                positionInScreen.add((Number)entry.getValue().positionInScreen.x);
                positionInScreen.add((Number)entry.getValue().positionInScreen.y);
                node.add("position_in_screen", (JsonElement)positionInScreen);
                node.addProperty("hidden", Boolean.valueOf(entry.getValue().hiddenWhenLocked));
                if (entry.getValue().importFrom != null) {
                    node.addProperty("import", entry.getValue().importFrom.toString());
                }
                nodes.add((JsonElement)node);
            }
            jsonObject.add("nodes", (JsonElement)nodes);
            return jsonObject;
        }

        public SkillTreePageBuilder menuBarColor(int r, int g, int b) {
            this.menuBarColor = new Vec3i(r, g, b);
            return this;
        }

        public SkillTreePageBuilder setLocked(EntityPredicate entityPredicate) {
            this.conditions = entityPredicate;
            this.locked = true;
            return this;
        }

        public SkillTreePageBuilder unlockTipTranslationKey(String unlockTipTranslationKey) {
            this.unlockTipTranslationKey = unlockTipTranslationKey;
            return this;
        }

        public SkillTreePageBuilder hiddenWhenLocked(boolean hiddenWhenLocked) {
            this.hiddenWhenLocked = hiddenWhenLocked;
            return this;
        }

        public SkillTreePageBuilder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public SkillTreeNodeBuilder newNode(Skill skill) {
            SkillTreeNodeBuilder nodeBuilder = new SkillTreeNodeBuilder(skill);
            this.nodes.put(skill, nodeBuilder);
            return nodeBuilder;
        }

        public class SkillTreeNodeBuilder {
            final Skill skill;
            final List<Pair<Skill, List<Vec2i>>> parentSkill = new ArrayList<Pair<Skill, List<Vec2i>>>();
            @Nullable
            EntityPredicate unlockCondition;
            boolean hasCustomUnlockCondition;
            @Nullable
            String unlockTipTranslationKey;
            Vec2i positionInScreen;
            int abilityPointsRequirement = 1;
            boolean hiddenWhenLocked = false;
            @Nullable
            ResourceLocation importFrom;

            private SkillTreeNodeBuilder(Skill skill) {
                if (SkillTreePageBuilder.this.nodes.containsKey(skill)) {
                    throw new IllegalStateException(skill.getRegistryName() + " already exists");
                }
                this.skill = skill;
                SkillTreePageBuilder.this.nodes.put(skill, this);
            }

            public SkillTreeNodeBuilder unlockCondition(EntityPredicate unlockCondition) {
                this.unlockCondition = unlockCondition;
                return this;
            }

            public SkillTreeNodeBuilder hasCustomUnlockCondition(boolean hasCustomUnlockCondition) {
                this.hasCustomUnlockCondition = hasCustomUnlockCondition;
                return this;
            }

            public SkillTreeNodeBuilder unlockTipTranslationKey(String unlockTipTranslationKey) {
                this.unlockTipTranslationKey = unlockTipTranslationKey;
                return this;
            }

            public SkillTreeNodeBuilder position(int x, int y) {
                this.positionInScreen = new Vec2i(x, y);
                return this;
            }

            public SkillTreeNodeBuilder abilityPointsRequirement(int abilityPointsRequirement) {
                this.abilityPointsRequirement = abilityPointsRequirement;
                return this;
            }

            public SkillTreeNodeBuilder hiddenWhenLocked(boolean hiddenWhenLocked) {
                this.hiddenWhenLocked = hiddenWhenLocked;
                return this;
            }

            public SkillTreeNodeBuilder importFrom(ResourceLocation importFrom) {
                this.importFrom = importFrom;
                return this;
            }

            public SkillTreeNodeBuilder addParent(Skill skill, Vec2i ... controlPoints) {
                if (this.skill == skill) {
                    throw new IllegalArgumentException("Can't connect to myself");
                }
                if (!SkillTreePageBuilder.this.nodes.containsKey(skill)) {
                    throw new IllegalStateException("Tried connecting to a " + skill.getRegistryName() + " node but nothing has found.");
                }
                this.parentSkill.add((Pair<Skill, List<Vec2i>>)Pair.of((Object)skill, List.of(controlPoints)));
                return this;
            }

            public SkillTreePageBuilder done() {
                return SkillTreePageBuilder.this;
            }
        }
    }
}

