/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.event;

import com.yesman.epicskills.network.NetworkManager;
import com.yesman.epicskills.network.client.ClientBoundReloadSkillTree;
import com.yesman.epicskills.network.client.ClientBoundTreeInitSyncPacket;
import com.yesman.epicskills.registry.entry.EpicSkillsItems;
import com.yesman.epicskills.world.capability.AbilityPoints;
import com.yesman.epicskills.world.capability.SkillTreeProgression;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

@Mod.EventBusSubscriber(modid="epicskills")
public abstract class GameEvents {
    @SubscribeEvent
    public static void epicskills$entityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.getCapability(AbilityPoints.ABILITY_POINTS).ifPresent(abilityPoints -> {
                abilityPoints.markDirty();
                abilityPoints.sendChanges();
            });
            serverplayer.getCapability(SkillTreeProgression.SKILL_TREE_PROGRESSION).ifPresent(skillTreeProgression -> {
                CompoundTag compound = new CompoundTag();
                skillTreeProgression.serializeTo(compound);
                NetworkManager.sendToPlayer(new ClientBoundTreeInitSyncPacket(compound), serverplayer);
            });
        }
    }

    @SubscribeEvent
    public static void epicskills$onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            for (ServerPlayer serverPlayer : event.getPlayers()) {
                serverPlayer.getCapability(SkillTreeProgression.SKILL_TREE_PROGRESSION).ifPresent(skillTreeProgression -> {
                    skillTreeProgression.reload(true);
                    NetworkManager.sendToPlayer(new ClientBoundReloadSkillTree(true), serverPlayer);
                });
            }
        }
    }

    @SubscribeEvent
    public static void epicskills$playerTickPost(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().m_5776_() && event.player.f_19797_ % event.player.m_6095_().m_20682_() == 0) {
            event.player.getCapability(AbilityPoints.ABILITY_POINTS).ifPresent(abilityPoints -> abilityPoints.sendChanges());
            event.player.getCapability(SkillTreeProgression.SKILL_TREE_PROGRESSION).ifPresent(skilltreeProgression -> skilltreeProgression.tick());
        }
    }

    @SubscribeEvent
    public static void epicskills$playerClone(PlayerEvent.Clone event) {
        boolean copyCaps;
        boolean bl = copyCaps = !event.isWasDeath() || (Boolean)EpicFightGameRules.KEEP_SKILLS.getRuleValue(event.getOriginal().m_9236_()) != false;
        if (!copyCaps) {
            return;
        }
        event.getOriginal().reviveCaps();
        event.getOriginal().getCapability(SkillTreeProgression.SKILL_TREE_PROGRESSION).ifPresent(skillTreeProgression -> event.getEntity().getCapability(SkillTreeProgression.SKILL_TREE_PROGRESSION).ifPresent(skillTreeProgression$2 -> {
            CompoundTag compound = new CompoundTag();
            skillTreeProgression.serializeTo(compound);
            skillTreeProgression$2.deserializeFrom(compound);
        }));
        event.getOriginal().getCapability(AbilityPoints.ABILITY_POINTS).ifPresent(abilityPoints -> event.getEntity().getCapability(AbilityPoints.ABILITY_POINTS).ifPresent(abilityPoints$2 -> {
            CompoundTag compound = new CompoundTag();
            abilityPoints.serializeTo(compound);
            abilityPoints$2.deserializeFrom(compound);
        }));
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void epicskills$lootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)BuiltInLootTables.f_78742_) || event.getName().equals((Object)BuiltInLootTables.f_78690_) || event.getName().equals((Object)BuiltInLootTables.f_78691_) || event.getName().equals((Object)BuiltInLootTables.f_78759_) || event.getName().equals((Object)BuiltInLootTables.f_78760_) || event.getName().equals((Object)BuiltInLootTables.f_78701_) || event.getName().equals((Object)BuiltInLootTables.f_78694_) || event.getName().equals((Object)BuiltInLootTables.f_78693_) || event.getName().equals((Object)BuiltInLootTables.f_78698_)) {
            event.getTable().addPool(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)10.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicSkillsItems.ABILIITY_STONE.get()))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.05f)).m_79082_());
        }
        if (event.getName().equals((Object)BuiltInLootTables.f_230876_) || event.getName().equals((Object)BuiltInLootTables.f_78741_) || event.getName().equals((Object)BuiltInLootTables.f_78699_) || event.getName().equals((Object)BuiltInLootTables.f_78700_) || event.getName().equals((Object)BuiltInLootTables.f_78764_) || event.getName().equals((Object)BuiltInLootTables.f_78696_) || event.getName().equals((Object)BuiltInLootTables.f_78687_) || event.getName().equals((Object)BuiltInLootTables.f_78695_) || event.getName().equals((Object)BuiltInLootTables.f_78763_) || event.getName().equals((Object)BuiltInLootTables.f_78762_)) {
            event.getTable().addPool(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicSkillsItems.ABILIITY_STONE.get()))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.15f)).m_79082_());
        }
        if (event.getName().equals((Object)BuiltInLootTables.f_78692_) || event.getName().equals((Object)BuiltInLootTables.f_78686_) || event.getName().equals((Object)BuiltInLootTables.f_78761_) || event.getName().equals((Object)BuiltInLootTables.f_78697_) || event.getName().equals((Object)BuiltInLootTables.f_78689_)) {
            event.getTable().addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)EpicSkillsItems.ABILIITY_STONE.get()))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.75f)).m_79082_());
        }
    }
}

