/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Iterator;

public final class JsonUtil {
    private JsonUtil() {
    }

    public static JsonElement removeNullElements(JsonElement json) {
        if (json instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)json;
            Iterator arrayElement = jsonArray.iterator();
            while (arrayElement.hasNext()) {
                JsonElement element = (JsonElement)arrayElement.next();
                if (element == null || element == JsonNull.INSTANCE) {
                    arrayElement.remove();
                    continue;
                }
                JsonUtil.removeNullElements(element);
            }
        } else if (json instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)json;
            jsonObject.entrySet().removeIf(entry -> entry.getValue() == null || entry.getValue() == JsonNull.INSTANCE);
            jsonObject.entrySet().forEach(entry -> JsonUtil.removeNullElements((JsonElement)entry.getValue()));
        }
        return json;
    }
}

