/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.client.gui.components.toasts;

import com.yesman.epicskills.client.gui.screen.SkillTreeScreen;
import com.yesman.epicskills.skilltree.SkillTree;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.FastColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkillTreeToast
implements Toast {
    private final Holder.Reference<SkillTree> skillTree;

    public SkillTreeToast(Holder.Reference<SkillTree> skillTree) {
        this.skillTree = skillTree;
    }

    public Toast.Visibility render(GuiGraphics pGuiGraphics, ToastComponent pToastComponent, long pTimeSinceLastVisible) {
        if (this.skillTree == null || this.skillTree.value() == null) {
            return Toast.Visibility.HIDE;
        }
        pGuiGraphics.blitSprite(TutorialToast.BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        pGuiGraphics.blit(SkillTreeScreen.SKILL_TREE_ICON_TEXTURES.apply(this.skillTree), 3, -1, 0.0f, 0.0f, 32, 32, 32, 32);
        MutableComponent line1 = Component.translatable((String)"chat.epicskills.unlock_notification");
        MutableComponent line2 = ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)SkillTree.toDescriptionId((ResourceKey<SkillTree>)this.skillTree.key())));
        Vec3i color = ((SkillTree)this.skillTree.value()).menuBarColor();
        pGuiGraphics.drawString(pToastComponent.getMinecraft().font, (Component)line1, 36, 6, -1);
        pGuiGraphics.drawString(pToastComponent.getMinecraft().font, (Component)line2, 36, 17, FastColor.ARGB32.color((int)255, (int)color.getX(), (int)color.getY(), (int)color.getZ()));
        return (double)pTimeSinceLastVisible >= 5000.0 * pToastComponent.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

