/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.yesman.epicskills.client.gui.screen.BackgroundRenderableScreen;
import com.yesman.epicskills.neoforge.attachment.AbilityPoints;
import com.yesman.epicskills.neoforge.attachment.SkillTreeProgression;
import com.yesman.epicskills.network.client.ClientBoundUnlockNode;
import com.yesman.epicskills.network.server.ServerBoundUnlockSkillRequest;
import com.yesman.epicskills.registry.entry.EpicSkillsAttachmentTypes;
import com.yesman.epicskills.skilltree.SkillTree;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.datapack.screen.MessageScreen;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.gui.screen.SlotSelectScreen;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangeSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;

@OnlyIn(value=Dist.CLIENT)
public class SkillInfoScreen
extends SkillBookScreen {
    private final Holder.Reference<SkillTree> skillTree;
    private final SkillTreeProgression.TopDownTreeNode node;
    private final AbilityPoints abilityPoints;
    private boolean backgroundMode;

    public SkillInfoScreen(Player opener, Holder.Reference<SkillTree> skillTree, SkillTreeProgression.TopDownTreeNode node, Screen parentScreen) {
        super(opener, node.nodeInfo().skill(), null, parentScreen);
        this.skillTree = skillTree;
        this.node = node;
        this.abilityPoints = (AbilityPoints)opener.getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).orElseThrow(() -> new IllegalStateException("No ability points"));
    }

    protected void init() {
        super.init();
        this.parentScreen.init(this.minecraft, this.width, this.height);
        boolean active = true;
        MutableComponent tooltip = null;
        Component message = this.node.nodeState().displayedOnButton();
        if (this.node.nodeState() == SkillTreeProgression.NodeState.UNLOCKED) {
            if (this.playerpatch.getPlayerSkills().isEquipping(this.skill)) {
                message = Component.translatable((String)"gui.epicskills.skillinfo.unequip");
            }
        } else if (this.node.nodeState() == SkillTreeProgression.NodeState.UNLOCKABLE) {
            if (this.node.nodeInfo().requiredAbilityPoints() > this.abilityPoints.getAbilityPoints()) {
                tooltip = Component.translatable((String)"gui.epicskills.skillinfo.no_ability_points.tooltip", (Object[])new Object[]{this.node.nodeInfo().requiredAbilityPoints(), this.abilityPoints.getAbilityPoints()});
                active = false;
            }
        } else if (this.node.nodeState() == SkillTreeProgression.NodeState.LOCKED) {
            tooltip = Component.translatable((String)"gui.epicskills.skillinfo.locked.tooltip");
            active = false;
        }
        Button actionButton = Button.builder((Component)message, button -> {
            if (this.node.nodeState() == SkillTreeProgression.NodeState.UNLOCKABLE) {
                button.active = false;
                EpicFightNetworkManager.sendToServer((CustomPacketPayload)new ServerBoundUnlockSkillRequest((ResourceKey<SkillTree>)this.skillTree.key(), (Holder<Skill>)this.skill.holder()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (this.node.nodeState() == SkillTreeProgression.NodeState.UNLOCKED) {
                if (this.playerpatch.getPlayerSkills().isEquipping(this.skill)) {
                    this.playerpatch.getSkillContainerFor(this.skill).ifPresent(skillContainer -> {
                        skillContainer.setSkill(null);
                        EpicFightNetworkManager.sendToServer((CustomPacketPayload)new CPChangeSkill(skillContainer.getSlot(), null, -1, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    });
                    this.minecraft.setScreen(this.parentScreen);
                } else {
                    Set skillContainers = this.playerpatch.getPlayerSkills().getSkillContainersFor(this.skill.getCategory());
                    if (skillContainers.size() == 1) {
                        this.acquireSkillTo((SkillContainer)skillContainers.iterator().next());
                    } else {
                        SlotSelectScreen slotSelectScreen = new SlotSelectScreen(skillContainers, (SkillBookScreen)this);
                        this.minecraft.setScreen((Screen)slotSelectScreen);
                    }
                }
            }
        }).bounds(this.width / 2 + 54, this.height / 2 + 90, 67, 21).tooltip(tooltip == null ? null : Tooltip.create((Component)tooltip)).build(x$0 -> new LearnButton((Button.Builder)x$0));
        actionButton.active = active;
        this.addRenderableWidget((GuiEventListener)actionButton);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, boolean asBackground) {
        BackgroundRenderableScreen bgModeScreen;
        this.backgroundMode = asBackground;
        Screen screen = this.parentScreen;
        if (screen instanceof BackgroundRenderableScreen) {
            bgModeScreen = (BackgroundRenderableScreen)screen;
            bgModeScreen.setBackgroundMode(true);
        }
        this.parentScreen.render(guiGraphics, mouseX, mouseY, partialTick);
        screen = this.parentScreen;
        if (screen instanceof BackgroundRenderableScreen) {
            bgModeScreen = (BackgroundRenderableScreen)screen;
            bgModeScreen.setBackgroundMode(false);
        }
        guiGraphics.pose().pushPose();
        super.render(guiGraphics, mouseX, mouseY, partialTick, asBackground);
        guiGraphics.pose().popPose();
        this.backgroundMode = false;
    }

    protected void acquireSkillTo(SkillContainer skillContainer) {
        skillContainer.setSkill(this.skill);
        EpicFightNetworkManager.sendToServer((CustomPacketPayload)new CPChangeSkill(skillContainer.getSlot(), this.skill.holder(), -1, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.minecraft.setScreen(this.parentScreen);
    }

    public void onSyncPacketArrived(ClientBoundUnlockNode feedbackPacket) {
        if (feedbackPacket.closeScreen()) {
            if (feedbackPacket.askChange()) {
                Set containers = this.playerpatch.getPlayerSkills().getSkillContainersFor(((Skill)feedbackPacket.skill().value()).getCategory());
                this.minecraft.setScreen((Screen)new MessageScreen("", (Component)(containers.size() > 1 ? Component.translatable((String)"gui.epicskills.messages.change_skill_multiple", (Object[])new Object[]{Component.translatable((String)((Skill)feedbackPacket.skill().value()).getTranslationKey()).getString()}) : Component.translatable((String)"gui.epicskills.messages.change_skill_one", (Object[])new Object[]{Component.translatable((String)((SkillContainer)containers.iterator().next()).getSkill().getTranslationKey()).getString(), Component.translatable((String)((Skill)feedbackPacket.skill().value()).getTranslationKey()).getString()})), (Screen)this, button -> {
                    if (containers.size() > 1) {
                        SlotSelectScreen slotSelectScreen = new SlotSelectScreen(containers, (SkillBookScreen)this);
                        this.minecraft.setScreen((Screen)slotSelectScreen);
                    } else {
                        this.acquireSkillTo((SkillContainer)containers.iterator().next());
                    }
                }, button -> this.minecraft.setScreen(this.parentScreen), 180, 0).setLayerFarPlane(2000).autoCalculateHeight());
            } else {
                this.minecraft.setScreen(this.parentScreen);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private class LearnButton
    extends Button {
        protected static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"widget/skillbook_button"), ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"widget/skillbook_button_disabled"), ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"widget/skillbook_button_highlighted"));
        private final Tooltip customTooltip;

        protected LearnButton(Button.Builder builder) {
            super(builder);
            this.customTooltip = this.getTooltip() != null ? this.getTooltip() : null;
            this.setTooltip(null);
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            Minecraft minecraft = Minecraft.getInstance();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            if (this.isHoveredOrFocused() && this.customTooltip != null && !SkillInfoScreen.this.backgroundMode) {
                guiGraphics.renderTooltip(SkillInfoScreen.this.font, this.customTooltip.toCharSequence(minecraft), mouseX, mouseY);
            }
            guiGraphics.pose().pushPose();
            guiGraphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            guiGraphics.pose().popPose();
            int i = this.getFGColor();
            this.renderString(guiGraphics, minecraft.font, i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
        }
    }
}

