/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.neoforge.attachment;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.yesman.epicskills.network.client.ClientBoundSetAbilityPoints;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import yesman.epicfight.network.EpicFightNetworkManager;

public class AbilityPoints {
    public static final int INIT_EXP_REQUIREMENT = 7;
    private int abilityPoint = 0;
    private int requiredExp = 7;
    private int requiredExpLevel = 0;
    private boolean dirty = false;
    private final Player player;

    public static int getXpNeededForNextLevel(int expLevel) {
        if (expLevel >= 30) {
            return 112 + (expLevel - 30) * 9;
        }
        return expLevel >= 15 ? 37 + (expLevel - 15) * 5 : 7 + expLevel * 2;
    }

    public AbilityPoints(IAttachmentHolder attachmentHolder) {
        Player player;
        if (!(attachmentHolder instanceof Player)) {
            throw new IllegalArgumentException(String.valueOf(attachmentHolder) + " is not a subtype of Player");
        }
        this.player = player = (Player)attachmentHolder;
    }

    public boolean hasEnoughExp() {
        return this.player.totalExperience >= this.requiredExp;
    }

    public boolean convertExpToAbilityPoints() {
        if (!this.hasEnoughExp()) {
            return false;
        }
        this.player.giveExperiencePoints(-this.requiredExp);
        ++this.abilityPoint;
        this.requiredExp = this.requiredExpLevel < 15 ? (this.requiredExp += 2) : (this.requiredExpLevel < 30 ? (this.requiredExp += 4) : (this.requiredExp += 6));
        while (this.requiredExp > AbilityPoints.getXpNeededForNextLevel(this.requiredExpLevel)) {
            ++this.requiredExpLevel;
        }
        return true;
    }

    public void setRequiredExp(int requiredExp) {
        this.requiredExp = Mth.clamp((int)requiredExp, (int)0, (int)Integer.MAX_VALUE);
        this.requiredExpLevel = 0;
        int requiredExpForNextLevel = AbilityPoints.getXpNeededForNextLevel(this.requiredExpLevel);
        for (int totalExp = this.requiredExp; totalExp >= requiredExpForNextLevel; totalExp -= requiredExpForNextLevel) {
            requiredExpForNextLevel = AbilityPoints.getXpNeededForNextLevel(++this.requiredExpLevel);
        }
    }

    public int getRequiredExp() {
        return this.requiredExp;
    }

    public void setAbilityPoints(int abilityPoint) {
        this.abilityPoint = Mth.clamp((int)abilityPoint, (int)0, (int)Integer.MAX_VALUE);
    }

    public int getAbilityPoints() {
        return this.abilityPoint;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void sendChanges() {
        if (this.player.level().isClientSide()) {
            return;
        }
        ServerPlayer serverplayer = (ServerPlayer)this.player;
        if (this.dirty) {
            EpicFightNetworkManager.sendToPlayer((CustomPacketPayload)new ClientBoundSetAbilityPoints(false, this.abilityPoint, this.requiredExp), (ServerPlayer)serverplayer, (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.dirty = false;
        }
        EntityPredicate.CODEC.decode((DynamicOps)JsonOps.INSTANCE, null);
    }

    public void serializeTo(CompoundTag compound) {
        compound.putInt("abilityPoint", this.abilityPoint);
        compound.putInt("requiredExp", this.requiredExp);
        compound.putInt("requiredExpLevel", this.requiredExpLevel);
    }

    public void deserializeFrom(CompoundTag nbt) {
        if (nbt.contains("abilityPoint", 3)) {
            this.abilityPoint = nbt.getInt("abilityPoint");
        }
        if (nbt.contains("requiredExp", 3)) {
            this.requiredExp = nbt.getInt("requiredExp");
        }
        if (nbt.contains("requiredExpLevel", 3)) {
            this.requiredExpLevel = nbt.getInt("requiredExpLevel");
        }
    }
}

