/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.network.client;

import com.yesman.epicskills.client.gui.screen.SkillTreeScreen;
import com.yesman.epicskills.network.NetworkManager;
import com.yesman.epicskills.world.capability.AbilityPoints;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record ClientBoundSetAbilityPoints(boolean success, int abilityPoint, int requiredExp) {
    public static ClientBoundSetAbilityPoints fromBytes(FriendlyByteBuf buf) {
        ClientBoundSetAbilityPoints msg = new ClientBoundSetAbilityPoints(buf.readBoolean(), buf.readInt(), buf.readInt());
        return msg;
    }

    public static void toBytes(ClientBoundSetAbilityPoints msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.success());
        buf.writeInt(msg.abilityPoint());
        buf.writeInt(msg.requiredExp());
    }

    public static void handle(ClientBoundSetAbilityPoints msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Screen patt1095$temp = Minecraft.m_91087_().f_91080_;
            if (patt1095$temp instanceof SkillTreeScreen) {
                SkillTreeScreen skillTreeScreen = (SkillTreeScreen)patt1095$temp;
                skillTreeScreen.onSyncPacketArrived(msg);
            }
            NetworkManager.getPlayerInClient().getCapability(AbilityPoints.ABILITY_POINTS).ifPresent(abilityPoint -> {
                abilityPoint.setAbilityPoints(msg.abilityPoint());
                abilityPoint.setRequiredExp(msg.requiredExp());
                NetworkManager.getPlayerInClient().m_6756_(-abilityPoint.getRequiredExp());
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

