/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.network.client;

import com.yesman.epicskills.network.NetworkManager;
import com.yesman.epicskills.skilltree.SkillTree;
import com.yesman.epicskills.world.capability.SkillTreeProgression;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.network.NetworkEvent;

public record ClientBoundSetTreeState(ResourceKey<SkillTree> skillTree, SkillTreeProgression.TreeState treeState, boolean unequip) {
    public static ClientBoundSetTreeState fromBytes(FriendlyByteBuf buf) {
        return new ClientBoundSetTreeState((ResourceKey<SkillTree>)buf.m_236801_(SkillTree.SKILL_TREE_REGISTRY_KEY), (SkillTreeProgression.TreeState)buf.m_130066_(SkillTreeProgression.TreeState.class), buf.readBoolean());
    }

    public static void toBytes(ClientBoundSetTreeState msg, FriendlyByteBuf buf) {
        buf.m_236858_(msg.skillTree());
        buf.m_130068_((Enum)msg.treeState());
        buf.writeBoolean(msg.unequip());
    }

    public static void handle(ClientBoundSetTreeState msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> NetworkManager.getPlayerInClient().getCapability(SkillTreeProgression.SKILL_TREE_PROGRESSION).ifPresent(skilltreeProgression -> skilltreeProgression.processSyncPacket(msg)));
        ctx.get().setPacketHandled(true);
    }

    public static enum Action {
        LOCK,
        UNLOCK;

    }
}

