/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.neoforge.attachment;

import com.mojang.datafixers.util.Pair;
import com.yesman.epicskills.EpicSkills;
import com.yesman.epicskills.client.gui.components.toasts.SkillTreeNodeToast;
import com.yesman.epicskills.client.gui.components.toasts.SkillTreeToast;
import com.yesman.epicskills.client.gui.screen.SkillInfoScreen;
import com.yesman.epicskills.neoforge.attachment.AbilityPoints;
import com.yesman.epicskills.network.client.ClientBoundSetTreeState;
import com.yesman.epicskills.network.client.ClientBoundUnlockNode;
import com.yesman.epicskills.skilltree.SkillTree;
import com.yesman.epicskills.skilltree.SkillTreeEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.registry.EpicFightRegistries;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class SkillTreeProgression {
    private final RegistryAccess registryAccess;
    private final Map<Holder.Reference<SkillTree>, TreeState> treeStates = new HashMap<Holder.Reference<SkillTree>, TreeState>();
    private final Map<Holder.Reference<SkillTree>, Map<Skill, TopDownTreeNode>> nodes = new HashMap<Holder.Reference<SkillTree>, Map<Skill, TopDownTreeNode>>();
    private final Map<Holder.Reference<SkillTree>, Map<Skill, TopDownTreeNode>> rootNodes = new HashMap<Holder.Reference<SkillTree>, Map<Skill, TopDownTreeNode>>();
    private final List<Pair<Holder.Reference<SkillTree>, TopDownTreeNode>> unlockAwaitingNodes = new LinkedList<Pair<Holder.Reference<SkillTree>, TopDownTreeNode>>();
    private final Player player;

    public SkillTreeProgression(IAttachmentHolder attachmentHolder) {
        if (!(attachmentHolder instanceof Player)) {
            throw new IllegalArgumentException(String.valueOf(attachmentHolder) + " is not a subtype of Player");
        }
        Player player = (Player)attachmentHolder;
        this.registryAccess = player.registryAccess();
        this.player = player;
        this.reload(false);
    }

    public void reload(boolean readOldData) {
        CompoundTag compound = null;
        if (readOldData) {
            compound = new CompoundTag();
            this.serializeTo(compound);
        }
        this.treeStates.clear();
        this.nodes.clear();
        this.rootNodes.clear();
        this.unlockAwaitingNodes.clear();
        HolderLookup.RegistryLookup skillTreeRegistry = this.registryAccess.lookupOrThrow(SkillTree.SKILL_TREE_REGISTRY_KEY);
        skillTreeRegistry.listElements().forEach(skillTree -> {
            this.treeStates.put((Holder.Reference<SkillTree>)skillTree, ((SkillTree)skillTree.value()).locked() ? TreeState.LOCKED : TreeState.UNLOCKED);
            this.nodes.put((Holder.Reference<SkillTree>)skillTree, new LinkedHashMap());
            this.rootNodes.put((Holder.Reference<SkillTree>)skillTree, new HashMap());
        });
        ArrayList importedNodes = new ArrayList();
        this.registryAccess.registryOrThrow(SkillTreeEntry.SKILL_TREE_ENTRY_REGISTRY_KEY).holders().sorted((h1, h2) -> SkillTreeEntry.comparator((SkillTreeEntry)h1.value(), (SkillTreeEntry)h2.value())).forEach(arg_0 -> this.lambda$reload$4((HolderLookup)skillTreeRegistry, importedNodes, arg_0));
        importedNodes.forEach(importedNode -> {
            if (!this.nodes.containsKey(importedNode.getImportedTree())) {
                EpicSkills.LOGGER.warn("No skill tree page: " + String.valueOf(importedNode.getImportedTree()));
                return;
            }
            Map<Skill, TopDownTreeNode> pageNodes = this.nodes.get(importedNode.getImportedTree());
            if (!pageNodes.containsKey(importedNode.nodeInfo().skill())) {
                EpicSkills.LOGGER.warn("No skill " + String.valueOf(importedNode.nodeInfo().skill()) + " in skill tree page: " + String.valueOf(importedNode.getImportedTree()));
                return;
            }
            TopDownTreeNode importedOriginalNode = pageNodes.get(importedNode.nodeInfo().skill());
            importedOriginalNode.children().addAll(importedNode.children());
            importedNode.children().forEach(importedNodeChild -> importedNodeChild.parents().add(importedOriginalNode));
        });
        if (readOldData) {
            this.deserializeFrom(compound);
        }
    }

    public void tick() {
        if (this.player.level().isClientSide()) {
            return;
        }
        ServerPlayer serverplayer = (ServerPlayer)this.player;
        EpicFightNetworkManager.PayloadBundleBuilder payloadsbuilder = EpicFightNetworkManager.PayloadBundleBuilder.create();
        this.treeStates.forEach((tree, state) -> {
            if (state == TreeState.LOCKED && !((SkillTree)tree.value()).noUnlcokConditions() && ((SkillTree)tree.value()).conditions().matches(serverplayer, (Entity)serverplayer)) {
                this.treeStates.put((Holder.Reference<SkillTree>)tree, TreeState.UNLOCKED);
                payloadsbuilder.and((CustomPacketPayload)new ClientBoundSetTreeState((ResourceKey<SkillTree>)tree.key(), TreeState.UNLOCKED, false));
            }
        });
        this.unlockAwaitingNodes.removeIf(pair -> {
            boolean meets = ((TopDownTreeNode)pair.getSecond()).nodeInfo().unlockCondition().matches(serverplayer, (Entity)serverplayer);
            if (meets) {
                ((TopDownTreeNode)pair.getSecond()).setNodeState(NodeState.UNLOCKABLE, true, false);
                payloadsbuilder.and((CustomPacketPayload)new ClientBoundUnlockNode((ResourceKey<SkillTree>)((Holder.Reference)pair.getFirst()).key(), (Holder<Skill>)((TopDownTreeNode)pair.getSecond()).nodeInfo().skill().holder(), NodeState.UNLOCKABLE, true, false, false, false));
            }
            return meets;
        });
        payloadsbuilder.send((first, others) -> EpicFightNetworkManager.sendToPlayer((CustomPacketPayload)first, (ServerPlayer)serverplayer, (CustomPacketPayload[])others));
    }

    public void unlockTree(ResourceLocation id) {
        ResourceKey rk = ResourceKey.create(SkillTree.SKILL_TREE_REGISTRY_KEY, (ResourceLocation)id);
        Holder.Reference holder = this.player.level().holderLookup(SkillTree.SKILL_TREE_REGISTRY_KEY).getOrThrow(rk);
        this.unlockTree((Holder.Reference<SkillTree>)holder);
    }

    public void unlockTree(Holder.Reference<SkillTree> skillTree) {
        this.treeStates.put(skillTree, TreeState.UNLOCKED);
        if (!this.player.level().isClientSide()) {
            EpicFightNetworkManager.sendToPlayer((CustomPacketPayload)new ClientBoundSetTreeState((ResourceKey<SkillTree>)skillTree.key(), TreeState.UNLOCKED, true), (ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void canLockTree(ResourceLocation id) {
        ResourceKey rk = ResourceKey.create(SkillTree.SKILL_TREE_REGISTRY_KEY, (ResourceLocation)id);
        Holder.Reference holder = this.player.level().holderLookup(SkillTree.SKILL_TREE_REGISTRY_KEY).getOrThrow(rk);
        this.canLockTree((Holder.Reference<SkillTree>)holder);
    }

    public boolean canLockTree(Holder.Reference<SkillTree> skillTree) {
        boolean anyUnlocked = false;
        for (TopDownTreeNode node : this.rootNodes.get(skillTree).values()) {
            anyUnlocked |= node.nodeState() == NodeState.UNLOCKED;
        }
        return !anyUnlocked;
    }

    public void lockTree(ResourceLocation id, boolean unequip) {
        ResourceKey rk = ResourceKey.create(SkillTree.SKILL_TREE_REGISTRY_KEY, (ResourceLocation)id);
        Holder.Reference holder = this.player.level().holderLookup(SkillTree.SKILL_TREE_REGISTRY_KEY).getOrThrow(rk);
        this.lockTree((Holder.Reference<SkillTree>)holder, unequip);
    }

    public void lockTree(Holder.Reference<SkillTree> skillTree, boolean unequip) {
        this.treeStates.put(skillTree, TreeState.LOCKED);
        this.rootNodes.get(skillTree).values().forEach(node -> this.lockNode(skillTree, node.nodeInfo.skill(), unequip));
        if (!this.player.level().isClientSide()) {
            EpicFightNetworkManager.sendToPlayer((CustomPacketPayload)new ClientBoundSetTreeState((ResourceKey<SkillTree>)skillTree.key(), TreeState.LOCKED, unequip), (ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean canUnlockNode(ResourceLocation id, Skill skill, AbilityPoints abilityPoints, boolean consume) {
        ResourceKey rk = ResourceKey.create(SkillTree.SKILL_TREE_REGISTRY_KEY, (ResourceLocation)id);
        Holder.Reference holder = this.player.level().holderLookup(SkillTree.SKILL_TREE_REGISTRY_KEY).getOrThrow(rk);
        return this.canUnlockNode((Holder.Reference<SkillTree>)holder, skill, abilityPoints, consume);
    }

    public boolean canUnlockNode(Holder.Reference<SkillTree> skillTree, Skill skill, AbilityPoints abilityPoints, boolean consume) {
        if (this.treeStates.get(skillTree) != TreeState.UNLOCKED) {
            return false;
        }
        Map<Skill, TopDownTreeNode> treeNodes = this.nodes.get(skillTree);
        if (treeNodes != null) {
            boolean hasEnoughAP;
            TopDownTreeNode treeNode = treeNodes.get(skill);
            if (treeNode.nodeState() != NodeState.UNLOCKABLE) {
                return treeNode.nodeState() == NodeState.UNLOCKED;
            }
            boolean bl = hasEnoughAP = abilityPoints.getAbilityPoints() >= treeNode.nodeInfo().requiredAbilityPoints();
            if (hasEnoughAP && consume) {
                abilityPoints.setAbilityPoints(abilityPoints.getAbilityPoints() - treeNode.nodeInfo().requiredAbilityPoints());
            }
            abilityPoints.markDirty();
            return hasEnoughAP;
        }
        return false;
    }

    public void unlockNode(ResourceLocation id, Skill skill) {
        ResourceKey rk = ResourceKey.create(SkillTree.SKILL_TREE_REGISTRY_KEY, (ResourceLocation)id);
        Holder.Reference holder = this.player.level().holderLookup(SkillTree.SKILL_TREE_REGISTRY_KEY).getOrThrow(rk);
        this.unlockNode((Holder.Reference<SkillTree>)holder, skill);
    }

    public void unlockNode(Holder.Reference<SkillTree> skillTree, Skill skill) {
        Map<Skill, TopDownTreeNode> nodes = this.nodes.get(skillTree);
        TopDownTreeNode node = nodes.get(skill);
        node.setNodeState(NodeState.UNLOCKED, true, false);
    }

    public boolean canLockNode(ResourceLocation id, Skill skill) {
        ResourceKey rk = ResourceKey.create(SkillTree.SKILL_TREE_REGISTRY_KEY, (ResourceLocation)id);
        Holder.Reference holder = this.player.level().holderLookup(SkillTree.SKILL_TREE_REGISTRY_KEY).getOrThrow(rk);
        return this.canLockNode((Holder.Reference<SkillTree>)holder, skill);
    }

    public boolean canLockNode(Holder.Reference<SkillTree> skillTree, Skill skill) {
        if (this.treeStates.get(skillTree) != TreeState.UNLOCKED) {
            return false;
        }
        Map<Skill, TopDownTreeNode> treeNodes = this.nodes.get(skillTree);
        if (treeNodes != null) {
            TopDownTreeNode treeNode = treeNodes.get(skill);
            if (treeNode.nodeState() == NodeState.LOCKED) {
                return false;
            }
            boolean childAllLocked = true;
            for (TopDownTreeNode childNode : treeNode.children) {
                childAllLocked &= childNode.nodeState() == NodeState.LOCKED || childNode.nodeState() == NodeState.UNLOCKABLE;
            }
            return childAllLocked;
        }
        return false;
    }

    public void lockNode(ResourceLocation id, Skill skill, boolean unequip) {
        ResourceKey rk = ResourceKey.create(SkillTree.SKILL_TREE_REGISTRY_KEY, (ResourceLocation)id);
        Holder.Reference holder = this.player.level().holderLookup(SkillTree.SKILL_TREE_REGISTRY_KEY).getOrThrow(rk);
        this.lockNode((Holder.Reference<SkillTree>)holder, skill, unequip);
    }

    public void lockNode(Holder.Reference<SkillTree> skillTree, Skill skill, boolean unequip) {
        Map<Skill, TopDownTreeNode> nodes = this.nodes.get(skillTree);
        TopDownTreeNode node = nodes.get(skill);
        node.setNodeState(NodeState.LOCKED, true, unequip);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processSyncPacket(ClientBoundSetTreeState packet) {
        Registry registry = this.registryAccess.registryOrThrow(SkillTree.SKILL_TREE_REGISTRY_KEY);
        Holder.Reference skillTree = registry.getHolderOrThrow(packet.skillTree());
        if (this.treeStates.get(skillTree) == TreeState.LOCKED && packet.treeState() == TreeState.UNLOCKED) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, (float)1.0f));
            Minecraft.getInstance().getToasts().addToast((Toast)new SkillTreeToast((Holder.Reference<SkillTree>)skillTree));
        } else if (this.treeStates.get(skillTree) == TreeState.UNLOCKED && packet.treeState() == TreeState.LOCKED) {
            this.rootNodes.get(skillTree).values().forEach(node -> this.lockNode((Holder.Reference<SkillTree>)skillTree, node.nodeInfo.skill(), packet.unequip()));
        }
        this.treeStates.put((Holder.Reference<SkillTree>)skillTree, packet.treeState());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processSyncPacket(ClientBoundUnlockNode packet) {
        Screen screen;
        Registry registry = this.registryAccess.registryOrThrow(SkillTree.SKILL_TREE_REGISTRY_KEY);
        Holder.Reference skillTree = registry.getHolderOrThrow(packet.skillTree());
        Map<Skill, TopDownTreeNode> nodes = this.nodes.get(skillTree);
        TopDownTreeNode node = nodes.get(packet.skill().value());
        node.setNodeState(packet.nodeState(), true, packet.unequip());
        if (packet.nodeState() == NodeState.UNLOCKED && packet.unlockAlarm()) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, (float)1.0f));
            Minecraft.getInstance().getToasts().addToast((Toast)new SkillTreeNodeToast(packet.skill()));
        }
        if ((screen = Minecraft.getInstance().screen) instanceof SkillInfoScreen) {
            SkillInfoScreen skillInfoScreen = (SkillInfoScreen)screen;
            skillInfoScreen.onSyncPacketArrived(packet);
        }
    }

    public TreeState getTreeState(Holder.Reference<SkillTree> skillTree) {
        return this.treeStates.get(skillTree);
    }

    public NodeState getNodeState(Holder.Reference<SkillTree> skillTree, Skill skill) {
        Map<Skill, TopDownTreeNode> treeNodes = this.nodes.get(skillTree);
        if (!treeNodes.containsKey(skill)) {
            throw new NoSuchElementException("The skill " + String.valueOf(skill) + " doesn't exist in the skill tree " + String.valueOf(skillTree.key().location()));
        }
        return treeNodes.get(skill).nodeState();
    }

    public Map<Skill, TopDownTreeNode> getNodes(Holder<SkillTree> skillTree) {
        return this.nodes.get(skillTree);
    }

    public static void addNodesRecursively(TopDownTreeNode topDownNode, ListTag listTag) {
        CompoundTag compound = new CompoundTag();
        compound.putString("name", topDownNode.nodeInfo().skill().getRegistryName().toString());
        compound.putString("state", ParseUtil.toLowerCase((String)topDownNode.nodeState().name()));
        ListTag children = new ListTag();
        topDownNode.children().forEach(childNode -> {
            if (topDownNode.belongedSkillTree.equals(childNode.belongedSkillTree)) {
                SkillTreeProgression.addNodesRecursively(childNode, children);
            }
        });
        if (!children.isEmpty()) {
            compound.put("children", (Tag)children);
        }
        listTag.add((Object)compound);
    }

    public void deserializeRecursively(Holder.Reference<SkillTree> skilltree, Skill skill, TopDownTreeNode node, CompoundTag nodeCompound, boolean root) {
        NodeState treeState;
        if (!node.nodeInfo().skill().equals(skill)) {
            return;
        }
        try {
            treeState = NodeState.valueOf(ParseUtil.toUpperCase((String)nodeCompound.getString("state")));
        }
        catch (IllegalArgumentException e) {
            return;
        }
        node.setNodeState(treeState, false, false);
        if (treeState == NodeState.LOCKED) {
            boolean parentAllUnlocked = true;
            if (!node.parents().isEmpty()) {
                for (TopDownTreeNode parentNode : node.parents()) {
                    parentAllUnlocked &= parentNode.nodeState() == NodeState.UNLOCKED;
                }
            }
            if (parentAllUnlocked && node.nodeInfo().unlockCondition() != null && !node.nodeInfo().hasCustomUnlockCondition()) {
                this.unlockAwaitingNodes.add((Pair<Holder.Reference<SkillTree>, TopDownTreeNode>)Pair.of(node.belongedSkillTree, (Object)node));
            }
        }
        ListTag children = nodeCompound.getList("children", 10);
        if (!node.children().isEmpty() && !children.isEmpty()) {
            node.children().forEach(childNode -> {
                for (Tag tag : children) {
                    CompoundTag childCompound = (CompoundTag)tag;
                    Skill childSkill = (Skill)EpicFightRegistries.SKILL.get(ResourceLocation.parse((String)childCompound.getString("name")));
                    if (!childNode.nodeInfo().skill().equals(childSkill)) continue;
                    this.deserializeRecursively(skilltree, childSkill, (TopDownTreeNode)childNode, childCompound, false);
                    break;
                }
            });
        }
    }

    public void serializeTo(CompoundTag compound) {
        for (Map.Entry<Holder.Reference<SkillTree>, TreeState> entry : this.treeStates.entrySet()) {
            CompoundTag treeCompound = new CompoundTag();
            treeCompound.putString("state", ParseUtil.toLowerCase((String)entry.getValue().name()));
            compound.put(entry.getKey().key().location().toString(), (Tag)treeCompound);
            Collection<TopDownTreeNode> rootNodes = this.rootNodes.get(entry.getKey()).values();
            ListTag children = new ListTag();
            rootNodes.forEach(rootNode -> SkillTreeProgression.addNodesRecursively(rootNode, children));
            treeCompound.put("nodes", (Tag)children);
        }
    }

    public void deserializeFrom(CompoundTag compound) {
        HolderLookup.RegistryLookup holderLookup = this.registryAccess.lookupOrThrow(SkillTree.SKILL_TREE_REGISTRY_KEY);
        for (String treeId : compound.getAllKeys()) {
            Holder.Reference skilltree = holderLookup.get(ResourceKey.create(SkillTree.SKILL_TREE_REGISTRY_KEY, (ResourceLocation)ResourceLocation.parse((String)treeId))).orElse(null);
            if (skilltree == null) {
                EpicSkills.LOGGER.warn("Unknown skill tree id " + treeId);
                continue;
            }
            CompoundTag treeCompound = compound.getCompound(treeId);
            if (treeCompound.contains("state", 8)) {
                try {
                    TreeState treeState = TreeState.valueOf(ParseUtil.toUpperCase((String)treeCompound.getString("state")));
                    this.treeStates.put((Holder.Reference<SkillTree>)skilltree, treeState);
                }
                catch (IllegalArgumentException treeState) {
                    // empty catch block
                }
            }
            if (!treeCompound.contains("nodes", 9)) continue;
            ListTag unlockedSkills = treeCompound.getList("nodes", 10);
            unlockedSkills.forEach(nodeTag -> {
                Map<Skill, TopDownTreeNode> treeRootNodes = this.rootNodes.get(skilltree);
                CompoundTag nodeCompound = (CompoundTag)nodeTag;
                Skill skill = (Skill)EpicFightRegistries.SKILL.get(ResourceLocation.parse((String)nodeCompound.getString("name")));
                if (skill == null) {
                    EpicSkills.LOGGER.warn("Skill tree deserialization failed: Unknown root skill id: " + nodeCompound.getString("name"));
                    return;
                }
                if (treeRootNodes.containsKey(skill)) {
                    this.deserializeRecursively((Holder.Reference<SkillTree>)skilltree, skill, treeRootNodes.get(skill), nodeCompound, true);
                }
            });
        }
    }

    private /* synthetic */ void lambda$reload$4(HolderLookup skillTreeRegistry, List importedNodes, Holder.Reference skillTreeEntryHolder) {
        Holder.Reference skillTree = skillTreeRegistry.get(ResourceKey.create(SkillTree.SKILL_TREE_REGISTRY_KEY, (ResourceLocation)skillTreeEntryHolder.key().location())).orElse(null);
        if (skillTree == null) {
            EpicSkills.LOGGER.warn("Unknown skill tree id: " + String.valueOf(skillTreeEntryHolder.key().location()));
            return;
        }
        if (((SkillTree)skillTree.value()).disabled()) {
            EpicSkills.LOGGER.info(String.valueOf(skillTreeEntryHolder.key().location()) + " is disabled.");
            return;
        }
        Map<Skill, TopDownTreeNode> nodesBySkill = this.nodes.get(skillTree);
        ((SkillTreeEntry)skillTreeEntryHolder.value()).nodes().forEach(treeNode -> {
            TopDownTreeNode node;
            if (!treeNode.skill().getCategory().learnable()) {
                EpicSkills.LOGGER.warn("Skill doesn't belong to a learnable skill category!" + String.valueOf(treeNode.skill()) + " in " + String.valueOf(skillTree.key().location()) + ". ignored.");
                return;
            }
            if (nodesBySkill.containsKey(treeNode.skill())) {
                EpicSkills.LOGGER.warn("Duplicated skill declaration! " + String.valueOf(treeNode.skill()) + " in " + String.valueOf(skillTree.key().location()) + ". ignored.");
                return;
            }
            if (treeNode.importFrom() != null) {
                ImportedNode importedNode = new ImportedNode((Holder.Reference<SkillTree>)skillTree, (SkillTreeEntry.Node)treeNode);
                importedNodes.add(importedNode);
                node = importedNode;
            } else {
                node = new CommonTreeNode((Holder.Reference<SkillTree>)skillTree, (SkillTreeEntry.Node)treeNode);
            }
            if (treeNode.parents() != null) {
                treeNode.parents().forEach(parentLink -> {
                    if (nodesBySkill.containsKey(parentLink.parentSkill())) {
                        TopDownTreeNode parentNode = (TopDownTreeNode)nodesBySkill.get(parentLink.parentSkill());
                        parentNode.children().add(node);
                        node.parents().add(parentNode);
                    } else {
                        EpicSkills.LOGGER.warn("Can't find parent skill " + String.valueOf(parentLink.parentSkill()) + " in " + String.valueOf(skillTree.key().location()) + ". ignored.");
                    }
                });
            } else {
                if (node.nodeInfo.noUnlockConditions()) {
                    node.setNodeState(NodeState.UNLOCKABLE, false, false);
                }
                this.rootNodes.get(skillTree).put(treeNode.skill(), node);
            }
            nodesBySkill.put(treeNode.skill(), node);
        });
    }

    public static enum TreeState {
        LOCKED,
        UNLOCKED;

    }

    public abstract class TopDownTreeNode {
        protected final Holder.Reference<SkillTree> belongedSkillTree;
        protected final List<TopDownTreeNode> parent = new ArrayList<TopDownTreeNode>();
        protected final List<TopDownTreeNode> children = new ArrayList<TopDownTreeNode>();
        protected final SkillTreeEntry.Node nodeInfo;

        public TopDownTreeNode(SkillTreeProgression this$0, Holder.Reference<SkillTree> belongedSkillTree, SkillTreeEntry.Node nodeInfo) {
            this.belongedSkillTree = belongedSkillTree;
            this.nodeInfo = nodeInfo;
        }

        public List<TopDownTreeNode> parents() {
            return this.parent;
        }

        public List<TopDownTreeNode> children() {
            return this.children;
        }

        public SkillTreeEntry.Node nodeInfo() {
            return this.nodeInfo;
        }

        public abstract boolean isImported();

        public abstract NodeState nodeState();

        public abstract void setNodeState(NodeState var1, boolean var2, boolean var3);
    }

    public static enum NodeState {
        LOCKED((Component)Component.translatable((String)"gui.epicskills.skillinfo.locked")),
        UNLOCKABLE((Component)Component.translatable((String)"gui.epicskills.skillinfo.unlock")),
        UNLOCKED((Component)Component.translatable((String)"gui.epicskills.skillinfo.equip"));

        Component displayOnButton;

        private NodeState(Component displayOnButton) {
            this.displayOnButton = displayOnButton;
        }

        public Component displayedOnButton() {
            return this.displayOnButton;
        }
    }

    public class ImportedNode
    extends TopDownTreeNode {
        private final Holder.Reference<SkillTree> importedFrom;

        public ImportedNode(Holder.Reference<SkillTree> belongedSkillTree, SkillTreeEntry.Node nodeInfo) {
            super(SkillTreeProgression.this, belongedSkillTree, nodeInfo);
            this.importedFrom = SkillTreeProgression.this.registryAccess.lookupOrThrow(SkillTree.SKILL_TREE_REGISTRY_KEY).getOrThrow(ResourceKey.create(SkillTree.SKILL_TREE_REGISTRY_KEY, (ResourceLocation)nodeInfo.importFrom()));
        }

        @Override
        public boolean isImported() {
            return true;
        }

        public Holder.Reference<SkillTree> getImportedTree() {
            return this.importedFrom;
        }

        @Override
        public NodeState nodeState() {
            return SkillTreeProgression.this.getNodeState(this.importedFrom, this.nodeInfo().skill());
        }

        @Override
        public void setNodeState(NodeState nodeState, boolean propagateChildState, boolean modifyEquip) {
        }
    }

    public class CommonTreeNode
    extends TopDownTreeNode {
        private NodeState nodeState;

        public CommonTreeNode(Holder.Reference<SkillTree> belongedSkillTree, SkillTreeEntry.Node nodeInfo) {
            super(SkillTreeProgression.this, belongedSkillTree, nodeInfo);
            this.nodeState = NodeState.LOCKED;
        }

        @Override
        public boolean isImported() {
            return false;
        }

        @Override
        public void setNodeState(NodeState nodeState, boolean propagateState, boolean modifyEquip) {
            if (nodeState == this.nodeState) {
                return;
            }
            if (propagateState && nodeState == NodeState.UNLOCKED) {
                this.parents().forEach(parentNode -> {
                    if (parentNode.nodeState() == NodeState.UNLOCKABLE || parentNode.nodeState() == NodeState.LOCKED) {
                        parentNode.setNodeState(NodeState.UNLOCKED, true, modifyEquip);
                    }
                });
            }
            if (nodeState == NodeState.LOCKED) {
                boolean parentAllUnlocked = true;
                if (!this.parents().isEmpty()) {
                    for (TopDownTreeNode parentNode2 : this.parents()) {
                        parentAllUnlocked &= parentNode2.nodeState() == NodeState.UNLOCKED;
                    }
                }
                if (parentAllUnlocked) {
                    if (this.nodeInfo().noUnlockConditions()) {
                        this.nodeState = NodeState.UNLOCKABLE;
                    } else {
                        this.nodeState = NodeState.LOCKED;
                        SkillTreeProgression.this.unlockAwaitingNodes.add((Pair<Holder.Reference<SkillTree>, TopDownTreeNode>)Pair.of((Object)this.belongedSkillTree, (Object)this));
                    }
                } else {
                    this.nodeState = NodeState.LOCKED;
                }
                if (modifyEquip) {
                    EpicFightCapabilities.getParameterizedEntityPatch((Entity)SkillTreeProgression.this.player, Player.class, PlayerPatch.class).ifPresent(playerptach -> playerptach.getSkillContainerFor(this.nodeInfo().skill()).ifPresent(container -> container.setSkill(null)));
                }
            } else {
                this.nodeState = nodeState;
            }
            if (propagateState) {
                switch (nodeState.ordinal()) {
                    case 0: {
                        this.children().forEach(childNode -> {
                            boolean parentAllUnlocked = true;
                            if (!childNode.parents().isEmpty()) {
                                for (TopDownTreeNode parentNode : childNode.parents()) {
                                    parentAllUnlocked &= parentNode.nodeState() == NodeState.UNLOCKED;
                                }
                            }
                            if (parentAllUnlocked) {
                                if (childNode.nodeInfo().noUnlockConditions()) {
                                    childNode.setNodeState(NodeState.UNLOCKABLE, true, modifyEquip);
                                } else {
                                    childNode.setNodeState(NodeState.LOCKED, true, modifyEquip);
                                    SkillTreeProgression.this.unlockAwaitingNodes.add((Pair<Holder.Reference<SkillTree>, TopDownTreeNode>)Pair.of(childNode.belongedSkillTree, (Object)childNode));
                                }
                            } else {
                                childNode.setNodeState(NodeState.LOCKED, true, modifyEquip);
                            }
                        });
                        break;
                    }
                    case 2: {
                        this.children().forEach(childNode -> {
                            boolean parentAllUnlocked = true;
                            if (!childNode.parents().isEmpty()) {
                                for (TopDownTreeNode parentNode : childNode.parents()) {
                                    parentAllUnlocked &= parentNode.nodeState() == NodeState.UNLOCKED;
                                }
                            }
                            if (parentAllUnlocked) {
                                if (childNode.nodeInfo.noUnlockConditions()) {
                                    childNode.setNodeState(NodeState.UNLOCKABLE, true, modifyEquip);
                                } else if (!childNode.nodeInfo.hasCustomUnlockCondition()) {
                                    SkillTreeProgression.this.unlockAwaitingNodes.add((Pair<Holder.Reference<SkillTree>, TopDownTreeNode>)Pair.of(childNode.belongedSkillTree, (Object)childNode));
                                }
                            }
                        });
                        break;
                    }
                    case 1: {
                        this.parents().forEach(parentNode -> {
                            if (parentNode.nodeState() != NodeState.UNLOCKED) {
                                parentNode.setNodeState(NodeState.UNLOCKED, true, modifyEquip);
                            }
                        });
                        this.children().forEach(childNode -> {
                            if (childNode.nodeState() != NodeState.LOCKED) {
                                childNode.setNodeState(NodeState.LOCKED, true, modifyEquip);
                            }
                        });
                    }
                }
            }
        }

        @Override
        public NodeState nodeState() {
            return this.nodeState;
        }
    }
}

