/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.network.server;

import com.yesman.epicskills.EpicSkills;
import com.yesman.epicskills.network.NetworkManager;
import com.yesman.epicskills.network.client.ClientBoundUnlockNode;
import com.yesman.epicskills.skilltree.SkillTree;
import com.yesman.epicskills.world.capability.AbilityPoints;
import com.yesman.epicskills.world.capability.SkillTreeProgression;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.mutable.MutableBoolean;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public record ServerBoundUnlockSkillRequest(ResourceKey<SkillTree> skilltree, Skill skill) {
    public static ServerBoundUnlockSkillRequest fromBytes(FriendlyByteBuf buf) {
        return new ServerBoundUnlockSkillRequest((ResourceKey<SkillTree>)buf.m_236801_(SkillTree.SKILL_TREE_REGISTRY_KEY), (Skill)buf.readRegistryId());
    }

    public static void toBytes(ServerBoundUnlockSkillRequest msg, FriendlyByteBuf buf) {
        buf.m_236858_(msg.skilltree());
        buf.writeRegistryId((IForgeRegistry)RegistryManager.ACTIVE.getRegistry(SkillManager.SKILL_REGISTRY_KEY), (Object)msg.skill());
    }

    public static void handle(ServerBoundUnlockSkillRequest msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            SkillTreeProgression skillTreeProgression = (SkillTreeProgression)player.getCapability(SkillTreeProgression.SKILL_TREE_PROGRESSION).orElseThrow(() -> new IllegalStateException("No skill tree progression"));
            AbilityPoints abilityPoints = (AbilityPoints)player.getCapability(AbilityPoints.ABILITY_POINTS).orElseThrow(() -> new IllegalStateException("No skill tree progression"));
            player.m_9236_().m_246945_(SkillTree.SKILL_TREE_REGISTRY_KEY).m_254902_(msg.skilltree()).ifPresentOrElse(skillTree -> {
                if (skillTreeProgression.canUnlockNode((Holder.Reference<SkillTree>)skillTree, msg.skill(), abilityPoints, true)) {
                    skillTreeProgression.unlockNode((Holder.Reference<SkillTree>)skillTree, msg.skill());
                    MutableBoolean askSkillChangeLater = new MutableBoolean(false);
                    EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)player, ServerPlayerPatch.class).ifPresent(playerpatch -> {
                        if (!playerpatch.getSkillCapability().isEquipping(msg.skill())) {
                            SkillContainer container = playerpatch.getSkillCapability().getFirstEmptyContainer(msg.skill().getCategory());
                            if (container != null) {
                                if (container.setSkill(msg.skill())) {
                                    EpicFightNetworkManager.sendToPlayer((Object)container.createSyncPacketToLocalPlayer(), (ServerPlayer)player, (Object[])new Object[0]);
                                    EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity((Object)container.createSyncPacketToRemotePlayer(), (Entity)player, (Object[])new Object[0]);
                                }
                            } else {
                                askSkillChangeLater.setTrue();
                            }
                        }
                    });
                    NetworkManager.sendToPlayer(new ClientBoundUnlockNode(msg.skilltree(), msg.skill(), SkillTreeProgression.NodeState.UNLOCKED, false, false, askSkillChangeLater.booleanValue(), true), player);
                }
                abilityPoints.sendChanges();
            }, () -> EpicSkills.LOGGER.error("No skill tree: " + SkillTree.SKILL_TREE_REGISTRY_KEY));
        });
        ctx.get().setPacketHandled(true);
    }
}

