/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.yesman.epicskills.client.gui.screen.CategorySlotTexture;
import com.yesman.epicskills.client.gui.screen.SkillTreeScreen;
import com.yesman.epicskills.registry.entry.EpicSkillsAttachmentTypes;
import com.yesman.epicskills.registry.entry.EpicSkillsGlobalLootModifer;
import com.yesman.epicskills.registry.entry.EpicSkillsItems;
import com.yesman.epicskills.registry.entry.EpicSkillsSounds;
import com.yesman.epicskills.server.commands.PlayerAbilityPointsCommand;
import com.yesman.epicskills.server.commands.PlayerSkillTreeCommand;
import com.yesman.epicskills.skilltree.SkillTree;
import com.yesman.epicskills.skilltree.SkillTreeEntry;
import com.yesman.epicskills.world.item.AbilityStoneItem;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.registry.entries.EpicFightCreativeTabs;

@Mod(value="epicskills")
public class EpicSkills {
    public static final String MODID = "epicskills";
    public static final Logger LOGGER = LogUtils.getLogger();

    public static String prefix(String s) {
        return String.format("%s:%s", MODID, s);
    }

    public static String format(String s) {
        return String.format(s, MODID);
    }

    public EpicSkills(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::epicskills$newDataPackRegistryEvent);
        modEventBus.addListener(this::epicskills$buildCreativeTabContents);
        EpicSkillsSounds.REGISTRY.register(modEventBus);
        EpicSkillsItems.REGISTRY.register(modEventBus);
        EpicSkillsAttachmentTypes.REGISTRY.register(modEventBus);
        EpicSkillsGlobalLootModifer.GLOBAL_LOOT_LOOT_MODIFIERS.register(modEventBus);
        NeoForge.EVENT_BUS.addListener(this::epicskills$registerCommands);
        if (EpicFightSharedConstants.isPhysicalClient()) {
            CategorySlotTexture.ENUM_MANAGER.registerEnumCls(MODID, SkillTreeScreen.TreePage.NodeButton.CategorySlotTextures.class);
        }
    }

    public void epicskills$newDataPackRegistryEvent(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(SkillTree.SKILL_TREE_REGISTRY_KEY, SkillTree.CODEC, SkillTree.CODEC);
        event.dataPackRegistry(SkillTreeEntry.SKILL_TREE_ENTRY_REGISTRY_KEY, SkillTreeEntry.CODEC, SkillTreeEntry.CODEC);
    }

    private void epicskills$registerCommands(RegisterCommandsEvent event) {
        PlayerAbilityPointsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        PlayerSkillTreeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    private void epicskills$buildCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == EpicFightCreativeTabs.ITEMS.get()) {
            event.accept(((AbilityStoneItem)((Object)EpicSkillsItems.ABILIITY_STONE.get())).getDefaultInstance());
        }
    }

    @NotNull
    public static ResourceLocation rl(@NotNull String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    @EventBusSubscriber(modid="epicskills", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void epicskills$fmlClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> CategorySlotTexture.ENUM_MANAGER.loadEnum());
        }
    }
}

