/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.client.gui.screen;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.yesman.epicskills.EpicSkills;
import com.yesman.epicskills.client.gui.screen.BackgroundRenderableScreen;
import com.yesman.epicskills.client.gui.screen.CategorySlotTexture;
import com.yesman.epicskills.client.gui.screen.SkillInfoScreen;
import com.yesman.epicskills.client.gui.widget.HoverSoundPlayer;
import com.yesman.epicskills.neoforge.attachment.AbilityPoints;
import com.yesman.epicskills.neoforge.attachment.SkillTreeProgression;
import com.yesman.epicskills.network.client.ClientBoundSetAbilityPoints;
import com.yesman.epicskills.network.server.ServerBoundConvertAbilityPointRequest;
import com.yesman.epicskills.registry.entry.EpicSkillsAttachmentTypes;
import com.yesman.epicskills.registry.entry.EpicSkillsSounds;
import com.yesman.epicskills.skilltree.SkillTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.api.utils.ExtensibleEnum;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.gui.screen.SkillEditScreen;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.registry.entries.EpicFightItems;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.skill.PlayerSkills;
import yesman.epicfight.world.item.SkillBookItem;

@OnlyIn(value=Dist.CLIENT)
public class SkillTreeScreen
extends Screen
implements BackgroundRenderableScreen {
    public static final Function<Holder.Reference<SkillTree>, ResourceLocation> SKILL_TREE_BACKGROUND_TEXTURES = Util.memoize(skillTree -> ResourceLocation.fromNamespaceAndPath((String)skillTree.key().location().getNamespace(), (String)String.format("textures/gui/skill_tree/background/%s.png", skillTree.key().location().getPath())));
    public static final Function<Holder.Reference<SkillTree>, ResourceLocation> SKILL_TREE_ICON_TEXTURES = Util.memoize(skillTree -> ResourceLocation.fromNamespaceAndPath((String)skillTree.key().location().getNamespace(), (String)String.format("textures/gui/skill_tree/icon/%s.png", skillTree.key().location().getPath())));
    private final Player player;
    private final PlayerSkills playerSkills;
    private final AbilityPoints playerAbilityPoints;
    private final SkillTreeProgression playerSkillTreeProgression;
    private final Map<Holder.Reference<SkillTree>, Integer> skillTreeIndices = new HashMap<Holder.Reference<SkillTree>, Integer>();
    private final Map<Integer, TreePage> skillTreePages = new HashMap<Integer, TreePage>();
    private final Map<Integer, TreeSelectButton> skillTreeButtons = new HashMap<Integer, TreeSelectButton>();
    private final ExpToAbilityPointConverstionButton expConversionButton;
    private final Button scaleUpButton;
    private final Button scaleDownButton;
    private TreePage currentPage;
    private LayoutElement hoveringWidget;
    private boolean backgroundMode;
    private boolean synclock;
    private boolean discarded = false;
    private boolean disableMouseDragging = false;
    private int nodeScale = -1;

    public SkillTreeScreen(LocalPlayerPatch playerpatch) {
        super((Component)Component.translatable((String)"gui.epicskills.skill_tree"));
        this.player = (Player)playerpatch.getOriginal();
        this.playerSkills = playerpatch.getPlayerSkills();
        this.playerAbilityPoints = (AbilityPoints)((LocalPlayer)playerpatch.getOriginal()).getExistingData(EpicSkillsAttachmentTypes.ABILITY_POINTS).orElseThrow(() -> new NoSuchElementException("Player doesn't have ability point capability"));
        this.playerSkillTreeProgression = (SkillTreeProgression)((LocalPlayer)playerpatch.getOriginal()).getExistingData(EpicSkillsAttachmentTypes.SKILL_TREE_PROGRESSION).orElseThrow(() -> new NoSuchElementException("Player doesn't have skill tree capability"));
        HolderLookup skillTreeLookup = this.player.level().holderLookup(SkillTree.SKILL_TREE_REGISTRY_KEY);
        MutableInt index = new MutableInt(0);
        skillTreeLookup.listElements().sorted((page1, page2) -> {
            if (((SkillTree)page1.value()).priority() == ((SkillTree)page2.value()).priority()) {
                return page1.getRegisteredName().compareTo(page2.getRegisteredName());
            }
            return Integer.compare(((SkillTree)page1.value()).priority(), ((SkillTree)page2.value()).priority());
        }).forEach(skillTree -> {
            if (((SkillTree)skillTree.value()).disabled()) {
                return;
            }
            SkillTreeProgression.TreeState treeState = this.playerSkillTreeProgression.getTreeState((Holder.Reference<SkillTree>)skillTree);
            if (treeState != SkillTreeProgression.TreeState.LOCKED || !((SkillTree)skillTree.value()).hiddenWhenLocked()) {
                this.skillTreePages.put(index.intValue(), new TreePage(this.playerSkillTreeProgression.getNodes((Holder<SkillTree>)skillTree), (Holder.Reference<SkillTree>)skillTree));
                this.skillTreeIndices.put((Holder.Reference<SkillTree>)skillTree, index.intValue());
                TreeSelectButton skillTreeButton = new TreeSelectButton(index.intValue(), (Holder.Reference<SkillTree>)skillTree);
                skillTreeButton.active = treeState != SkillTreeProgression.TreeState.LOCKED;
                MutableComponent tooltip = Component.translatable((String)SkillTree.toDescriptionId((ResourceKey<SkillTree>)skillTree.key()));
                if (treeState == SkillTreeProgression.TreeState.LOCKED && ((SkillTree)skillTree.value()).unlockTip() != null) {
                    tooltip.append((Component)Component.literal((String)"\n")).append(((SkillTree)skillTree.value()).unlockTip());
                }
                skillTreeButton.setTooltip(Tooltip.create((Component)tooltip));
                this.skillTreeButtons.put(index.intValue(), skillTreeButton);
            }
            index.add(1);
        });
        this.expConversionButton = new ExpToAbilityPointConverstionButton(0, 0, 16, 16);
        this.expConversionButton.active = this.playerAbilityPoints.hasEnoughExp();
        this.scaleUpButton = Button.builder((Component)Component.literal((String)"+"), button -> this.scaleUp()).size(12, 12).build();
        this.scaleDownButton = Button.builder((Component)Component.literal((String)"-"), button -> this.scaleDown()).size(12, 12).build();
        this.font = Minecraft.getInstance().font;
        if (this.skillTreePages.isEmpty()) {
            Minecraft.getInstance().gui.getChat().addMessage((Component)Component.translatable((String)"chat.epicskills.messages.no_page"));
            this.discarded = true;
        } else {
            this.setTreeIndex(0);
        }
    }

    public void init() {
        MutableInt posY = new MutableInt(10);
        this.backgroundMode = false;
        this.skillTreeButtons.values().forEach(button -> {
            button.setY(posY.intValue());
            this.addRenderableWidget((GuiEventListener)button);
            posY.add(36);
        });
        this.expConversionButton.setPosition(this.width - (this.expConversionButton.getWidth() + 90), 9);
        this.addRenderableWidget((GuiEventListener)this.expConversionButton);
        this.addRenderableWidget((GuiEventListener)this.scaleUpButton);
        this.addRenderableWidget((GuiEventListener)this.scaleDownButton);
        this.addRenderableWidget((GuiEventListener)new OpenSkillEditorButton(this.width - 30, 8, 20, 20));
        this.addRenderableOnly((Renderable)new ExperienceMeter(this.width - (this.expConversionButton.getWidth() + 70), 14));
        this.addRenderableOnly((Renderable)new AbilityPointsMeter(this.width - (this.expConversionButton.getWidth() + 150), 10));
    }

    public void relocateScaleButtons() {
        int titleWidth = this.font.width((FormattedText)this.currentPage.title);
        this.scaleUpButton.setPosition(53 + titleWidth, 16);
        this.scaleDownButton.setPosition(66 + titleWidth, 16);
    }

    public void tick() {
        this.expConversionButton.tick();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation background = SKILL_TREE_BACKGROUND_TEXTURES.apply(this.currentPage.skillTree);
        Vec3i menuBarColor = ((SkillTree)this.currentPage.skillTree.value()).menuBarColor();
        guiGraphics.innerBlit(background, 0, this.width, 0, this.height, -1, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.fill(0, 0, 39, this.height, FastColor.ARGB32.color((int)200, (int)menuBarColor.getX(), (int)menuBarColor.getY(), (int)menuBarColor.getZ()));
        guiGraphics.drawString(this.font, this.currentPage.getTitle(), 46, 18, -1);
        guiGraphics.fill(44, 32, this.width - 10, 34, FastColor.ARGB32.color((int)200, (int)menuBarColor.getX(), (int)menuBarColor.getY(), (int)menuBarColor.getZ()));
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (!this.isBackgroundMode()) {
            boolean hasAny = false;
            for (GuiEventListener child : this.children()) {
                HoverSoundPlayer hoverSoundPlayer;
                SoundEvent event;
                LayoutElement layoutElement;
                if (!(child instanceof LayoutElement) || (layoutElement = (LayoutElement)child).getX() >= mouseX || mouseX >= layoutElement.getX() + layoutElement.getWidth() || layoutElement.getY() >= mouseY || mouseY >= layoutElement.getY() + layoutElement.getHeight()) continue;
                hasAny = true;
                if (this.hoveringWidget == layoutElement) continue;
                this.hoveringWidget = layoutElement;
                LayoutElement layoutElement2 = this.hoveringWidget;
                if (!(layoutElement2 instanceof HoverSoundPlayer) || (event = (hoverSoundPlayer = (HoverSoundPlayer)layoutElement2).getHoverSound()) == null) break;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)hoverSoundPlayer.getHoverSound(), (float)1.0f));
                break;
            }
            if (!hasAny) {
                this.hoveringWidget = null;
            }
        }
        this.currentPage.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        float correctScale = this.nodeScale != -1 ? (float)this.nodeScale / (float)this.minecraft.getWindow().getGuiScale() : 1.0f;
        int correctedMouseX = (int)((mouseX - (double)this.currentPage.pageLeft) / (double)correctScale);
        int correctedMouseY = (int)((mouseY - (double)this.currentPage.pageTop) / (double)correctScale);
        for (TreePage.NodeButton nodeButton : this.currentPage.treeNodes.values()) {
            if (!nodeButton.mouseClicked(correctedMouseX, correctedMouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDisableMouseDragging()) {
            return false;
        }
        if (!super.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            this.moveViewport((float)dragX, (float)dragY);
            return false;
        }
        return true;
    }

    public void moveViewport(float deltaX, float deltaY) {
        this.currentPage.pageLeft += deltaX;
        this.currentPage.pageTop += deltaY;
    }

    public boolean mouseScrolled(double x, double y, double xDelta, double yDelta) {
        if (!super.mouseScrolled(x, y, xDelta, yDelta)) {
            if (yDelta > 0.0) {
                this.scaleUp();
            } else {
                this.scaleDown();
            }
            return false;
        }
        return true;
    }

    private void setTreeIndex(int index) {
        this.currentPage = this.skillTreePages.get(index);
        this.relocateScaleButtons();
    }

    public boolean navigateTreePage(boolean isNextPage) {
        boolean canNavigate;
        int currentPageIndex = this.skillTreePages.entrySet().stream().filter(entry -> entry.getValue() == this.currentPage).map(Map.Entry::getKey).findFirst().orElse(-1);
        if (currentPageIndex == -1) {
            return false;
        }
        int newIndex = isNextPage ? currentPageIndex + 1 : currentPageIndex - 1;
        boolean bl = canNavigate = this.skillTreePages.containsKey(newIndex) && this.skillTreeButtons.get(newIndex).isActive();
        if (!canNavigate) {
            return false;
        }
        this.setTreeIndex(newIndex);
        this.skillTreeButtons.forEach((index, button) -> button.setFocused(index == newIndex));
        return true;
    }

    public void scaleUp() {
        int maxScale;
        int nextScale = Math.min(6, (this.nodeScale == -1 ? (int)this.minecraft.getWindow().getGuiScale() : this.nodeScale) + 1);
        if (nextScale <= (maxScale = this.minecraft.getWindow().calculateScale(0x7FFFFFFE, ((Boolean)this.minecraft.options.forceUnicodeFont().get()).booleanValue()))) {
            this.nodeScale = nextScale;
        }
    }

    public void scaleDown() {
        this.nodeScale = Math.max(1, (this.nodeScale == -1 ? (int)this.minecraft.getWindow().getGuiScale() : this.nodeScale) - 1);
    }

    @Override
    public boolean isBackgroundMode() {
        return this.backgroundMode;
    }

    @Override
    public void setBackgroundMode(boolean flag) {
        this.backgroundMode = flag;
    }

    public void setFocus(Skill skill) {
        TreePage.NodeButton nodeButton = this.currentPage.treeNodes.get(skill);
        if (nodeButton != null) {
            Vec2i pos = nodeButton.treeNode.nodeInfo().positionInScreen();
            this.currentPage.pageLeft = -pos.x + this.width / 2;
            this.currentPage.pageTop = -pos.y + this.height / 2;
        }
    }

    public void onSyncPacketArrived(ClientBoundSetAbilityPoints feedbackPacket) {
        if (feedbackPacket.success()) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)EpicSkillsSounds.GAIN_ABILITY_POINTS.get()), (float)1.0f, (float)1.0f));
            this.synclock = false;
        }
    }

    public boolean discarded() {
        return this.discarded;
    }

    public ExpToAbilityPointConverstionButton getExpConversionButton() {
        return this.expConversionButton;
    }

    public boolean isDisableMouseDragging() {
        return this.disableMouseDragging;
    }

    public void setDisableMouseDragging(boolean disableMouseDragging) {
        this.disableMouseDragging = disableMouseDragging;
    }

    public static void playSkillTreeDownSound(@NotNull SoundManager manager) {
        manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)EpicSkillsSounds.HOVER.get()), (float)1.0f, (float)1.0f));
    }

    public void openSkillEditorScreen() {
        Objects.requireNonNull(this.minecraft).setScreen((Screen)new SkillEditScreen(this.player, this.playerSkills));
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ExpToAbilityPointConverstionButton
    extends AbstractButton {
        private static final ResourceLocation EXPERIENCE_ORB_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/experience_orb.png");
        private static final int MAX_HOVER_TICK = 6;
        private int hoverTickO;
        private int hoverTick;

        public ExpToAbilityPointConverstionButton(int pX, int pY, int pWidth, int pHeight) {
            super(pX, pY, pWidth, pHeight, (Component)Component.empty());
        }

        public void tick() {
            this.active = this.canConvert();
            this.hoverTickO = this.hoverTick;
            this.hoverTick = this.isHovered() && this.active ? Math.min(6, this.hoverTick + 1) : Math.max(0, this.hoverTick - 1);
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            float delta = Mth.lerp((float)partialTick, (float)((float)this.hoverTickO / 6.0f), (float)((float)this.hoverTick / 6.0f));
            guiGraphics.innerBlit(EXPERIENCE_ORB_LOCATION, this.getX(), this.getX() + this.getWidth(), this.getY(), this.getY() + this.getHeight(), 0, 0.0f, 0.25f, 0.25f, 0.5f, 0.32f, 1.0f, 0.18f, 1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.innerBlit(EXPERIENCE_ORB_LOCATION, this.getX(), this.getX() + this.getWidth(), this.getY(), this.getY() + this.getHeight(), 0, 0.0f, 0.25f, 0.5f, 0.75f, 0.67f, 1.0f, 0.0f, delta);
            RenderSystem.disableBlend();
        }

        public void onPress() {
            this.convert();
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }

        public void playDownSound(SoundManager handler) {
        }

        private boolean canConvert() {
            return SkillTreeScreen.this.player.totalExperience >= SkillTreeScreen.this.playerAbilityPoints.getRequiredExp();
        }

        public void convert() {
            if (!this.isActive()) {
                return;
            }
            if (!SkillTreeScreen.this.synclock) {
                EpicFightNetworkManager.sendToServer((CustomPacketPayload)new ServerBoundConvertAbilityPointRequest(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                SkillTreeScreen.this.synclock = true;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class OpenSkillEditorButton
    extends AbstractButton {
        public OpenSkillEditorButton(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.empty());
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)EpicSkills.format("gui.%s.openskilleditor.tooltip"))));
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
            guiGraphics.renderItem(((SkillBookItem)EpicFightItems.SKILLBOOK.get()).getDefaultInstance(), this.getX() + 2, this.getY() + 2);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }

        public void onPress() {
            SkillTreeScreen.this.openSkillEditorScreen();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ExperienceMeter
    extends AbstractWidget {
        private static final Component EXP_METER_TOOLTIP = Component.translatable((String)"gui.epicskills.exp_meter.tooltip");

        public ExperienceMeter(int x, int y) {
            super(x, y, 0, 9, (Component)Component.empty());
            this.setTooltip(Tooltip.create((Component)EXP_METER_TOOLTIP));
        }

        protected void renderWidget(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float pPartialTick) {
            String expState = String.format("%d / %d", SkillTreeScreen.this.player.totalExperience, SkillTreeScreen.this.playerAbilityPoints.getRequiredExp());
            this.width = SkillTreeScreen.this.font.width(expState);
            pGuiGraphics.drawString(SkillTreeScreen.this.font, expState, this.getX(), this.getY(), -1);
        }

        protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
            this.defaultButtonNarrationText(pNarrationElementOutput);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class AbilityPointsMeter
    extends AbstractWidget {
        private static final ResourceLocation ABILITY_POINTS_ICON = ResourceLocation.fromNamespaceAndPath((String)"epicskills", (String)"textures/gui/widget/ability_points.png");
        private static final Component ABILITY_POINTS_TOOLTIP = Component.translatable((String)"gui.epicskills.abilitypoints.tooltip");

        public AbilityPointsMeter(int x, int y) {
            super(x, y, 0, 14, (Component)Component.empty());
            this.setTooltip(Tooltip.create((Component)ABILITY_POINTS_TOOLTIP));
        }

        protected void renderWidget(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float pPartialTick) {
            pGuiGraphics.blit(ABILITY_POINTS_ICON, this.getX(), this.getY(), 0, 0.0f, 0.0f, 16, 16, 16, 16);
            String abilityPoints = String.valueOf(SkillTreeScreen.this.playerAbilityPoints.getAbilityPoints());
            this.width = SkillTreeScreen.this.font.width(abilityPoints) + 24;
            pGuiGraphics.drawString(SkillTreeScreen.this.font, abilityPoints, this.getX() + 24, this.getY() + 4, -1);
        }

        protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
            this.defaultButtonNarrationText(pNarrationElementOutput);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class TreePage {
        private float pageLeft;
        private float pageTop;
        private final Map<Skill, NodeButton> treeNodes;
        private final Holder.Reference<SkillTree> skillTree;
        private final Component title;

        public TreePage(Map<Skill, SkillTreeProgression.TopDownTreeNode> nodesProgression, Holder.Reference<SkillTree> skillTree) {
            this.skillTree = skillTree;
            this.pageLeft = 44.0f;
            this.pageTop = 34.0f;
            this.title = Component.translatable((String)String.format("skill_tree.%s.%s", skillTree.key().location().getNamespace(), skillTree.key().location().getPath()));
            this.treeNodes = new LinkedHashMap<Skill, NodeButton>();
            nodesProgression.forEach((skill, topDownTreeNode) -> {
                NodeButton skillTreeNodeButton = new NodeButton((SkillTreeProgression.TopDownTreeNode)topDownTreeNode);
                this.treeNodes.put(topDownTreeNode.nodeInfo().skill(), skillTreeNodeButton);
                if (topDownTreeNode.nodeInfo().parents() != null) {
                    topDownTreeNode.nodeInfo().parents().forEach(parent -> {
                        if (this.treeNodes.containsKey(parent.parentSkill())) {
                            skillTreeNodeButton.parents.add((Pair<NodeButton, List<Vec2i>>)Pair.of((Object)((Object)this.treeNodes.get(parent.parentSkill())), parent.controlPoints()));
                        } else {
                            EpicFightMod.logAndStacktraceIfDevSide(Logger::error, (String)String.format("Can't add skill %s to skill tree: Can't find parent skill %s", topDownTreeNode.nodeInfo().skill(), parent.parentSkill()), IllegalArgumentException::new);
                        }
                    });
                }
            });
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            float correctScale;
            guiGraphics.pose().pushPose();
            guiGraphics.enableScissor(44, 34, SkillTreeScreen.this.width, SkillTreeScreen.this.height);
            guiGraphics.pose().translate(this.pageLeft, this.pageTop, 0.0f);
            float f = correctScale = SkillTreeScreen.this.nodeScale != -1 ? (float)SkillTreeScreen.this.nodeScale / (float)SkillTreeScreen.this.minecraft.getWindow().getGuiScale() : 1.0f;
            if (SkillTreeScreen.this.nodeScale != -1) {
                guiGraphics.pose().scale(correctScale, correctScale, 1.0f);
            }
            RenderSystem.enableDepthTest();
            int correctedMouseX = (int)(((float)mouseX - this.pageLeft) / correctScale);
            int correctedMouseY = (int)(((float)mouseY - this.pageTop) / correctScale);
            for (NodeButton nodeButton : this.treeNodes.values()) {
                nodeButton.renderWidget(guiGraphics, correctedMouseX, correctedMouseY, partialTicks);
            }
            RenderSystem.disableDepthTest();
            guiGraphics.disableScissor();
            guiGraphics.pose().popPose();
        }

        public Component getTitle() {
            return this.title;
        }

        @OnlyIn(value=Dist.CLIENT)
        public class NodeButton
        extends AbstractButton {
            private final SkillTreeProgression.TopDownTreeNode treeNode;
            private final List<Pair<NodeButton, List<Vec2i>>> parents;
            private final CategorySlotTexture categoryTexture;
            private final boolean importedNode;

            public NodeButton(SkillTreeProgression.TopDownTreeNode treeNode) {
                super(treeNode.nodeInfo().positionInScreen().x, treeNode.nodeInfo().positionInScreen().y, 32, 32, (Component)Component.empty());
                this.parents = new ArrayList<Pair<NodeButton, List<Vec2i>>>();
                this.treeNode = treeNode;
                this.categoryTexture = (CategorySlotTexture)CategorySlotTexture.ENUM_MANAGER.get(treeNode.nodeInfo().skill().getCategory().toString());
                this.importedNode = treeNode.nodeInfo().importFrom() != null;
            }

            public Skill getSkill() {
                return this.treeNode.nodeInfo().skill();
            }

            protected boolean clicked(double pMouseX, double pMouseY) {
                double widthHalf = (double)this.width / 2.0;
                double heightHalf = (double)this.height / 2.0;
                return this.active && this.visible && pMouseX >= (double)this.getX() - widthHalf && pMouseY >= (double)this.getY() - heightHalf && pMouseX < (double)this.getX() + widthHalf && pMouseY < (double)this.getY() + heightHalf;
            }

            public void onPress() {
                if (this.importedNode) {
                    SkillTreeScreen.this.setTreeIndex(SkillTreeScreen.this.skillTreeIndices.get(((SkillTreeProgression.ImportedNode)this.treeNode).getImportedTree()));
                    SkillTreeScreen.this.setFocus(this.treeNode.nodeInfo().skill());
                } else {
                    SkillTreeScreen.this.backgroundMode = true;
                    Minecraft.getInstance().setScreen((Screen)new SkillInfoScreen(SkillTreeScreen.this.player, TreePage.this.skillTree, this.treeNode, SkillTreeScreen.this));
                }
            }

            protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
                this.defaultButtonNarrationText(pNarrationElementOutput);
            }

            protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
                ButtonStateTexture buttonTexture = ButtonStateTexture.STATE_MAPPING.get((Object)this.treeNode.nodeState());
                if (buttonTexture == ButtonStateTexture.ACQUIRED && SkillTreeScreen.this.playerSkills.isEquipping(this.getSkill())) {
                    buttonTexture = ButtonStateTexture.EQUIPPED;
                }
                ResourceLocation nodeTexture = ResourceLocation.fromNamespaceAndPath((String)"epicskills", (String)String.format("textures/gui/widget/node/%s/%s.png", ParseUtil.toLowerCase((String)this.treeNode.nodeInfo().skill().getCategory().toString()), ParseUtil.toLowerCase((String)buttonTexture.name())));
                if (this.importedNode) {
                    RenderSystem.enableBlend();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
                }
                int widthHalf = this.width / 2;
                int heightHalf = this.height / 2;
                guiGraphics.blit(nodeTexture, this.getX() - widthHalf - this.categoryTexture.offsetX(), this.getY() - heightHalf - this.categoryTexture.offsetY(), this.categoryTexture.texWidth(), this.categoryTexture.texHeight(), 0.0f, 0.0f, this.categoryTexture.texWidth(), this.categoryTexture.texHeight(), this.categoryTexture.texWidth(), this.categoryTexture.texHeight());
                guiGraphics.innerBlit(this.treeNode.nodeInfo().skill().getSkillTexture(), this.getX() - widthHalf, this.getX() + widthHalf, this.getY() - heightHalf, this.getY() + heightHalf, 0, 0.0f, 1.0f, 0.0f, 1.0f, (float)buttonTexture.r / 255.0f, (float)buttonTexture.g / 255.0f, (float)buttonTexture.b / 255.0f, 1.0f);
                if (buttonTexture == ButtonStateTexture.LOCKED && !this.treeNode.nodeInfo().noUnlockConditions()) {
                    guiGraphics.innerBlit(ResourceLocation.fromNamespaceAndPath((String)"epicskills", (String)"textures/gui/widget/locker.png"), this.getX() - widthHalf, this.getX() + widthHalf, this.getY() - heightHalf, this.getY() + heightHalf, 0, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                if (this.importedNode) {
                    RenderSystem.disableBlend();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                if (!SkillTreeScreen.this.backgroundMode && this.getX() - widthHalf - 2 < mouseX && mouseX < this.getX() + widthHalf && this.getY() - heightHalf - 2 < mouseY && mouseY < this.getY() + heightHalf) {
                    if (this.importedNode) {
                        SkillTreeScreen.this.setTooltipForNextRenderPass(List.of(this.treeNode.nodeInfo().skill().getDisplayName().getVisualOrderText(), Component.translatable((String)"gui.epicskills.skill_tree.imported_node", (Object[])new Object[]{Component.translatable((String)SkillTree.toDescriptionId((ResourceKey<SkillTree>)((SkillTreeProgression.ImportedNode)this.treeNode).getImportedTree().key())).getString()}).getVisualOrderText()));
                    } else {
                        ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
                        lines.add(this.treeNode.nodeInfo().skill().getDisplayName().getVisualOrderText());
                        if (buttonTexture == ButtonStateTexture.LOCKED && this.treeNode.nodeInfo().unlockTip() != null) {
                            lines.addAll(SkillTreeScreen.this.font.split((FormattedText)this.treeNode.nodeInfo().unlockTip(), SkillTreeScreen.this.width / 2));
                        }
                        SkillTreeScreen.this.setTooltipForNextRenderPass(lines);
                    }
                }
                if (!(buttonTexture != ButtonStateTexture.LOCKED && buttonTexture != ButtonStateTexture.UNLOCKABLE || this.importedNode)) {
                    int markerX = this.getX() + widthHalf - 7;
                    int markerY = this.getY() + heightHalf - 8;
                    guiGraphics.fill(markerX, markerY, markerX + 11, markerY + 12, -9934744);
                    guiGraphics.fill(markerX + 1, markerY + 1, markerX + 10, markerY + 11, -16777216);
                    guiGraphics.drawString(SkillTreeScreen.this.font, String.valueOf(this.treeNode.nodeInfo().requiredAbilityPoints()), markerX + 3, markerY + 2, SkillTreeScreen.this.playerAbilityPoints.getAbilityPoints() >= this.treeNode.nodeInfo().requiredAbilityPoints() ? -1 : -65536);
                }
                guiGraphics.pose().popPose();
                for (Pair<NodeButton, List<Vec2i>> parentTree : this.parents) {
                    boolean unlocked;
                    NodeButton parentButton = (NodeButton)((Object)parentTree.getFirst());
                    ArrayList<Vec2i> controlPoints = new ArrayList<Vec2i>();
                    controlPoints.add(new Vec2i(parentButton.getX(), parentButton.getY()));
                    if (parentTree.getSecond() == null || ((List)parentTree.getSecond()).isEmpty()) {
                        controlPoints.add(new Vec2i(this.getX(), parentButton.getY()));
                    } else {
                        controlPoints.addAll((Collection)parentTree.getSecond());
                    }
                    controlPoints.add(new Vec2i(this.getX(), this.getY()));
                    boolean bl = unlocked = ((NodeButton)((Object)parentTree.getFirst())).treeNode.nodeState() == SkillTreeProgression.NodeState.UNLOCKED;
                    if (unlocked) {
                        guiGraphics.pose().pushPose();
                        guiGraphics.pose().translate(0.0f, 0.0f, 1.0f);
                    }
                    for (int i = 0; i < controlPoints.size() - 1; ++i) {
                        Vec2i p1 = (Vec2i)controlPoints.get(i);
                        Vec2i p2 = (Vec2i)controlPoints.get(i + 1);
                        Tesselator tesselator = Tesselator.getInstance();
                        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
                        float xDiff = p2.x - p1.x;
                        float yDiff = p2.y - p1.y;
                        float length = Mth.sqrt((float)(xDiff * xDiff + yDiff * yDiff));
                        bufferBuilder.addVertex(guiGraphics.pose().last().pose(), (float)p1.x + 0.5f, (float)p1.y + 0.5f, 0.0f).setColor(unlocked ? -2698555 : -16777216).setNormal(xDiff /= length, yDiff /= length, 0.0f);
                        bufferBuilder.addVertex(guiGraphics.pose().last().pose(), (float)p2.x + 0.5f, (float)p2.y + 0.5f, 0.0f).setColor(unlocked ? -2698555 : -16777216).setNormal(xDiff, yDiff, 0.0f);
                        RenderSystem.disableCull();
                        if (SkillTreeScreen.this.nodeScale != -1) {
                            RenderSystem.lineWidth((float)((float)SkillTreeScreen.this.nodeScale * 2.0f));
                        } else {
                            RenderSystem.lineWidth((float)((float)SkillTreeScreen.this.minecraft.getWindow().getGuiScale() * 2.0f));
                        }
                        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
                        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
                        RenderSystem.enableCull();
                    }
                    if (!unlocked) continue;
                    guiGraphics.pose().popPose();
                }
            }

            @OnlyIn(value=Dist.CLIENT)
            public static enum ButtonStateTexture {
                LOCKED(87, 87, 87),
                UNLOCKABLE(152, 152, 152),
                ACQUIRED(224, 218, 206),
                EQUIPPED(251, 252, 238);

                private static final Map<SkillTreeProgression.NodeState, ButtonStateTexture> STATE_MAPPING;
                private int r;
                private int g;
                private int b;

                private ButtonStateTexture(int r, int g, int b) {
                    this.r = r;
                    this.g = g;
                    this.b = b;
                }

                static {
                    STATE_MAPPING = ImmutableMap.of((Object)((Object)SkillTreeProgression.NodeState.LOCKED), (Object)((Object)LOCKED), (Object)((Object)SkillTreeProgression.NodeState.UNLOCKABLE), (Object)((Object)UNLOCKABLE), (Object)((Object)SkillTreeProgression.NodeState.UNLOCKED), (Object)((Object)ACQUIRED));
                }
            }

            @OnlyIn(value=Dist.CLIENT)
            public static enum CategorySlotTextures implements CategorySlotTexture
            {
                DODGE(3, 6, 38, 44),
                GUARD(3, 7, 38, 46),
                IDENTITY(6, 6, 44, 44),
                PASSIVE(3, 3, 38, 38),
                MOVER(5, 5, 42, 42);

                private int offsetX;
                private int offsetY;
                private int texWidth;
                private int texHeight;
                private int universalOrder;

                private CategorySlotTextures(int offsetX, int offsetY, int texWidth, int texHeight) {
                    this.offsetX = offsetX;
                    this.offsetY = offsetY;
                    this.texWidth = texWidth;
                    this.texHeight = texHeight;
                    this.universalOrder = CategorySlotTexture.ENUM_MANAGER.assign((ExtensibleEnum)this);
                }

                @Override
                public int offsetX() {
                    return this.offsetX;
                }

                @Override
                public int offsetY() {
                    return this.offsetY;
                }

                @Override
                public int texWidth() {
                    return this.texWidth;
                }

                @Override
                public int texHeight() {
                    return this.texHeight;
                }

                public int universalOrdinal() {
                    return this.universalOrder;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class TreeSelectButton
    extends Button
    implements HoverSoundPlayer {
        protected static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"epicskills", (String)"widget/skill_tree_button"), ResourceLocation.fromNamespaceAndPath((String)"epicskills", (String)"widget/skill_tree_button_disabled"), ResourceLocation.fromNamespaceAndPath((String)"epicskills", (String)"widget/skill_tree_button_highlighted"));
        private final Holder.Reference<SkillTree> skillTree;

        protected TreeSelectButton(int treeIndex, Holder.Reference<SkillTree> skillTree) {
            super(4, 0, 32, 32, CommonComponents.EMPTY, button -> {
                if (com$yesman$epicskills$client$gui$screen$SkillTreeScreen$this.currentPage != com$yesman$epicskills$client$gui$screen$SkillTreeScreen$this.skillTreePages.get(treeIndex)) {
                    SkillTreeScreen.this.setTreeIndex(treeIndex);
                }
            }, Button.DEFAULT_NARRATION);
            this.skillTree = skillTree;
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (SkillTreeScreen.this.backgroundMode) {
                this.isHovered = false;
            }
            guiGraphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
            if (!this.active) {
                RenderSystem.setShaderColor((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
            }
            guiGraphics.blit(SKILL_TREE_ICON_TEXTURES.apply(this.skillTree), this.getX(), this.getY(), 0, 0.0f, 0.0f, 32, 32, 32, 32);
            if (!this.active) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }

        @Override
        public SoundEvent getHoverSound() {
            return this.active ? (SoundEvent)EpicSkillsSounds.HOVER.get() : null;
        }

        public void playDownSound(@NotNull SoundManager pHandler) {
            SkillTreeScreen.playSkillTreeDownSound(pHandler);
        }
    }
}

