/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.skilltree;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.Nullable;

public record SkillTree(Vec3i menuBarColor, @Nullable EntityPredicate conditions, @Nullable Component unlockTip, boolean locked, boolean hiddenWhenLocked, boolean disabled, int priority) {
    public static final ResourceKey<Registry<SkillTree>> SKILL_TREE_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"epicskills", (String)"tree"));
    public static final Codec<SkillTree> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3i.CODEC.optionalFieldOf("menu_color").forGetter(skilltree -> Optional.ofNullable(skilltree.menuBarColor())), (App)ExtraCodecs.JSON.optionalFieldOf("conditions").forGetter(skilltree -> {
        JsonElement serialized = skilltree.conditions() == null ? null : (JsonElement)EntityPredicate.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)skilltree.conditions()).getOrThrow();
        return Optional.ofNullable(serialized);
    }), (App)Codec.STRING.optionalFieldOf("unlock_tip").forGetter(node -> node.unlockTip() == null ? Optional.empty() : Optional.of(((TranslatableContents)((MutableComponent)node.unlockTip()).getContents()).getKey())), (App)Codec.BOOL.optionalFieldOf("locked").forGetter(skilltree -> Optional.ofNullable(skilltree.locked())), (App)Codec.BOOL.optionalFieldOf("hidden").forGetter(skilltree -> Optional.ofNullable(skilltree.hiddenWhenLocked())), (App)Codec.BOOL.optionalFieldOf("disabled").forGetter(skilltree -> Optional.ofNullable(skilltree.disabled())), (App)Codec.INT.optionalFieldOf("priority").forGetter(skilltree -> Optional.ofNullable(skilltree.priority()))).apply((Applicative)instance, (menuBarColorOpt, conditions, unlockTip, lockedOpt, hiddenWhenLockedOpt, disabledOpt, priorityOpt) -> {
        JsonElement entityPredicatesJson = conditions.orElse(null);
        EntityPredicate entityPredicates = entityPredicatesJson == null ? null : (EntityPredicate)((Pair)EntityPredicate.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)entityPredicatesJson).getOrThrow()).getFirst();
        return new SkillTree(menuBarColorOpt.orElse(new Vec3i(255, 255, 255)), entityPredicates, (Component)(unlockTip.isPresent() ? Component.translatable((String)((String)unlockTip.get())) : null), lockedOpt.orElse(false), hiddenWhenLockedOpt.orElse(false), disabledOpt.orElse(false), priorityOpt.orElse(100));
    }));

    public static String toDescriptionId(ResourceKey<SkillTree> resourceKey) {
        return String.format("skill_tree.%s.%s", resourceKey.location().getNamespace(), resourceKey.location().getPath());
    }

    public boolean noUnlcokConditions() {
        return this.conditions() == null;
    }
}

