/*
 * Decompiled with CFR 0.152.
 */
package de.cjdev.renderra.client;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.moulberry.axiom.displayentity.DisplayEntityManipulator;
import de.cjdev.renderra.Renderra;
import de.cjdev.renderra.client.ClientPlaybackHandler;
import de.cjdev.renderra.client.network.UpdateNBTPacket;
import de.cjdev.renderra.client.screen.VideoPlayerScreen;
import de.cjdev.renderra.network.FastFrameManipulate;
import de.cjdev.renderra.network.ImageIterable;
import de.cjdev.renderra.subtitle.SRTLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_437;
import net.minecraft.class_5242;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_8113;

@Environment(value=EnvType.CLIENT)
public class VideoPlayerClient
implements ClientModInitializer {
    public static final class_304 OPEN_VIDEO_PLAYER = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.renderra.open", class_3675.class_307.field_1668, 66, "category.renderra.keybinds"));
    public static BiConsumer<class_310, Double> UPDATE = null;
    public OperationMode operationMode = OperationMode.NONE;
    private class_8113 lastSelectedDisplay;
    public final ClientPlaybackHandler PLAYBACK = new ClientPlaybackHandler();

    public void updateLightLevel(int lightLevel) {
        System.out.println("UPDATE LIGHT");
        class_2487 compoundTag = new class_2487();
        class_2487 brightnessTag = new class_2487();
        brightnessTag.method_10569("block", lightLevel);
        brightnessTag.method_10569("sky", 0);
        compoundTag.method_10566("brightness", (class_2520)compoundTag);
        new UpdateNBTPacket(this.PLAYBACK.SCREEN_META.getScreenUUIDs(), compoundTag).send();
    }

    public static boolean notInGame() {
        return class_310.method_1551().method_1562() == null;
    }

    public boolean addScreen(class_8113.class_8123 display) {
        return this.PLAYBACK.SCREEN_META.addScreen(display);
    }

    public boolean removeScreen(class_8113.class_8123 display) {
        return this.PLAYBACK.SCREEN_META.removeScreen(display);
    }

    public void handleFastFrameManipulate(FastFrameManipulate packet, class_746 player) {
        class_1297 class_12972 = player.method_37908().method_8469(packet.getEntityID());
        if (class_12972 instanceof class_8113.class_8123) {
            class_8113.class_8123 textDisplay = (class_8113.class_8123)class_12972;
            class_5250 text = class_2561.method_43470((String)"").method_27694(style -> style.method_27704(class_2960.method_60655((String)"m", (String)"p")));
            text.method_10855().addAll(((ImageIterable)packet.getBufferedImage()).sections());
            textDisplay.method_48911((class_2561)text);
        }
    }

    public void onInitializeClient() {
        Renderra.VIDEOS_FOLDER.mkdirs();
        ClientPlayNetworking.registerGlobalReceiver(FastFrameManipulate.PACKET_TYPE, (payload, context) -> this.handleFastFrameManipulate((FastFrameManipulate)payload, context.player()));
        ClientPlayConnectionEvents.JOIN.register((clientPacketListener, packetSender, minecraft) -> {
            this.PLAYBACK.cleanUpVideo();
            this.PLAYBACK.warnedNoSupportedProtocol = false;
            this.PLAYBACK.SCREEN_META.screens.clear();
            this.PLAYBACK.SCREEN_META.subtitleScreen = null;
            this.PLAYBACK.subtitles = null;
            this.PLAYBACK.subtitleCurrently = null;
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, context) -> dispatcher.register(this.getCommand()));
        UPDATE = this.PLAYBACK::deltaTick;
        ClientTickEvents.END_CLIENT_TICK.register(minecraft -> {
            this.PLAYBACK.tick();
            if (!(minecraft.field_1755 instanceof VideoPlayerScreen)) {
                class_8113 display = DisplayEntityManipulator.getActiveDisplayEntity();
                switch (this.operationMode.ordinal()) {
                    case 1: {
                        if (!(display instanceof class_8113.class_8123)) break;
                        class_8113.class_8123 textDisplay = (class_8113.class_8123)display;
                        if (display == this.lastSelectedDisplay) break;
                        boolean added = this.addScreen(textDisplay);
                        class_370.method_27024((class_374)minecraft.method_1566(), (class_370.class_9037)class_370.class_9037.field_47583, (class_2561)class_2561.method_43470((String)"VideoPlayer"), (class_2561)class_2561.method_43470((String)(added ? "Added Screen" : "Already Added Screen")));
                        break;
                    }
                    case 2: {
                        if (!(display instanceof class_8113.class_8123)) break;
                        class_8113.class_8123 textDisplay = (class_8113.class_8123)display;
                        if (display == this.lastSelectedDisplay) break;
                        boolean removed = this.removeScreen(textDisplay);
                        class_370.method_27024((class_374)minecraft.method_1566(), (class_370.class_9037)class_370.class_9037.field_47583, (class_2561)class_2561.method_43470((String)"VideoPlayer"), (class_2561)class_2561.method_43470((String)(removed ? "Removed Screen" : "Already like that")));
                    }
                }
                if (this.lastSelectedDisplay != display) {
                    this.lastSelectedDisplay = display;
                }
                if (minecraft.field_1724 != null && OPEN_VIDEO_PLAYER.method_1434() && minecraft.field_1724.method_5691() >= 2) {
                    minecraft.method_1507((class_437)new VideoPlayerScreen(minecraft.field_1755, this));
                }
            }
        });
        ClientEntityEvents.ENTITY_UNLOAD.register((entity, clientLevel) -> {
            if (!(entity instanceof class_8113.class_8123)) {
                return;
            }
            class_8113.class_8123 textDisplay = (class_8113.class_8123)entity;
            this.PLAYBACK.SCREEN_META.removeScreen(textDisplay);
        });
    }

    private CompletableFuture<Suggestions> suggestTextDisplay(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
        class_8113 activeDisplayEntity = DisplayEntityManipulator.getActiveDisplayEntity();
        if (activeDisplayEntity instanceof class_8113.class_8123) {
            builder.suggest(activeDisplayEntity.method_5845());
        }
        return builder.buildFuture();
    }

    public List<String> getVideoNames() {
        String[] fileNames = Renderra.VIDEOS_FOLDER.list((dir, name) -> Renderra.VIDEO_FILTER.test(name));
        ArrayList<String> defaults = new ArrayList<String>();
        defaults.add("None");
        if (fileNames == null) {
            return defaults;
        }
        List<String> videoNames = Arrays.stream(fileNames).collect(Collectors.toList());
        for (int i = defaults.size() - 1; i == 0; --i) {
            videoNames.addFirst((String)defaults.get(i));
        }
        return videoNames;
    }

    private LiteralArgumentBuilder<FabricClientCommandSource> getCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"vidplay").then(ClientCommandManager.literal((String)"scale").then(ClientCommandManager.argument((String)"scale", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)10.0f)).executes(this::setScale)))).then(ClientCommandManager.literal((String)"subtitleDisplay").then(ClientCommandManager.argument((String)"display", (ArgumentType)class_5242.method_27643()).suggests(this::suggestTextDisplay).executes(this::setSubtitleUUID)))).then(ClientCommandManager.literal((String)"subtitles").then(ClientCommandManager.argument((String)"path", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            File[] files = Renderra.VIDEOS_FOLDER.listFiles((dir, name) -> Renderra.SUBTITLE_FILTER.test(name));
            if (files == null) {
                return builder.buildFuture();
            }
            for (File file : files) {
                String name2 = file.getPath().substring(Renderra.VIDEOS_FOLDER.getPath().length() + 1).replace('\\', '/');
                builder.suggest((String)(name2.matches(".*\\s.*") ? "\"" + name2 + "\"" : name2));
            }
            return builder.buildFuture();
        }).executes(this::setSubtitles)));
    }

    private int setSubtitleUUID(CommandContext<FabricClientCommandSource> context) {
        this.PLAYBACK.setSubtitleEntity((UUID)context.getArgument("display", UUID.class));
        return 1;
    }

    private int setScale(CommandContext<FabricClientCommandSource> context) {
        this.PLAYBACK.SCREEN_META.scale(((Float)context.getArgument("scale", Float.TYPE)).floatValue());
        return 1;
    }

    public class_2561 getTimestampComponent() {
        return this.getTimestampComponent(this.PLAYBACK.getTimestamp());
    }

    public class_2561 getTimestampComponent(double percentage) {
        return this.getTimestampComponent((long)((double)(this.PLAYBACK.VIDEO_META.secondsLength() * 1000000L) * percentage));
    }

    public class_2561 getTimestampComponent(long timestamp) {
        boolean doHours;
        long seconds = timestamp / 1000000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        seconds %= 60L;
        minutes %= 60L;
        StringBuilder builder = new StringBuilder();
        boolean bl = doHours = hours > 0L;
        if (doHours) {
            builder.append(hours);
            builder.append(':');
        }
        builder.append(doHours ? String.format("%02d", minutes) : Long.valueOf(minutes));
        builder.append(':');
        builder.append(String.format("%02d", seconds));
        return class_2561.method_43470((String)builder.toString());
    }

    private int setSubtitles(CommandContext<FabricClientCommandSource> context) {
        String filePath = (String)context.getArgument("path", String.class);
        File srtFile = Renderra.VIDEOS_FOLDER.toPath().resolve(filePath).toFile();
        if (!Renderra.SUBTITLE_FILTER.test(srtFile.getName())) {
            return 0;
        }
        if (!srtFile.exists()) {
            return 0;
        }
        try {
            this.PLAYBACK.subtitles = SRTLoader.parseSRT(srtFile.toPath());
            VideoPlayerScreen.doToast("Loaded SRT file");
            return 1;
        }
        catch (IOException e) {
            VideoPlayerScreen.doToast("Failed to load SRT file");
            return 0;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum OperationMode {
        NONE,
        ADD_SCREEN,
        REMOVE_SCREEN;

    }
}

