/*
 * Decompiled with CFR 0.152.
 */
package de.cjdev.renderra.client.screen;

import de.cjdev.renderra.ColorMode;
import de.cjdev.renderra.PlaybackHandler;
import de.cjdev.renderra.Renderra;
import de.cjdev.renderra.ReplayMode;
import de.cjdev.renderra.VideoMetaData;
import de.cjdev.renderra.VideoResult;
import de.cjdev.renderra.client.VideoPlayerClient;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class VideoPlayerScreen
extends class_437 {
    private final class_437 parent;
    private final VideoPlayerClient videoPlayer;
    private class_342 WIDTH_BOX;
    private class_342 HEIGHT_BOX;
    private Boolean wasPlaying;

    public VideoPlayerScreen(class_437 parent, VideoPlayerClient videoPlayer) {
        super((class_2561)class_2561.method_43470((String)"Video Player"));
        this.parent = parent;
        this.videoPlayer = videoPlayer;
    }

    public static void doToast(String content) {
        class_370.method_27024((class_374)class_310.method_1551().method_1566(), (class_370.class_9037)class_370.class_9037.field_47583, (class_2561)class_2561.method_43470((String)"Video Player"), (class_2561)class_2561.method_43470((String)content));
    }

    protected void method_25426() {
        this.WIDTH_BOX = new class_342(this.field_22793, 40, this.field_22790 - 40 - 30, 50, 20, (class_2561)class_2561.method_43470((String)"Width"));
        this.HEIGHT_BOX = new class_342(this.field_22793, 100, this.field_22790 - 40 - 30, 50, 20, (class_2561)class_2561.method_43470((String)"Height"));
        this.WIDTH_BOX.method_1852(String.valueOf(this.videoPlayer.PLAYBACK.SCREEN_META.width()));
        this.HEIGHT_BOX.method_1852(String.valueOf(this.videoPlayer.PLAYBACK.SCREEN_META.height()));
        class_4185 playButton = class_4185.method_46430((class_2561)this.getPlayButtonText(), button1 -> {
            if (this.videoPlayer.PLAYBACK.playing) {
                this.videoPlayer.PLAYBACK.playing = false;
            } else {
                this.save();
                VideoResult resumeVideo = this.videoPlayer.PLAYBACK.resumeVideo();
                if (!resumeVideo.isOk()) {
                    if (resumeVideo.canDisplay()) {
                        VideoPlayerScreen.doToast(resumeVideo.toast());
                    }
                    return;
                }
                if (resumeVideo.canDisplay()) {
                    VideoPlayerScreen.doToast(resumeVideo.toast());
                }
            }
            button1.method_25355(this.getPlayButtonText());
        }).method_46434(40, this.field_22790 - 40, 20, 20).method_46431();
        this.method_37063((class_364)playButton);
        class_5676 cycleLoopBtn = class_5676.method_32606(o -> null).method_32624((Object[])ReplayMode.values()).method_32619((Object)this.videoPlayer.PLAYBACK.replayMode).method_32617(70, this.field_22790 - 40, 20, 20, null, (cycleButton, object) -> {
            this.videoPlayer.PLAYBACK.replayMode = object;
            cycleButton.method_25355((class_2561)class_2561.method_43470((String)"\ud83d\udd01").method_54663(object.buttonColor));
        });
        this.method_37063((class_364)cycleLoopBtn);
        cycleLoopBtn.method_25355((class_2561)class_2561.method_43470((String)"\ud83d\udd01").method_54663(this.videoPlayer.PLAYBACK.replayMode.buttonColor));
        this.method_37063((class_364)class_5676.method_32606(o -> class_2561.method_43470((String)o.name())).method_32624((Object[])ColorMode.values()).method_32619((Object)this.videoPlayer.PLAYBACK.colorMode).method_32617(160, this.field_22790 - 40 - 120, 115, 20, (class_2561)class_2561.method_43470((String)"Color"), (cycleButton, object) -> {
            this.videoPlayer.PLAYBACK.colorMode = object;
        }));
        this.method_37063((class_364)new VideoSelectionDropDown(this.field_22787, 240, 100, 20, 20, 100));
        this.method_37063((class_364)class_5676.method_32606(class_2561::method_43470).method_32620(this.videoPlayer.getVideoNames()).method_32619((Object)this.videoPlayer.PLAYBACK.videoName).method_32617(160, this.field_22790 - 40 - 30, 240, 20, (class_2561)class_2561.method_43470((String)"Video"), (cycleButton, value) -> {
            this.videoPlayer.PLAYBACK.videoName = value;
            playButton.method_25355(this.getPlayButtonText());
        }));
        class_5676 opButton = class_5676.method_32606(o -> class_2561.method_43470((String)o.name())).method_32624((Object[])VideoPlayerClient.OperationMode.values()).method_32619((Object)this.videoPlayer.operationMode).method_32617(40, this.field_22790 - 40 - 90, 110, 20, (class_2561)class_2561.method_43470((String)"OP"), (cycleButton, value) -> {
            this.videoPlayer.operationMode = value;
        });
        this.method_37063((class_364)opButton);
        this.method_37063((class_364)class_5676.method_32606(rotation -> class_2561.method_43470((String)rotation.name())).method_32624((Object[])class_2470.values()).method_32619((Object)this.videoPlayer.PLAYBACK.rotation).method_32617(40, this.field_22790 - 40 - 60, 110, 20, (class_2561)class_2561.method_43470((String)"Rotation"), (cycleButton, value) -> {
            this.videoPlayer.PLAYBACK.rotation = value;
        }));
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Gen Audio"), button1 -> {
            VideoResult result = this.videoPlayer.PLAYBACK.genAudio((success, e) -> {
                if (success.booleanValue()) {
                    VideoPlayerScreen.doToast("Generated Audio");
                } else {
                    VideoPlayerScreen.doToast("Failed Generating Audio");
                    assert (e != null);
                    Renderra.LOGGER.warn("Failed Generating Audio", (Throwable)e);
                }
            });
            if (result == VideoResult.OK) {
                VideoPlayerScreen.doToast("Generating Audio");
            } else if (result.canDisplay()) {
                VideoPlayerScreen.doToast(result.toast());
            }
        }).method_46434(160, this.field_22790 - 40 - 60, 115, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Sync Hz"), button1 -> {
            VideoResult result = this.videoPlayer.PLAYBACK.syncHz();
            if (result == VideoResult.OK) {
                VideoPlayerScreen.doToast("Synced Hz");
            } else if (result.canDisplay()) {
                VideoPlayerScreen.doToast(result.toast());
            }
        }).method_46434(285, this.field_22790 - 40 - 60, 115, 20).method_46431());
        this.method_37063((class_364)this.WIDTH_BOX);
        this.method_37063((class_364)this.HEIGHT_BOX);
        this.method_37063((class_364)class_4286.method_54787((class_2561)class_2561.method_43470((String)"Pretty"), (class_327)this.field_22793).method_54789(40, this.field_22790 - 40 - 120).method_54794(this.videoPlayer.PLAYBACK.SCREEN_META.pretty()).method_54791((checkbox, bl) -> this.videoPlayer.PLAYBACK.SCREEN_META.pretty(bl)).method_54788());
        VideoMetaData videoMetaData = this.videoPlayer.PLAYBACK.VIDEO_META;
        this.method_37063((class_364)new TimestampSliderButton(100, this.field_22790 - 40, 300, 20, this.videoPlayer.getTimestampComponent(), videoMetaData == null ? 0.0 : (double)this.videoPlayer.PLAYBACK.getTimestamp() / 1000000.0 / (double)videoMetaData.secondsLength(), this));
        this.method_37063((class_364)new VolumeSliderButton(160, this.field_22790 - 40 - 90, 115, 20, (class_2561)class_2561.method_43470((String)("Volume: " + this.videoPlayer.PLAYBACK.volume)), this.videoPlayer.PLAYBACK.volume / 2.0f, this.videoPlayer.PLAYBACK));
    }

    public class_2561 getPlayButtonText() {
        return class_2561.method_43470((String)(this.videoPlayer.PLAYBACK.playing ? "\u23f8" : (Objects.equals(this.videoPlayer.PLAYBACK.videoName, this.videoPlayer.PLAYBACK.VIDEO_META.fileName()) ? "\u25b6" : "\u23f3")));
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
    }

    public void save() {
        try {
            this.videoPlayer.PLAYBACK.SCREEN_META.width(Integer.parseUnsignedInt(this.WIDTH_BOX.method_1882()));
            this.videoPlayer.PLAYBACK.SCREEN_META.height(Integer.parseUnsignedInt(this.HEIGHT_BOX.method_1882()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void method_25419() {
        if (this.wasPlaying != null) {
            this.videoPlayer.PLAYBACK.playing = this.wasPlaying;
        }
        this.field_22787.method_1507(this.parent);
        this.save();
    }

    @Environment(value=EnvType.CLIENT)
    public static class VideoSelectionDropDown
    extends class_4265<Entry> {
        public VideoSelectionDropDown(class_310 minecraft, int width, int height, int y, int itemHeight, int a) {
            super(minecraft, width, height, y, itemHeight, a);
            this.method_25321((class_350.class_351)new Entry(minecraft.field_1772, "Test"));
        }

        @Environment(value=EnvType.CLIENT)
        public static class Entry
        extends class_4265.class_4266<Entry> {
            private final class_327 font;
            private final String value;

            public Entry(class_327 font, String value) {
                this.font = font;
                this.value = value;
            }

            public void method_25343(class_332 guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                guiGraphics.method_51433(this.font, this.value, x + 4, y + 6, 0xFFFFFF, false);
            }

            @NotNull
            public List<? extends class_6379> method_37025() {
                return List.of();
            }

            @NotNull
            public List<? extends class_364> method_25396() {
                return List.of();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class TimestampSliderButton
    extends class_357 {
        private final VideoPlayerScreen videoPlayer;

        public TimestampSliderButton(int i, int j, int k, int l, class_2561 component, double d, VideoPlayerScreen videoPlayer) {
            super(i, j, k, l, component, d);
            this.videoPlayer = videoPlayer;
        }

        protected void method_25346() {
            this.method_25355(this.videoPlayer.videoPlayer.getTimestampComponent(this.field_22753));
        }

        protected void method_25344() {
        }

        protected void method_25349(double d, double e, double f, double g) {
            if (this.videoPlayer.wasPlaying == null) {
                this.videoPlayer.wasPlaying = this.videoPlayer.videoPlayer.PLAYBACK.playing;
                this.videoPlayer.videoPlayer.PLAYBACK.playing = false;
            }
            super.method_25349(d, e, f, g);
        }

        public void method_25357(double d, double e) {
            this.applyTime();
            if (this.videoPlayer.wasPlaying != null) {
                this.videoPlayer.videoPlayer.PLAYBACK.playing = this.videoPlayer.wasPlaying;
            }
            super.method_25357(d, e);
        }

        public void method_25348(double d, double e) {
            this.applyTime();
            super.method_25348(d, e);
        }

        public void applyTime() {
            VideoPlayerClient clientMod = this.videoPlayer.videoPlayer;
            VideoMetaData videoMetaData = clientMod.PLAYBACK.VIDEO_META;
            if (videoMetaData == null) {
                return;
            }
            long videoLength = videoMetaData.secondsLength();
            clientMod.PLAYBACK.setTimestampSeconds((long)(this.field_22753 * (double)videoLength));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class VolumeSliderButton
    extends class_357 {
        private final PlaybackHandler PLAYBACK;

        public VolumeSliderButton(int i, int j, int k, int l, class_2561 component, double d, PlaybackHandler PLAYBACK) {
            super(i, j, k, l, component, d);
            this.PLAYBACK = PLAYBACK;
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43470((String)("Volume: " + Math.floor(this.field_22753 * 20.0) / 10.0)));
        }

        protected void method_25344() {
            this.PLAYBACK.volume = (float)Math.floor(this.field_22753 * 20.0) / 10.0f;
        }
    }
}

