/*
 * Decompiled with CFR 0.152.
 */
package de.cjdev.renderra.network;

import de.cjdev.renderra.ColorMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_2561;

public record ImageIterable(int[] palette, List<PixelWidth> pixelWidths, List<class_2561> sections) {
    public static ImageIterable read(class_2540 byteBuf, ColorMode colorMode, boolean pretty) {
        return ImageIterable.read(byteBuf, colorMode, pretty, false);
    }

    public static ImageIterable read(class_2540 byteBuf, ColorMode colorMode, boolean pretty, boolean forClient) {
        int paletteLen = byteBuf.method_10816();
        int[] palette = new int[paletteLen];
        for (int i = 0; i < paletteLen; ++i) {
            palette[i] = byteBuf.method_10816();
        }
        ArrayList<class_2561> sectionList = new ArrayList<class_2561>();
        ArrayList<PixelWidth> pixelWidths = new ArrayList<PixelWidth>();
        if (colorMode == ColorMode.FIFTEEN_BIT) {
            StringBuilder pixels = new StringBuilder();
            while (byteBuf.isReadable()) {
                int consecutive = byteBuf.method_10816();
                int colorIndex = byteBuf.method_10816();
                if (consecutive < 0) continue;
                Object pixel = String.valueOf((char)(palette[colorIndex] + 12832));
                if (pretty) {
                    pixel = (String)pixel + ".";
                }
                if (!forClient) {
                    pixelWidths.add(new PixelWidth(consecutive, colorIndex));
                }
                int pixelChars = ((String)pixel).length();
                while (consecutive > 0) {
                    int remainingChars = Short.MAX_VALUE - pixels.length();
                    int pixelsFit = remainingChars / pixelChars;
                    if (pixelsFit == 0) {
                        sectionList.add((class_2561)class_2561.method_43470((String)pixels.toString()));
                        pixels.setLength(0);
                        continue;
                    }
                    int toWrite = Math.min(pixelsFit, consecutive);
                    pixels.repeat((CharSequence)pixel, toWrite);
                    consecutive -= toWrite;
                    if (pixels.length() != Short.MAX_VALUE) continue;
                    sectionList.add((class_2561)class_2561.method_43470((String)pixels.toString()));
                    pixels.setLength(0);
                }
            }
            if (!pixels.isEmpty()) {
                sectionList.add((class_2561)class_2561.method_43470((String)pixels.toString()));
            }
        } else {
            Object pixel = "A";
            if (pretty) {
                pixel = (String)pixel + ".";
            }
            while (byteBuf.isReadable()) {
                int consecutive = byteBuf.method_10816();
                int colorIndex = byteBuf.method_10816();
                if (consecutive < 0) continue;
                if (!forClient) {
                    pixelWidths.add(new PixelWidth(consecutive, colorIndex));
                }
                sectionList.add((class_2561)class_2561.method_43470((String)((String)pixel).repeat(consecutive)).method_54663(palette[colorIndex]));
            }
        }
        return new ImageIterable(palette, pixelWidths, sectionList);
    }

    public record PixelWidth(int consecutive, int colorIndex) {
    }
}

