/*
 * Decompiled with CFR 0.152.
 */
package de.cjdev.renderra.subtitle;

import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class SimpleMiniMessage {
    private final String input;
    private int cursor = 0;

    public SimpleMiniMessage(String input) {
        this.input = input;
    }

    private boolean canRead() {
        return this.cursor < this.input.length();
    }

    private char peek() {
        if (!this.canRead()) {
            throw new RuntimeException("End of input");
        }
        return this.input.charAt(this.cursor);
    }

    private char read() {
        if (!this.canRead()) {
            throw new RuntimeException("End of input");
        }
        return this.input.charAt(this.cursor++);
    }

    private boolean readIf(char expected) {
        if (this.canRead() && this.peek() == expected) {
            ++this.cursor;
            return true;
        }
        return false;
    }

    private String readUntil(char endChar) {
        int start = this.cursor;
        while (this.canRead() && this.peek() != endChar) {
            ++this.cursor;
        }
        return this.input.substring(start, this.cursor);
    }

    public class_2561 parse() {
        return this.parseComponent(null, class_2561.method_43470((String)""));
    }

    private class_2561 parseComponent(@Nullable String expectedClosingTag, class_5250 currentComponent) {
        SimpleMiniMessage.applyStyle(currentComponent, expectedClosingTag);
        StringBuilder textBuffer = new StringBuilder();
        while (this.canRead()) {
            if (this.readIf('<')) {
                if (!textBuffer.isEmpty()) {
                    currentComponent.method_10855().add(class_2561.method_43470((String)textBuffer.toString()));
                    textBuffer.setLength(0);
                }
                boolean closing = this.readIf('/');
                String tagName = this.readUntil('>');
                this.read();
                if (closing) {
                    if (tagName.equalsIgnoreCase(expectedClosingTag)) {
                        return currentComponent;
                    }
                    throw new RuntimeException("Unexpected closing tag: " + tagName);
                }
                class_5250 child = class_2561.method_43470((String)"");
                this.parseComponent(tagName, child);
                SimpleMiniMessage.applyStyle(child, tagName);
                currentComponent.method_10855().add(child);
                continue;
            }
            textBuffer.append(this.read());
        }
        if (!textBuffer.isEmpty()) {
            currentComponent.method_10855().add(class_2561.method_43470((String)textBuffer.toString()));
        }
        if (expectedClosingTag != null) {
            throw new RuntimeException("Missing closing tag: " + expectedClosingTag);
        }
        return currentComponent;
    }

    private static void applyStyle(class_5250 component, String tag) {
        if (tag == null) {
            return;
        }
        switch (tag) {
            case "b": {
                component.method_27694(style -> style.method_10982(Boolean.valueOf(true)));
                break;
            }
            case "i": {
                component.method_27694(style -> style.method_10978(Boolean.valueOf(true)));
            }
        }
    }
}

