/*
 * Decompiled with CFR 0.152.
 */
package de.cjdev.renderra;

import com.moulberry.axiom.packets.AxiomServerboundManipulateEntity;
import com.moulberry.axiom.utils.EntityDataUtils;
import de.cjdev.renderra.Renderra;
import de.cjdev.renderra.ReplayMode;
import de.cjdev.renderra.ScreenMetaData;
import de.cjdev.renderra.VideoMetaData;
import de.cjdev.renderra.VideoResult;
import de.cjdev.renderra.audio.AudioSplitter;
import de.cjdev.renderra.mixin.MixinChunkMap;
import de.cjdev.renderra.mixin.MixinTrackedEntity;
import de.cjdev.renderra.network.FastFrameManipulate;
import de.cjdev.renderra.subtitle.SRTLoader;
import de.cjdev.renderra.subtitle.Subtitle;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5629;
import net.minecraft.class_8113;
import net.minecraft.class_8710;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameGrabber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaybackHandler {
    protected FFmpegFrameGrabber GRAB;
    public VideoMetaData VIDEO_META;
    public final ScreenMetaData SCREEN_META;
    public NavigableMap<Long, Subtitle> subtitles;
    public Long subtitleCurrently = null;
    protected long lastAudioChunk = -1L;
    public String videoName = "None";
    private String audioPath;
    public CompletableFuture<?> AUDIO_GENERATING = null;
    private final class_2487 SCREEN_FIX;
    public class_2470 rotation = class_2470.field_11467;
    public boolean playing;
    public float volume;
    public ReplayMode replayMode;
    public class_1937 level;
    protected static class_243 pos;

    public PlaybackHandler() {
        this(new ScreenMetaData());
    }

    public PlaybackHandler(ScreenMetaData screenMeta) {
        this.SCREEN_META = screenMeta;
        this.VIDEO_META = VideoMetaData.None();
        this.volume = 1.0f;
        class_2499 POSITION = new class_2499();
        POSITION.addAll(0, List.of(class_2494.method_23244((float)-0.007f), class_2494.method_23244((float)-0.013f), class_2494.method_23244((float)0.0f)));
        class_2487 BRIGHTNESS_FIX = new class_2487();
        BRIGHTNESS_FIX.method_10569("block", 15);
        BRIGHTNESS_FIX.method_10569("sky", 0);
        class_2487 TRANSFORMATION_FIX = new class_2487();
        TRANSFORMATION_FIX.method_10566("translation", (class_2520)POSITION);
        class_2487 TEXT_FIX = new class_2487();
        TEXT_FIX.method_10582("font", "m:p");
        TEXT_FIX.method_10582("text", "");
        this.SCREEN_FIX = new class_2487();
        this.SCREEN_FIX.method_10566("transformation", (class_2520)TRANSFORMATION_FIX);
        this.SCREEN_FIX.method_10566("text", (class_2520)TEXT_FIX);
        this.SCREEN_FIX.method_10566("brightness", (class_2520)BRIGHTNESS_FIX);
    }

    public class_1937 getLevel() {
        return this.level;
    }

    public VideoResult setupVideo() {
        if (this.SCREEN_META.screens.isEmpty()) {
            return VideoResult.NO_SCREENS;
        }
        this.playing = false;
        this.subtitleCurrently = null;
        File videoFile = new File(Renderra.VIDEOS_FOLDER, this.videoName);
        if (!Renderra.VIDEO_FILTER.test(videoFile.getName()) || !videoFile.exists()) {
            return VideoResult.INVALID_VIDEO;
        }
        if (this.GRAB != null) {
            try {
                this.GRAB.stop();
            }
            catch (FFmpegFrameGrabber.Exception exception) {
                // empty catch block
            }
        }
        this.subtitles = new TreeMap<Long, Subtitle>();
        try {
            this.audioPath = "videoaudio/" + videoFile.getName();
            this.GRAB = new FFmpegFrameGrabber(videoFile);
            this.GRAB.start();
        }
        catch (FFmpegFrameGrabber.Exception e) {
            this.GRAB = null;
            return VideoResult.FFmpeg_ERROR;
        }
        VideoResult result = this.fixScreens();
        if (!result.isOk()) {
            return result;
        }
        this.processFrame(this.GRAB);
        try {
            this.GRAB.setTimestamp(0L);
        }
        catch (FFmpegFrameGrabber.Exception exception) {
            // empty catch block
        }
        this.VIDEO_META = new VideoMetaData(this.videoName, this.GRAB.getFrameRate(), this.GRAB.getLengthInTime() / 1000000L, 1.0 / this.GRAB.getFrameRate());
        this.lastAudioChunk = -1L;
        this.updateSubtitle((class_2561)class_2561.method_43473());
        return VideoResult.LOADED_VIDEO;
    }

    public VideoResult resumeVideo() {
        if (this.AUDIO_GENERATING != null && !this.AUDIO_GENERATING.isDone()) {
            return VideoResult.GEN_AUDIO;
        }
        if (this.GRAB == null || !Objects.equals(this.videoName, this.VIDEO_META.fileName())) {
            return this.setupVideo();
        }
        this.playing = true;
        return VideoResult.OK;
    }

    protected void processSubtitles() {
        if (this.GRAB == null) {
            return;
        }
        if (this.subtitles == null) {
            return;
        }
        long millis = this.GRAB.getTimestamp() / 1000L;
        Map.Entry<Long, Subtitle> subtitle = SRTLoader.getSubtitleAt(this.subtitles, millis);
        if (subtitle == null && this.subtitleCurrently != null) {
            this.subtitleCurrently = null;
            this.updateSubtitle((class_2561)class_2561.method_43473());
        } else if (subtitle != null && !Objects.equals(subtitle.getKey(), this.subtitleCurrently)) {
            this.subtitleCurrently = subtitle.getKey();
            this.updateSubtitle(subtitle.getValue().text());
        }
    }

    protected void processAudio() {
        if (this.GRAB == null) {
            return;
        }
        long chunk = this.GRAB.getTimestamp() / 5000000L;
        if (chunk == this.lastAudioChunk) {
            return;
        }
        class_8113.class_8123 screen = this.SCREEN_META.getMainScreen();
        if (this.volume != 0.0f) {
            this.playSound((class_1297)screen, class_3414.method_47908((class_2960)class_2960.method_60655((String)"renderra", (String)("part" + String.format("%05x", chunk)))), class_3419.field_15247, this.volume, 1.0f);
        }
        this.lastAudioChunk = chunk;
    }

    protected void playSound(class_1297 atEntity, class_3414 soundEvent, class_3419 source, float volume, float pitch) {
        class_243 position = atEntity.method_19538();
        this.getLevel().method_43128(atEntity, position.field_1352, position.field_1351, position.field_1350, soundEvent, source, volume, pitch);
    }

    protected void updateSubtitle(class_2561 text) {
        if (this.SCREEN_META.subtitleScreen == null) {
            return;
        }
        this.SCREEN_META.subtitleScreen.method_48911(text);
    }

    public void doNBTMerge(UUID uuid, class_2487 merge) {
        class_1297 entity = this.getLevel().method_66347(uuid);
        if (entity == null) {
            return;
        }
        class_2487 compoundTag = EntityDataUtils.saveWithoutId((class_1297)entity);
        compoundTag.method_10543(merge);
        EntityDataUtils.load((class_1297)entity, (class_2487)compoundTag);
    }

    public VideoResult fixScreens() {
        if (this.SCREEN_META.screens.isEmpty()) {
            return VideoResult.NO_SCREENS;
        }
        class_8113.class_8123 entity = this.SCREEN_META.getMainScreen();
        if (entity == null) {
            return VideoResult.NO_SCREENS;
        }
        pos = entity.method_19538();
        class_2499 SCALE = new class_2499();
        float scale = this.SCREEN_META.scale();
        SCALE.add((Object)class_2494.method_23244((float)scale));
        SCALE.add((Object)class_2494.method_23244((float)scale));
        SCALE.add((Object)class_2494.method_23244((float)scale));
        this.SCREEN_FIX.method_10569("line_width", (this.SCREEN_META.pretty() ? 10 : 11) * this.SCREEN_META.width() + 1);
        this.SCREEN_FIX.method_10562("transformation").ifPresent(compoundTag -> compoundTag.method_10566("scale", (class_2520)SCALE));
        this.doNBTMerge(entity.method_5667(), this.SCREEN_FIX);
        int screenCount = this.SCREEN_META.screens.size();
        int curScreen = screenCount - 1;
        int screenHeight = this.SCREEN_META.height();
        int sectionHeight = Math.round((float)screenHeight / (float)screenCount);
        ArrayList<AxiomServerboundManipulateEntity.ManipulateEntry> manipulateEntries = new ArrayList<AxiomServerboundManipulateEntity.ManipulateEntry>();
        UUID[] screenUUIDs = this.SCREEN_META.getScreenUUIDs();
        for (int i = 1; i < screenUUIDs.length; ++i) {
            double offset = (double)(screenHeight - curScreen-- * sectionHeight) * 0.25 * (double)scale;
            class_243 position = pos.method_1031(0.0, offset, 0.0);
            AxiomServerboundManipulateEntity.ManipulateEntry manipulateEntry = new AxiomServerboundManipulateEntity.ManipulateEntry(screenUUIDs[i], position, this.SCREEN_FIX);
            manipulateEntries.add(manipulateEntry);
        }
        new AxiomServerboundManipulateEntity(manipulateEntries).send();
        return VideoResult.OK;
    }

    public void videoDone() {
        if (this.replayMode == ReplayMode.LOOP && this.GRAB != null) {
            try {
                this.GRAB.setTimestamp(0L);
                this.lastAudioChunk = -1L;
            }
            catch (FFmpegFrameGrabber.Exception exception) {
                // empty catch block
            }
        }
        this.cleanUpVideo();
    }

    public void cleanUpVideo() {
        if (this.GRAB != null) {
            try {
                this.GRAB.stop();
            }
            catch (FFmpegFrameGrabber.Exception exception) {
                // empty catch block
            }
            this.GRAB = null;
            this.playing = false;
            this.VIDEO_META = VideoMetaData.None();
        }
        pos = null;
    }

    public VideoResult genAudio(BiConsumer<Boolean, @Nullable Exception> callback) {
        if (this.GRAB == null) {
            return VideoResult.NO_VIDEO;
        }
        if (this.playing) {
            return VideoResult.VIDEO_PLAYING;
        }
        if (this.AUDIO_GENERATING != null && !this.AUDIO_GENERATING.isDone()) {
            return VideoResult.GEN_AUDIO;
        }
        Path packFolder = Path.of(this.audioPath, new String[0]);
        Path soundsFolder = packFolder.resolve("assets/renderra/sounds");
        this.AUDIO_GENERATING = CompletableFuture.runAsync(() -> {
            try {
                AudioSplitter.splitAudioFromVideo(this.GRAB, soundsFolder);
                callback.accept(true, null);
            }
            catch (IOException | InterruptedException e) {
                callback.accept(false, e);
            }
        });
        return VideoResult.OK;
    }

    public void setSubtitleEntity(UUID uuid) {
        class_1297 class_12972 = this.getLevel().method_66347(uuid);
        if (class_12972 instanceof class_8113.class_8123) {
            class_8113.class_8123 textDisplay;
            this.SCREEN_META.subtitleScreen = textDisplay = (class_8113.class_8123)class_12972;
        }
    }

    public VideoResult syncHz() {
        if (this.VIDEO_META == null) {
            return VideoResult.NO_VIDEO;
        }
        this.getLevel().method_54719().method_54671((float)this.VIDEO_META.frameRate());
        return VideoResult.OK;
    }

    protected void processFrame(FFmpegFrameGrabber GRAB) {
        this.processFastFrame(GRAB, this::fastDisplayImage, this::videoDone);
    }

    protected void processAxiomFrame(FFmpegFrameGrabber GRAB, Consumer<class_2487[]> callback, Runnable done) {
        BufferedImage transformedImage = this.getTransformedImage(GRAB, done);
        if (transformedImage == null) {
            return;
        }
        int width = this.SCREEN_META.width();
        int height = this.SCREEN_META.height();
        int screenCount = this.SCREEN_META.screens.size();
        class_2487[] results = new class_2487[screenCount];
        int sectionHeight = Math.round((float)height / (float)screenCount);
        int pixelHeight = height - sectionHeight * (screenCount - 1);
        results[0] = this.convertImageToComponents(transformedImage, width, height, height - pixelHeight);
        for (int i = 1; i < screenCount; ++i) {
            int curHeight = (screenCount - i - 1) * sectionHeight;
            results[i] = this.convertImageToComponents(transformedImage, width, curHeight + sectionHeight, curHeight);
        }
        callback.accept(results);
    }

    protected void processFastFrame(FFmpegFrameGrabber GRAB, Consumer<BufferedImage> callback, Runnable done) {
        BufferedImage transformedImage = this.getTransformedImage(GRAB, done);
        if (transformedImage == null) {
            return;
        }
        callback.accept(transformedImage);
    }

    @Nullable
    private BufferedImage getTransformedImage(FFmpegFrameGrabber GRAB, Runnable done) {
        Frame frame;
        try {
            frame = GRAB.grabImage();
        }
        catch (FrameGrabber.Exception e) {
            done.run();
            return null;
        }
        if (frame == null) {
            done.run();
            return null;
        }
        if (this.SCREEN_META.invisible()) {
            return null;
        }
        BufferedImage bufferedImage = PlaybackHandler.rotate(Renderra.IMAGE_CONVERTER.getBufferedImage(frame), this.rotation);
        int width = this.SCREEN_META.width();
        int height = this.SCREEN_META.height();
        BufferedImage resized = new BufferedImage(width, height, 1);
        Graphics2D g = resized.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(bufferedImage, 0, 0, width, height, null);
        g.dispose();
        return resized;
    }

    @NotNull
    public static BufferedImage rotate(@NotNull BufferedImage src, class_2470 rotation) {
        Objects.requireNonNull(src);
        if (rotation == null) {
            return src;
        }
        int width = src.getWidth();
        int height = src.getHeight();
        boolean sideways = rotation.ordinal() == 1 || rotation.ordinal() == 3;
        BufferedImage rotated = new BufferedImage(sideways ? height : width, sideways ? width : height, src.getType());
        switch (rotation) {
            case field_11467: {
                return src;
            }
            case field_11463: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        rotated.setRGB(height - 1 - y, x, src.getRGB(x, y));
                    }
                }
                break;
            }
            case field_11465: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        rotated.setRGB(y, width - 1 - x, src.getRGB(x, y));
                    }
                }
                break;
            }
            case field_11464: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        rotated.setRGB(width - x - 1, height - y - 1, src.getRGB(x, y));
                    }
                }
                break;
            }
        }
        return rotated;
    }

    private class_2487 convertImageToComponents(BufferedImage image, int width, int height, int heightOffset) {
        boolean noSaving = this.SCREEN_META.pretty();
        class_2499 listTag = new class_2499();
        StringBuilder curString = new StringBuilder();
        int lastColor = -1;
        for (int y = heightOffset; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                boolean endX;
                int rgb = image.getRGB(x, y) & 0xFFFFFF;
                if (lastColor == -1) {
                    lastColor = rgb;
                }
                boolean bl = endX = x == width - 1;
                if (rgb == lastColor) {
                    curString.append("A");
                    if (!noSaving || endX) continue;
                    curString.append('.');
                    continue;
                }
                PlaybackHandler.sectionToCompound(listTag, curString.toString(), lastColor);
                curString.setLength(0);
                curString.append("A");
                if (noSaving && !endX) {
                    curString.append('.');
                }
                lastColor = rgb;
            }
        }
        if (!curString.isEmpty()) {
            PlaybackHandler.sectionToCompound(listTag, curString.toString(), lastColor);
        }
        class_2487 screenCompound = new class_2487();
        screenCompound.method_10566("extra", (class_2520)listTag);
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10566("text", (class_2520)screenCompound);
        return compoundTag;
    }

    private static void sectionToCompound(class_2499 listTag, String pixels, int lastColor) {
        int CHUNK_SIZE = Short.MAX_VALUE;
        class_2487 textCompound = new class_2487();
        int totalLength = pixels.length();
        textCompound.method_10582("text", pixels.substring(0, Math.min(Short.MAX_VALUE, totalLength)));
        textCompound.method_10582("color", String.format(Locale.ROOT, "#%06X", lastColor));
        listTag.add((Object)textCompound);
        int numChunks = (totalLength + Short.MAX_VALUE - 1) / Short.MAX_VALUE;
        for (int chunk = 1; chunk < numChunks; ++chunk) {
            int start = chunk * Short.MAX_VALUE;
            int end = Math.min(start + Short.MAX_VALUE, totalLength);
            listTag.add((Object)class_2519.method_23256((String)pixels.substring(start, end)));
        }
    }

    public long getTimestamp() {
        if (this.GRAB == null) {
            return 0L;
        }
        return this.GRAB.getTimestamp();
    }

    public void setTimestampSeconds(long timeStampSeconds) {
        if (this.GRAB == null) {
            return;
        }
        try {
            long timestamp = timeStampSeconds * 1000000L;
            if (timestamp > this.GRAB.getLengthInTime()) {
                return;
            }
            this.GRAB.setTimestamp(timestamp);
        }
        catch (NumberFormatException | FFmpegFrameGrabber.Exception throwable) {
            // empty catch block
        }
    }

    protected void fastDisplayImage(BufferedImage bufferedImage) {
        int screenCount = this.SCREEN_META.screens.size();
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        int sectionHeight = Math.round((float)height / (float)screenCount);
        int pixelHeight = height - sectionHeight * (screenCount - 1);
        class_2658[] packets = new class_2658[screenCount];
        packets[0] = new class_2658((class_8710)new FastFrameManipulate(this.SCREEN_META.getMainScreen().method_5628(), this.SCREEN_META.pretty(), width, height, height - pixelHeight, bufferedImage));
        Integer[] ids = this.SCREEN_META.getScreenIDs();
        int length = ids.length;
        while (--length > 0) {
            int screen = ids[length];
            int curHeight = (screenCount - length - 1) * sectionHeight;
            packets[length] = new class_2658((class_8710)new FastFrameManipulate(screen, this.SCREEN_META.pretty(), width, curHeight + sectionHeight, curHeight, bufferedImage));
        }
        class_8113.class_8123 mainScreen = this.SCREEN_META.getMainScreen();
        for (class_5629 connection : ((MixinTrackedEntity)((MixinChunkMap)((class_3215)mainScreen.method_37908().method_8398()).field_17254).getEntityMap().get(mainScreen.method_5628())).getSeenBy()) {
            class_3222 serverPlayer = connection.method_32311();
            if (!ServerPlayNetworking.canSend((class_3222)serverPlayer, FastFrameManipulate.PACKET_TYPE)) continue;
            for (class_2658 packet : packets) {
                connection.method_14364((class_2596)packet);
            }
        }
    }

    public void tick() {
        if (this.SCREEN_META.dirty) {
            this.SCREEN_META.dirty = false;
            this.fixScreens();
        }
    }
}

