/*
 * Decompiled with CFR 0.152.
 */
package de.cjdev.renderra.audio;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;

public class AudioSplitter {
    public static final long CHUNK_SECONDS = 5L;
    public static final long CHUNK_MICROS = 5000000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splitAudioFromVideo(FFmpegFrameGrabber grabber, Path outputFolder) throws IOException, InterruptedException {
        long part = 0L;
        long startMicros = -1L;
        Files.createDirectories(outputFolder, new FileAttribute[0]);
        long startTimestamp = grabber.getTimestamp();
        FFmpegFrameRecorder recorder = null;
        try {
            Frame frame;
            while ((frame = grabber.grabSamples()) != null) {
                if (frame.samples == null) continue;
                long timestamp = grabber.getTimestamp();
                if (recorder == null || timestamp - startMicros >= 5000000L) {
                    if (recorder != null) {
                        recorder.flush();
                        recorder.stop();
                        recorder.release();
                    }
                    String outputFileName = "part" + String.format("%05x", part++) + ".ogg";
                    String outputPath = outputFolder.resolve(outputFileName).toString();
                    recorder = new FFmpegFrameRecorder(outputPath, grabber.getAudioChannels());
                    recorder.setAudioCodec(86021);
                    recorder.setSampleRate(grabber.getSampleRate());
                    recorder.setFormat("ogg");
                    recorder.setAudioBitrate(grabber.getAudioBitrate());
                    recorder.start();
                    startMicros = timestamp;
                }
                recorder.record(frame);
            }
        }
        finally {
            if (recorder != null) {
                recorder.flush();
                recorder.stop();
                recorder.release();
            }
            grabber.setTimestamp(startTimestamp);
        }
    }
}

