/*
 * Decompiled with CFR 0.152.
 */
package de.cjdev.renderra.network;

import de.cjdev.renderra.mixin.MixinChunkMap;
import de.cjdev.renderra.mixin.MixinTrackedEntity;
import de.cjdev.renderra.network.ImageIterable;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2739;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5629;
import net.minecraft.class_6328;
import net.minecraft.class_8113;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

@class_6328
public class FastFrameManipulate
implements class_8710 {
    public static final class_2960 IDENTIFIER = class_2960.method_60654((String)"videoplayer:frame_update");
    public static final class_8710.class_9154<FastFrameManipulate> PACKET_TYPE = new class_8710.class_9154(IDENTIFIER);
    private final int entityID;
    private final Object bufferedImage;
    private final int width;
    private final int height;
    private final int heightOffset;
    private final boolean pretty;
    private class_2540 bufferedPacket;

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PACKET_TYPE;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public <T> T getBufferedImage() {
        return (T)this.bufferedImage;
    }

    public FastFrameManipulate(int entityID, boolean pretty, ImageIterable imageIterable) {
        this.entityID = entityID;
        this.bufferedImage = imageIterable;
        this.width = 0;
        this.height = 0;
        this.heightOffset = 0;
        this.pretty = pretty;
    }

    public FastFrameManipulate(int entityID, boolean pretty, int width, int height, int heightOffset, BufferedImage bufferedImage) {
        this.entityID = entityID;
        this.width = width;
        this.height = height;
        this.heightOffset = heightOffset;
        this.bufferedImage = bufferedImage;
        this.pretty = pretty;
    }

    public void write(class_2540 byteBuf) {
        byteBuf.method_10804(this.entityID);
        byteBuf.method_52964(this.pretty);
        Object object = this.bufferedImage;
        if (object instanceof ImageIterable) {
            ImageIterable imageIterable = (ImageIterable)object;
            int[] palette = imageIterable.palette();
            byteBuf.method_10804(palette.length);
            for (int i : palette) {
                byteBuf.method_10804(i);
            }
            Object object2 = imageIterable.pixelWidths().iterator();
            while (object2.hasNext()) {
                ImageIterable.PixelWidth section = (ImageIterable.PixelWidth)object2.next();
                byteBuf.method_10804(section.consecutive());
                byteBuf.method_10804(section.colorIndex());
            }
        } else {
            FastFrameManipulate.writeImageTiny(byteBuf, (BufferedImage)this.bufferedImage, this.width, this.height, this.heightOffset);
        }
    }

    public static void writeImageTiny(class_2540 byteBuf, BufferedImage image, int width, int height, int heightOffset) {
        int lastColor = -1;
        int consecutivePixels = 0;
        LinkedHashMap<Integer, Integer> palette = new LinkedHashMap<Integer, Integer>();
        int paletteIndex = 0;
        for (int y = heightOffset; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (palette.putIfAbsent(image.getRGB(x, y) & 0xFFFFFF, paletteIndex) != null) continue;
                ++paletteIndex;
            }
        }
        byteBuf.method_10804(paletteIndex);
        for (Integer value : palette.keySet()) {
            byteBuf.method_10804(value.intValue());
        }
        class_2540 pixelsBuf = new class_2540(Unpooled.buffer());
        for (int y = heightOffset; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = image.getRGB(x, y) & 0xFFFFFF;
                if (lastColor == -1) {
                    lastColor = rgb;
                }
                if (rgb == lastColor) {
                    ++consecutivePixels;
                    continue;
                }
                pixelsBuf.method_10804(consecutivePixels);
                pixelsBuf.method_10804(((Integer)palette.get(lastColor)).intValue());
                consecutivePixels = 1;
                lastColor = rgb;
            }
        }
        if (consecutivePixels > 0) {
            pixelsBuf.method_10804(consecutivePixels);
            pixelsBuf.method_10804(((Integer)palette.get(lastColor)).intValue());
        }
        byteBuf.method_52975((ByteBuf)pixelsBuf);
    }

    public static FastFrameManipulate decode(class_2540 byteBuf) {
        int entityID = byteBuf.method_10816();
        boolean pretty = byteBuf.readBoolean();
        return new FastFrameManipulate(entityID, pretty, ImageIterable.read(byteBuf, pretty));
    }

    public static FastFrameManipulate decodeForClient(class_2540 byteBuf) {
        int entityID = byteBuf.method_10816();
        boolean pretty = byteBuf.readBoolean();
        return new FastFrameManipulate(entityID, pretty, ImageIterable.read(byteBuf, pretty, true));
    }

    public void handle(MinecraftServer server, class_3222 player) {
        if (player.method_5691() < 2) {
            return;
        }
        class_1297 class_12972 = player.method_51469().method_8469(this.entityID);
        if (class_12972 instanceof class_8113.class_8123) {
            class_8113.class_8123 textDisplay = (class_8113.class_8123)class_12972;
            this.sendBackDisplay(textDisplay);
        }
    }

    public void sendBackDisplay(class_8113.class_8123 textDisplay) {
        class_5250 text = class_2561.method_43470((String)"").method_27694(style -> style.method_27704(class_2960.method_60655((String)"m", (String)"p")));
        text.method_10855().addAll(((ImageIterable)this.bufferedImage).sections());
        class_2739 vanillaPacket = new class_2739(textDisplay.method_5628(), List.of(new class_2945.class_7834(23, class_2943.field_13317, (Object)text)));
        class_2658 moddedPacket = new class_2658((class_8710)this);
        for (class_5629 connection : ((MixinTrackedEntity)((MixinChunkMap)((class_3215)textDisplay.method_37908().method_8398()).field_17254).getEntityMap().get(textDisplay.method_5628())).getSeenBy()) {
            class_3222 serverPlayer = connection.method_32311();
            if (ServerPlayNetworking.canSend((class_3222)serverPlayer, PACKET_TYPE)) {
                connection.method_14364((class_2596)moddedPacket);
                continue;
            }
            connection.method_14364((class_2596)vanillaPacket);
        }
    }

    public static void register() {
        PayloadTypeRegistry.playC2S().register(PACKET_TYPE, class_8710.method_56484(FastFrameManipulate::write, FastFrameManipulate::decode));
        PayloadTypeRegistry.playS2C().register(PACKET_TYPE, class_8710.method_56484(FastFrameManipulate::write, FastFrameManipulate::decodeForClient));
        ServerPlayNetworking.registerGlobalReceiver(PACKET_TYPE, (payload, context) -> payload.handle(context.server(), context.player()));
    }
}

