/*
 * Decompiled with CFR 0.152.
 */
package de.cjdev.renderra.client;

import com.moulberry.axiom.packets.AxiomServerboundManipulateEntity;
import de.cjdev.renderra.PlaybackHandler;
import de.cjdev.renderra.VideoResult;
import de.cjdev.renderra.client.VideoPlayerClient;
import de.cjdev.renderra.client.network.FrameManipulatePacket;
import de.cjdev.renderra.client.network.TextManipulatePacket;
import de.cjdev.renderra.client.network.UpdateNBTPacket;
import de.cjdev.renderra.client.screen.VideoPlayerScreen;
import de.cjdev.renderra.network.FastFrameManipulate;
import java.awt.image.BufferedImage;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_8710;
import org.bytedeco.javacv.FFmpegFrameGrabber;

@Environment(value=EnvType.CLIENT)
public class ClientPlaybackHandler
extends PlaybackHandler {
    private double SECONDS;
    public boolean warnedNoSupportedProtocol = false;

    @Override
    public class_1937 getLevel() {
        return class_310.method_1551().field_1687;
    }

    @Override
    protected void updateSubtitle(class_2561 text) {
        if (this.SCREEN_META.subtitleScreen == null) {
            return;
        }
        new TextManipulatePacket(this.SCREEN_META.subtitleScreen.method_5667(), text).send();
    }

    @Override
    protected void playSound(class_1297 atEntity, class_3414 soundEvent, class_3419 source, float volume, float pitch) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        class_243 position = atEntity.method_19538();
        class_310.method_1551().field_1724.field_3944.method_45730("playsound " + String.valueOf(soundEvent.comp_3319()) + " " + source.method_14840() + " @a " + position.field_1352 + " " + position.field_1351 + " " + position.field_1350 + " " + volume + " " + pitch + " " + String.valueOf(soundEvent.comp_3320().orElse(Float.valueOf(0.0f))));
    }

    public void deltaTick(class_310 minecraft, double deltaTime) {
        if (!this.playing || this.GRAB == null || minecraft.method_1493() || this.SCREEN_META.screens.isEmpty()) {
            return;
        }
        this.SECONDS += deltaTime;
        if (this.SECONDS >= this.VIDEO_META.frameDelta()) {
            this.SECONDS -= this.VIDEO_META.frameDelta();
            this.processFrame(this.GRAB);
            this.processSubtitles();
            this.processAudio();
        }
    }

    @Override
    public VideoResult syncHz() {
        if (this.VIDEO_META == null || this.VIDEO_META.frameRate() == 0.0) {
            return VideoResult.NO_VIDEO;
        }
        class_310.method_1551().method_1562().method_45730("tick rate " + this.VIDEO_META.frameRate());
        return VideoResult.OK;
    }

    @Override
    public void doNBTMerge(UUID uuid, class_2487 merge) {
        new UpdateNBTPacket(uuid, merge).send();
    }

    @Override
    protected void processFrame(FFmpegFrameGrabber GRAB) {
        if (class_310.method_1551().method_1562() == null) {
            return;
        }
        if (ClientPlayNetworking.canSend(FastFrameManipulate.PACKET_TYPE)) {
            this.processFastFrame(GRAB, this::fastDisplayImage, this::videoDone);
        } else if (ClientPlayNetworking.canSend((class_2960)AxiomServerboundManipulateEntity.IDENTIFIER)) {
            this.processAxiomFrame(GRAB, this::axiomDisplayImage, this::videoDone);
        } else {
            if (!this.warnedNoSupportedProtocol) {
                this.warnedNoSupportedProtocol = true;
                VideoPlayerScreen.doToast("No Supported Protocol");
            }
            this.cleanUpVideo();
        }
    }

    private void axiomDisplayImage(class_2487[] compoundTags) {
        if (VideoPlayerClient.notInGame()) {
            return;
        }
        UUID[] uuids = this.SCREEN_META.getScreenUUIDs();
        int length = uuids.length;
        while (--length != -1) {
            UUID screen = uuids[length];
            class_2487 compoundTag = compoundTags[length];
            if (compoundTag == null) continue;
            new FrameManipulatePacket(screen, compoundTag).send();
        }
    }

    @Override
    protected void fastDisplayImage(BufferedImage bufferedImage) {
        if (VideoPlayerClient.notInGame()) {
            return;
        }
        int screenCount = this.SCREEN_META.screens.size();
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        int sectionHeight = Math.round((float)height / (float)screenCount);
        int pixelHeight = height - sectionHeight * (screenCount - 1);
        ClientPlayNetworking.send((class_8710)new FastFrameManipulate(this.SCREEN_META.getMainScreen().method_5628(), this.SCREEN_META.pretty(), width, height, height - pixelHeight, bufferedImage));
        Integer[] ids = this.SCREEN_META.getScreenIDs();
        int length = ids.length;
        while (--length > 0) {
            int screen = ids[length];
            int curHeight = (screenCount - length - 1) * sectionHeight;
            ClientPlayNetworking.send((class_8710)new FastFrameManipulate(screen, this.SCREEN_META.pretty(), width, curHeight + sectionHeight, curHeight, bufferedImage));
        }
    }
}

