/*
 * Decompiled with CFR 0.152.
 */
package de.cjdev.renderra.subtitle;

import de.cjdev.renderra.subtitle.SimpleMiniMessage;
import de.cjdev.renderra.subtitle.Subtitle;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SRTLoader {
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d+):(\\d+):(\\d+),(\\d+)");

    public static NavigableMap<Long, Subtitle> parseSRT(Path path) throws IOException {
        TreeMap<Long, Subtitle> subtitles = new TreeMap<Long, Subtitle>();
        List<String> lines = Files.readAllLines(path);
        int i = 0;
        while (i < lines.size()) {
            String indexLine;
            if ((indexLine = lines.get(i++).trim()).isEmpty()) continue;
            String timeLine = lines.get(i++).trim();
            String[] parts = timeLine.split(" --> ");
            long start = SRTLoader.parseTime(parts[0]);
            long end = SRTLoader.parseTime(parts[1]);
            StringBuilder text = new StringBuilder();
            while (i < lines.size() && !lines.get(i).trim().isEmpty()) {
                text.append(lines.get(i++)).append("\n");
            }
            String plain = text.toString().trim();
            boolean renderAtTop = plain.startsWith("{\\an8}");
            if (renderAtTop) {
                plain = plain.substring(6);
            }
            subtitles.put(start, new Subtitle(new SimpleMiniMessage(plain).parse()));
            subtitles.put(end, null);
            ++i;
        }
        return subtitles;
    }

    private static long parseTime(String time) {
        Matcher m = TIME_PATTERN.matcher(time);
        if (m.find()) {
            int h = Integer.parseInt(m.group(1));
            int m_ = Integer.parseInt(m.group(2));
            int s = Integer.parseInt(m.group(3));
            int ms = Integer.parseInt(m.group(4));
            return (long)h * 3600000L + (long)m_ * 60000L + (long)s * 1000L + (long)ms;
        }
        throw new IllegalArgumentException("Invalid time format: " + time);
    }

    public static Map.Entry<Long, Subtitle> getSubtitleAt(NavigableMap<Long, Subtitle> map, long timeMs) {
        Map.Entry<Long, Subtitle> entry = map.floorEntry(timeMs);
        return entry == null ? null : (entry.getValue() == null ? null : entry);
    }
}

