/*
 * Decompiled with CFR 0.152.
 */
package dcq.invplus.DcqMenu;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3917;
import net.minecraft.class_3936;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class DcqMenuScreens {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<class_3917<?>, ScreenConstructor<?, ?>> SCREENS = Maps.newHashMap();

    public static <T extends class_1703> void create(class_3917<T> menuType, class_310 minecraft, int i, class_2561 component, String configs) {
        ScreenConstructor<T, ?> screenConstructor = DcqMenuScreens.getConstructor(menuType);
        if (screenConstructor == null) {
            LOGGER.warn("Failed to create screen for dcq menu type: {}", (Object)class_7923.field_41187.method_10221(menuType));
        } else {
            screenConstructor.fromPacket(component, configs, menuType, minecraft, i);
        }
    }

    @Nullable
    private static <T extends class_1703> ScreenConstructor<T, ?> getConstructor(class_3917<T> menuType) {
        return SCREENS.get(menuType);
    }

    public static <M extends class_1703, U extends class_437> void register(class_3917<? extends M> menuType, ScreenConstructor<M, U> screenConstructor) {
        ScreenConstructor<M, U> screenConstructor2 = SCREENS.put(menuType, screenConstructor);
        if (screenConstructor2 != null) {
            throw new IllegalStateException("Duplicate registration for dcq " + String.valueOf(class_7923.field_41187.method_10221(menuType)));
        }
    }

    public static boolean selfTest() {
        boolean bl = false;
        for (class_3917 menuType : class_7923.field_41187) {
            if (SCREENS.containsKey(menuType)) continue;
            LOGGER.debug("Dcq Menu {} has no matching screen", (Object)class_7923.field_41187.method_10221((Object)menuType));
            bl = true;
        }
        return bl;
    }

    @Environment(value=EnvType.CLIENT)
    public static interface ScreenConstructor<T extends class_1703, U extends class_437> {
        default public void fromPacket(class_2561 component, String configs, class_3917<T> menuType, class_310 minecraft, int i) {
            U screen = this.create(menuType.method_17434(i, minecraft.field_1724.method_31548()), minecraft.field_1724.method_31548(), component, configs);
            minecraft.field_1724.field_7512 = ((class_3936)screen).method_17577();
            minecraft.method_1507(screen);
        }

        public U create(T var1, class_1661 var2, class_2561 var3, String var4);
    }
}

