/*
 * Decompiled with CFR 0.152.
 */
package dcq.invplus.configuration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dcq.invplus.Inventory;
import dcq.invplus.TextureLoaded;
import dcq.invplus.configuration.DcqConfigFile;
import dcq.invplus.configuration.DcqConfigs;
import dcq.invplus.configuration.DcqInvConfigs;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_3518;
import org.apache.commons.lang3.StringUtils;

public class DcqInvConfiguration<T extends DcqConfigFile> {
    private final Map<String, T> configsMap = new HashMap<String, T>();

    public T get(String key) {
        return (T)((DcqConfigFile)this.configsMap.get(key));
    }

    public void clear() {
        this.configsMap.clear();
    }

    public void createConditional(Reader reader) {
        for (JsonElement jsonElement : class_3518.method_37165((Reader)reader)) {
            this.prepare_conditional(jsonElement);
        }
    }

    public void createInv(Reader reader) {
        for (JsonElement jsonElement : class_3518.method_37165((Reader)reader)) {
            this.prepare_inventory(jsonElement);
        }
    }

    public void createRegular(Reader reader) {
        for (JsonElement jsonElement : class_3518.method_37165((Reader)reader)) {
            this.prepare_regular(jsonElement);
        }
    }

    private void prepare_regular(JsonElement jsonElement) {
        boolean conditional = false;
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        conditional = jsonObject.has("Conditional");
        if (conditional) {
            Map.Entry jsonElementEntry;
            boolean conditionMet = true;
            Iterator iterator = jsonObject.getAsJsonObject("Conditional").entrySet().iterator();
            while (!(!iterator.hasNext() || StringUtils.equals((CharSequence)((CharSequence)(jsonElementEntry = (Map.Entry)iterator.next()).getKey()), (CharSequence)"Skip") && ((JsonElement)jsonElementEntry.getValue()).getAsBoolean())) {
                if (StringUtils.equals((CharSequence)((CharSequence)jsonElementEntry.getKey()), (CharSequence)"ApplyFromList")) {
                    DcqConfigs conditions = (DcqConfigs)TextureLoaded.ConditionList.get(((JsonElement)jsonElementEntry.getValue()).getAsString());
                    if (!this.resultcheck(conditions)) continue;
                    this.copyFrom(conditions);
                    continue;
                }
                if (this.resultcheck(jsonElementEntry)) continue;
                conditionMet = false;
                break;
            }
            if (!conditionMet) {
                return;
            }
        }
        for (Map.Entry jsonElementEntry : jsonObject.entrySet()) {
            if (StringUtils.equals((CharSequence)((CharSequence)jsonElementEntry.getKey()), (CharSequence)"Conditional")) continue;
            if (this.configsMap.containsKey(jsonElementEntry.getKey())) {
                ((DcqConfigs)this.configsMap.get(jsonElementEntry.getKey())).merge((JsonElement)jsonElementEntry.getValue());
                continue;
            }
            Inventory.LOGGER.info((String)jsonElementEntry.getKey());
            this.configsMap.put((String)jsonElementEntry.getKey(), new DcqConfigs((String)jsonElementEntry.getKey(), ((JsonElement)jsonElementEntry.getValue()).getAsJsonObject()));
        }
    }

    private void prepare_inventory(JsonElement jsonElement) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry jsonElementEntry : jsonObject.entrySet()) {
            if (this.configsMap.containsKey(jsonElementEntry.getKey())) {
                ((DcqInvConfigs)this.configsMap.get(jsonElementEntry.getKey())).merge((JsonElement)jsonElementEntry.getValue());
                continue;
            }
            Inventory.LOGGER.info((String)jsonElementEntry.getKey());
            this.configsMap.put((String)jsonElementEntry.getKey(), new DcqInvConfigs((String)jsonElementEntry.getKey(), ((JsonElement)jsonElementEntry.getValue()).getAsJsonObject()));
        }
    }

    private void prepare_conditional(JsonElement jsonElement) {
        for (Map.Entry jsonElementEntry : jsonElement.getAsJsonObject().entrySet()) {
            JsonObject target = ((JsonElement)jsonElementEntry.getValue()).getAsJsonObject();
            String targetKey = target.get("Target").getAsString();
            this.configsMap.putIfAbsent(targetKey, new DcqConfigs(targetKey, target.getAsJsonObject()));
        }
    }

    private boolean resultcheck(T dcqConfigs) {
        return false;
    }

    private boolean resultcheck(Map.Entry<String, JsonElement> mapEntry) {
        return false;
    }

    private void copyFrom(T configs) {
        if (this.configsMap.containsKey(((DcqConfigFile)configs).getKey())) {
            ((DcqConfigs)this.configsMap.get(((DcqConfigFile)configs).getKey())).merge((DcqConfigs)configs);
        } else {
            this.configsMap.put(((DcqConfigFile)configs).getKey(), configs);
        }
    }

    @FunctionalInterface
    public static interface DcqConfigsReader {
        public void read(Reader var1) throws IOException;
    }
}

