/*
 * Decompiled with CFR 0.152.
 */
package com.cheeseman.superbosses;

import com.cheeseman.superbosses.BossAttributeOperator;
import com.cheeseman.superbosses.BossesAttributeModifier;
import com.cheeseman.superbosses.SuperBossesClass;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class Bossifier {
    public static void bossify(Mob mob, SuperBossesClass bossesClass) {
        AttributeInstance attribute;
        CompoundTag nbt = mob.getPersistentData();
        ListTag trackersList = nbt.getList("superbosses.boss_class_tracker_id", 8);
        trackersList.add((Object)StringTag.valueOf((String)bossesClass.id));
        nbt.put("superbosses.boss_class_tracker_id", (Tag)trackersList);
        Component starting_name = mob.getName();
        String new_name = bossesClass.name_prefix + starting_name.getString() + bossesClass.name_suffix;
        mob.setCustomName((Component)Component.literal((String)new_name));
        for (BossesAttributeModifier modifier : bossesClass.attributeModifiers) {
            if (modifier.operator() != BossAttributeOperator.MULTIPLY || (attribute = mob.getAttribute(modifier.attribute())) == null) continue;
            attribute.setBaseValue(attribute.getBaseValue() * (double)modifier.value());
            if (modifier.attribute() != Attributes.MAX_HEALTH) continue;
            mob.setHealth((float)attribute.getValue());
        }
        for (BossesAttributeModifier modifier : bossesClass.attributeModifiers) {
            if (modifier.operator() != BossAttributeOperator.ADD || (attribute = mob.getAttribute(modifier.attribute())) == null) continue;
            attribute.setBaseValue(attribute.getBaseValue() + (double)modifier.value());
            if (modifier.attribute() != Attributes.MAX_HEALTH) continue;
            mob.setHealth((float)attribute.getValue());
        }
    }
}

